/*
 * Decompiled with CFR 0.152.
 */
package test.functional;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.I_AD_Workflow;
import org.compiere.model.I_S_Resource;
import org.compiere.model.MResource;
import org.compiere.model.MResourceType;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.RoutingService;
import org.eevolution.model.impl.DefaultRoutingServiceImpl;
import test.AdempiereTestCase;

public class DefaultRoutingServiceImplTest
extends AdempiereTestCase {
    RoutingService routingService = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        if (this.getAD_Client_ID() != 11) {
            throw new AdempiereException("AD_Client_ID<>11");
        }
        this.routingService = new DefaultRoutingServiceImpl();
    }

    public void test_estimateWorkingTime() {
        this.assertEstimateWorkingTime(10.0, 10, 0);
        this.assertEstimateWorkingTime(10.0, 10, 1);
        this.assertEstimateWorkingTime(1.6666666666666667, 10, 6);
    }

    public void test_estimateWorkingTime_Qty() {
        this.assertEstimateWorkingTime(10.0, 10, 0);
        this.assertEstimateWorkingTime(10.0, 10, 1);
        this.assertEstimateWorkingTime(1.6666666666666667, 10, 6);
    }

    public void test_calculateNodeDuration() {
        this.assertCalculateDuration(11.0, 100, 100, 10, 0, 0);
        this.assertCalculateDuration(11.0, 100, 100, 10, 1, 0);
        this.assertCalculateDuration(2.666666666666667, 100, 100, 10, 6, 0);
    }

    public void test_calculateWorkflowDuration() {
        MWorkflow wf = this.createWorkflow(1);
        this.createNode(wf, "10", 0, 10, 0, 0);
        this.createNode(wf, "20", 0, 10, 0, 0);
        this.createNode(wf, "30", 0, 10, 0, 0);
        wf = new MWorkflow(this.getCtx(), wf.get_ID(), this.getTrxName());
        this.assertCalculateDuration(wf, 1000, 30000.0);
    }

    public void test_calculateWorkflowDuration_Overlap() {
        MWorkflow wf = this.createWorkflow(1);
        this.createNode(wf, "10", 0, 10, 0, 10);
        this.createNode(wf, "20", 0, 10, 0, 10);
        this.createNode(wf, "30", 0, 10, 0, 0);
        wf = new MWorkflow(this.getCtx(), wf.get_ID(), this.getTrxName());
        this.assertCalculateDuration(wf, 1000, 10200.0);
    }

    protected void assertEstimateWorkingTime(double expectedDuration, int duration, int unitsCycles) {
        int qtyBatchSize = 1;
        int setupTime = 0;
        int overlapUnits = 0;
        MWorkflow wf = this.createWorkflow(qtyBatchSize);
        MWFNode node = this.createNode(wf, "10", setupTime, duration, unitsCycles, overlapUnits);
        BigDecimal durationActual = this.routingService.estimateWorkingTime(node);
        DefaultRoutingServiceImplTest.assertEquals((Object)expectedDuration, (Object)durationActual.doubleValue());
    }

    protected void assertCalculateDuration(double expectedDuration, int qtyBatchSize, int setupTime, int duration, int unitsCycles, int overlapUnits) {
        MWorkflow wf = this.createWorkflow(qtyBatchSize);
        MWFNode node = this.createNode(wf, "10", setupTime, duration, unitsCycles, overlapUnits);
        BigDecimal actualDuration = this.routingService.calculateDuration(node);
        DefaultRoutingServiceImplTest.assertEquals((Object)expectedDuration, (Object)actualDuration.doubleValue());
    }

    protected void assertCalculateDuration(I_AD_Workflow wf, int qty, double durationExpected) {
        I_S_Resource plant = this.getCreatePlant();
        BigDecimal durationReal = this.routingService.calculateDuration(wf, plant, BigDecimal.valueOf(qty));
        DefaultRoutingServiceImplTest.assertEquals((Object)durationExpected, (Object)durationReal.doubleValue());
    }

    private MWorkflow createWorkflow(int qtyBatchSize) {
        String value = "JUnit_Test_" + System.currentTimeMillis();
        MWorkflow wf = new MWorkflow(this.getCtx(), 0, this.getTrxName());
        wf.setWorkflowType("M");
        wf.setProcessType("DR");
        wf.setValue(value);
        wf.setName(value);
        wf.setDescription("Generated by " + ((Object)((Object)this)).getClass());
        wf.setAuthor("JUnit");
        wf.setQtyBatchSize(BigDecimal.valueOf(qtyBatchSize));
        wf.saveEx();
        return wf;
    }

    private MWFNode createNode(MWorkflow wf, String value, int setupTime, int duration, int unitsCycles, int overlapUnits) {
        if (value == null) {
            value = "" + System.currentTimeMillis();
        }
        MWFNode node = new MWFNode(wf, value, value);
        node.setSetupTime(setupTime);
        node.setDuration(duration);
        node.setUnitsCycles(BigDecimal.valueOf(unitsCycles));
        node.setOverlapUnits(overlapUnits);
        node.saveEx();
        return node;
    }

    private I_S_Resource getCreatePlant() {
        String plantValue = "JUnit_Plant_24x7";
        MResource plant = (MResource)new Query(this.getCtx(), "S_Resource", "Value=?", null).setParameters("JUnit_Plant_24x7").setClient_ID().firstOnly();
        if (plant == null) {
            plant = new MResource(this.getCtx(), 0, null);
            plant.setValue("JUnit_Plant_24x7");
        }
        plant.setName("JUnit_Plant_24x7");
        plant.setIsManufacturingResource(true);
        plant.setManufacturingResourceType("PT");
        plant.setPlanningHorizon(365);
        plant.setM_Warehouse_ID(this.getM_Warehouse_ID());
        MResourceType rt = null;
        rt = plant.getS_ResourceType_ID() <= 0 ? new MResourceType(this.getCtx(), 0, null) : new MResourceType(this.getCtx(), plant.getS_ResourceType_ID(), null);
        rt.setValue("JUnit_Plant_24x7");
        rt.setName("JUnit_Plant_24x7");
        rt.setAllowUoMFractions(true);
        rt.setC_TaxCategory_ID(this.getC_TaxCategory_ID());
        rt.setM_Product_Category_ID(this.getM_Product_Category_ID());
        rt.setC_UOM_ID(this.getC_UOM_ID("HR"));
        rt.setIsDateSlot(false);
        rt.setIsTimeSlot(false);
        rt.setIsSingleAssignment(false);
        rt.saveEx();
        plant.setS_ResourceType_ID(rt.getS_ResourceType_ID());
        plant.saveEx();
        return plant;
    }

    public int getM_Warehouse_ID() {
        int M_Warehouse_ID = Env.getContextAsInt(this.getCtx(), "#M_Warehouse_ID");
        if (M_Warehouse_ID <= 0) {
            String sql = "SELECT M_Warehouse_ID FROM M_Warehouse WHERE AD_Client_ID=0 OR AD_Client_ID=" + this.getAD_Client_ID() + " ORDER BY M_Warehouse_ID";
            M_Warehouse_ID = DB.getSQLValueEx(null, sql, new Object[0]);
        }
        return M_Warehouse_ID;
    }

    public int getC_TaxCategory_ID() {
        int id = Env.getContextAsInt(this.getCtx(), "#C_TaxCategory_ID");
        if (id <= 0) {
            String sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE AD_Client_ID IN (0," + this.getAD_Client_ID() + ")" + " AND IsDefault='Y'" + " ORDER BY C_TaxCategory_ID";
            id = DB.getSQLValueEx(null, sql, new Object[0]);
        }
        return id;
    }

    public int getM_Product_Category_ID() {
        return DB.getSQLValueEx(null, "SELECT MIN(M_Product_Category_ID) FROM M_Product_Category WHERE AD_Client_ID IN (0," + this.getAD_Client_ID() + ")" + " AND IsDefault='Y'", new Object[0]);
    }

    public int getC_UOM_ID(String x12de355) {
        String whereClause = "X12DE355=? AND AD_Client_ID IN (0,?)";
        int[] ids = new Query(this.getCtx(), "C_UOM", whereClause, null).setParameters(x12de355, this.getAD_Client_ID()).setOrderBy("AD_Client_ID DESC").getIDs();
        return ids.length > 0 ? ids[0] : -1;
    }
}

