/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class CopyFromOrderWindsor
extends SvrProcess {
    private int p_C_Order_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Order_ID")) {
                    this.p_C_Order_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int To_C_Order_ID = this.getRecord_ID();
        this.log.info("From C_Order_ID=" + this.p_C_Order_ID + " to " + To_C_Order_ID);
        if (To_C_Order_ID == 0) {
            throw new IllegalArgumentException("Target C_Order_ID == 0");
        }
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("Source C_Order_ID == 0");
        }
        MOrder from = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        MOrder to = new MOrder(this.getCtx(), To_C_Order_ID, this.get_TrxName());
        int no = this.copyLinesFrom(to, from, false, false);
        return "@Copied@=" + no;
    }

    public int copyLinesFrom(MOrder order, MOrder otherOrder, boolean counter, boolean copyASI) {
        if (order.isProcessed() || order.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        int i = 0;
        while (i < fromLines.length) {
            MOrderLine line = new MOrderLine(order);
            PO.copyValues(fromLines[i], line, this.getAD_Client_ID(), order.getAD_Org_ID());
            line.setC_Order_ID(order.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(order);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (order.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            if (line.save(this.get_TrxName())) {
                ++count;
            }
            try {
                if (line.get_ValueAsInt("C_OrderLineRef_ID") > 0) {
                    line.set_CustomColumn("C_OrderLineRef_ID", fromLines[i].getC_OrderLine_ID());
                    line.save();
                }
            }
            catch (Exception e) {
                this.log.config(e.toString());
            }
            if (counter) {
                fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
                fromLines[i].save(this.get_TrxName());
            }
            ++i;
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }
}

