/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModWindsorValidShipLine
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWindsorValidShipLine.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInOut ship;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)po).isSOTrx() && ship.getC_DocType().getDocBaseType().compareTo("MMR") != 0) {
            MInOutLine[] sLines = ship.getLines(false);
            int i = 0;
            while (i < sLines.length) {
                MInOutLine sLine = sLines[i];
                if (sLine.getM_Product_ID() > 0 && sLine.getM_Locator_ID() > 0) {
                    BigDecimal total;
                    BigDecimal qtyOtherlines;
                    BigDecimal qtyOnhand = this.getTotalLocator(sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID());
                    if (qtyOnhand == null) {
                        qtyOnhand = Env.ZERO;
                    }
                    if ((qtyOtherlines = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(movementQty) FROM M_InOutLine iol WHERE M_InOut_ID = " + ship.get_ID() + " AND M_Product_ID = " + sLine.getM_Product_ID() + " AND M_Locator_ID = " + sLine.getM_Locator_ID() + " AND M_InOutLine_ID <> " + sLine.get_ID(), new Object[0])) == null) {
                        qtyOtherlines = Env.ZERO;
                    }
                    if ((total = qtyOtherlines.add(sLine.getMovementQty())) == null) {
                        total = Env.ZERO;
                    }
                    if (total.compareTo(qtyOnhand) > 0) {
                        return "ERROR DE STOCK: Producto " + sLine.getM_Product().getName() + " Ubicacion " + sLine.getM_Locator().getValue() + "." + " Actual:" + qtyOnhand + ". Solicitado:" + total;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    private BigDecimal getTotalLocator(int Locator_ID, int Product_ID, int ATTRIBUTESETINSTANCE_ID) {
        String sql = " Select Sum(QtyOnhand) from M_Storage where M_Locator_ID=? and M_Product_ID=? ";
        if (ATTRIBUTESETINSTANCE_ID > 0) {
            sql = String.valueOf(sql) + " and M_ATTRIBUTESETINSTANCE_ID=?";
        }
        BigDecimal rvalue = new BigDecimal(0);
        rvalue = ATTRIBUTESETINSTANCE_ID > 0 ? DB.getSQLValueBD(null, sql, Locator_ID, Product_ID, ATTRIBUTESETINSTANCE_ID) : DB.getSQLValueBD(null, sql, Locator_ID, Product_ID);
        if (rvalue == null) {
            rvalue = new BigDecimal(0);
        }
        return rvalue;
    }
}

