/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ModWindsorUpdateReservedSales
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWindsorUpdateReservedSales.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
        engine.addDocValidate("M_InOut", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInOut ship;
        BigDecimal qtyDif;
        BigDecimal qty;
        int i;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            MOrderLine[] oLines = order.getLines(false, null);
            i = 0;
            while (i < oLines.length) {
                MOrderLine oLine = oLines[i];
                if (oLine.getM_Product_ID() > 0 && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                    MRequisitionLine reqL = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                    qty = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(QtyOrdered) FROM C_OrderLine co INNER JOIN C_Order col ON (col.C_Order_ID = co.C_Order_ID) WHERE DocStatus IN ('CO','CL','IP') AND M_RequisitionLine_ID = ?", reqL.get_ID());
                    qtyDif = reqL.getQty().subtract(qty);
                    DB.executeUpdate("UPDATE M_RequisitionLine SET QtyReserved = " + qtyDif + " WHERE M_RequisitionLine_ID = " + reqL.get_ID(), po.get_TrxName());
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID && (ship = (MInOut)po).isSOTrx()) {
            MInOutLine[] sLines = ship.getLines(false);
            i = 0;
            while (i < sLines.length) {
                MInOutLine sLine = sLines[i];
                if (sLine.getM_Product_ID() > 0 && sLine.getC_OrderLine_ID() > 0) {
                    MOrderLine oLine = new MOrderLine(po.getCtx(), sLine.getC_OrderLine_ID(), po.get_TrxName());
                    qty = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(movementQty) FROM M_InOutLine iol INNER JOIN M_InOut io ON (iol.M_InOut_ID = io.M_InOut_ID) WHERE DocStatus IN ('CO','CL') AND C_OrderLine_ID = ?", oLine.get_ID());
                    qtyDif = oLine.getQtyOrdered().subtract(qty);
                    DB.executeUpdate("UPDATE C_OrderLine SET QtyReserved = " + qtyDif + " WHERE C_OrderLine_ID = " + oLine.get_ID(), po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved, PO po) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement(mysql, po.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), rs, po.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().subtract(reserved));
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                storage.setQtyReserved(reserved.negate());
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public boolean existReservationTable(String Trx2) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement(mysql, Trx2);
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return val;
    }
}

