/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateLineRecauchaje
extends SvrProcess {
    private int p_Order_ID;
    private int p_AssetGroup_ID;

    @Override
    protected void prepare() {
        this.p_Order_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("A_Asset_Group_ID")) {
                    this.p_AssetGroup_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.p_Order_ID, this.get_TrxName());
        int cant = 0;
        String sql = "SELECT A_Asset_ID FROM A_Asset WHERE IsActive = 'Y' AND custodio IN ('TR')  AND M_Warehouse_ID = " + order.getM_Warehouse_ID() + " AND A_Asset_ID NOT IN (SELECT A_Asset_ID FROM C_OrderLine col " + " INNER JOIN C_Order co ON (col.C_Order_ID = co.C_Order_ID)" + " WHERE col.A_Asset_ID IS NOT NULL AND co.DocStatus IN ('DR','IP'))";
        if (this.p_AssetGroup_ID > 0) {
            sql = String.valueOf(sql) + " AND A_Asset_Group_ID = " + this.p_AssetGroup_ID;
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int ID_Charge = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Charge_ID) FROM C_Charge cc INNER JOIN C_ChargeType cct ON (cc.C_ChargeType_ID = cct.C_ChargeType_ID) WHERE cct.Value = 'TCRC'");
                MCharge charge = new MCharge(this.getCtx(), ID_Charge, this.get_TrxName());
                MOrderLine oLine = new MOrderLine(order);
                oLine.setAD_Org_ID(order.getAD_Org_ID());
                oLine.setC_Charge_ID(ID_Charge);
                oLine.setPrice(charge.getChargeAmt());
                oLine.setQty(Env.ONE);
                oLine.setTax();
                oLine.setLineNetAmt();
                oLine.set_CustomColumn("A_Asset_ID", rs.getInt("A_Asset_ID"));
                oLine.setDescription("Generada Automaticamente");
                oLine.set_CustomColumn("A_CreateAsset", true);
                oLine.save();
                ++cant;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se han agregado " + cant + " lineas a la orden";
    }
}

