/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_HR_Bitacora;
import org.compiere.model.X_HR_BitacoraLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateBitacorasConPreHR
extends SvrProcess {
    private Timestamp p_DateTrxFrom;
    private Timestamp p_DateTrxTo;
    private int p_Org_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrxFrom = (Timestamp)para[i].getParameter();
                    this.p_DateTrxTo = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int canthead;
        int cantLine;
        block22: {
            String sqlHR;
            block20: {
                cantLine = 0;
                canthead = 0;
                sqlHR = "SELECT pml.Pre_M_MovementLine_ID,pml.C_BPartner_ID, pm.AD_Org_ID, pml.A_Asset_ID, pm.movementdate  FROM Pre_M_Movement pm  INNER JOIN Pre_M_MovementLine pml ON (pm.Pre_M_Movement_ID = pml.Pre_M_Movement_ID)  WHERE pml.Pre_M_MovementLine_ID NOT IN (SELECT Pre_M_MovementLine_ID FROM hr_bitacoraline biLine INNER JOIN hr_bitacora bi ON (bi.HR_Bitacora_ID = biLine.HR_Bitacora_ID)WHERE DocStatus IN ('CO','DR','IP')  AND Pre_M_MovementLine_ID IS NOT NULL) AND pm.AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND pm.MovementDate BETWEEN ? AND ? ";
                if (this.p_Org_ID > 0) {
                    sqlHR = String.valueOf(sqlHR) + " AND pm.AD_Org_ID = " + this.p_Org_ID + " AND pm.DocStatus IN ('CO','CL')";
                }
                sqlHR = String.valueOf(sqlHR) + " ORDER BY C_BPartner_ID,A_Asset_ID ";
                CPreparedStatement pstmtHR = null;
                ResultSet rsHR = null;
                try {
                    try {
                        pstmtHR = DB.prepareStatement(sqlHR, this.get_TrxName());
                        pstmtHR.setTimestamp(1, this.p_DateTrxFrom);
                        pstmtHR.setTimestamp(2, this.p_DateTrxTo);
                        rsHR = pstmtHR.executeQuery();
                        int ID_BPartner = 0;
                        int ID_Asset = 0;
                        while (rsHR.next()) {
                            X_HR_BitacoraLine line;
                            X_HR_Bitacora bitacora;
                            X_HR_BitacoraLine line2;
                            int ID_Bitacora;
                            ID_BPartner = rsHR.getInt("C_BPartner_ID");
                            ID_Asset = rsHR.getInt("A_Asset_ID");
                            if (ID_BPartner > 0) {
                                ID_Bitacora = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(HR_Bitacora_ID),0) FROM HR_Bitacora WHERE DocStatus NOT IN ('CO','VO')  AND C_BPartner_ID = " + ID_BPartner);
                                if (ID_Bitacora > 0) {
                                    line2 = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                                    line2.setHR_Bitacora_ID(ID_Bitacora);
                                    line2.set_CustomColumn("Pre_M_MovementLine_ID", rsHR.getInt("Pre_M_MovementLine_ID"));
                                    line2.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                                    line2.setDescription("Ingresado Automaticamente");
                                    line2.set_CustomColumn("DateTrx", rsHR.getTimestamp("MovementDate"));
                                    line2.save();
                                    ++cantLine;
                                } else {
                                    bitacora = new X_HR_Bitacora(this.getCtx(), ID_Bitacora, this.get_TrxName());
                                    bitacora.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                                    bitacora.setDateTrx(this.p_DateTrxTo);
                                    bitacora.setC_BPartner_ID(ID_BPartner);
                                    bitacora.setDescription("Generado Automaticamente");
                                    bitacora.setDocStatus("DR");
                                    bitacora.save();
                                    ++canthead;
                                    line = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                                    line.setHR_Bitacora_ID(bitacora.get_ID());
                                    line.set_CustomColumn("Pre_M_MovementLine_ID", rsHR.getInt("Pre_M_MovementLine_ID"));
                                    line.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                                    line.setDescription("Ingresado Automaticamente");
                                    line.set_CustomColumn("DateTrx", rsHR.getTimestamp("MovementDate"));
                                    line.save();
                                    ++cantLine;
                                }
                            }
                            if (ID_Asset <= 0) continue;
                            ID_Bitacora = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(HR_Bitacora_ID),0) FROM HR_Bitacora WHERE DocStatus NOT IN ('CO','VO')  AND A_Asset_ID = " + ID_Asset);
                            if (ID_Bitacora > 0) {
                                line2 = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                                line2.setHR_Bitacora_ID(ID_Bitacora);
                                line2.set_CustomColumn("Pre_M_MovementLine_ID", rsHR.getInt("Pre_M_MovementLine_ID"));
                                line2.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                                line2.setDescription("Ingresado Automaticamente");
                                line2.set_CustomColumn("DateTrx", rsHR.getTimestamp("MovementDate"));
                                line2.save();
                                ++cantLine;
                                continue;
                            }
                            bitacora = new X_HR_Bitacora(this.getCtx(), ID_Bitacora, this.get_TrxName());
                            bitacora.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                            bitacora.setDateTrx(this.p_DateTrxTo);
                            bitacora.setA_Asset_ID(ID_Asset);
                            bitacora.setDescription("Generado Automaticamente");
                            bitacora.setDocStatus("DR");
                            bitacora.save();
                            ++canthead;
                            line = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                            line.setHR_Bitacora_ID(bitacora.get_ID());
                            line.set_CustomColumn("Pre_M_MovementLine_ID", rsHR.getInt("Pre_M_MovementLine_ID"));
                            line.setAD_Org_ID(rsHR.getInt("AD_Org_ID"));
                            line.setDescription("Ingresado Automaticamente");
                            line.set_CustomColumn("DateTrx", rsHR.getTimestamp("MovementDate"));
                            line.save();
                            ++cantLine;
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, String.valueOf(e.getMessage()) + " SQL:" + sqlHR, e);
                        rsHR.close();
                        pstmtHR.close();
                        pstmtHR = null;
                        rsHR = null;
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    rsHR.close();
                    pstmtHR.close();
                    pstmtHR = null;
                    rsHR = null;
                    throw throwable;
                }
                rsHR.close();
                pstmtHR.close();
                pstmtHR = null;
                rsHR = null;
            }
            String sqlPB = "SELECT HR_PreBitacora_ID,C_BPartner_ID, AD_Org_ID, A_Asset_ID, DateTrx FROM HR_Prebitacora  WHERE Processed = 'N' AND AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND (C_BPartner_ID IS NOT NULL OR A_Asset_ID IS NOT NULL )" + " AND DateTrx BETWEEN ? AND ? ";
            if (this.p_Org_ID > 0) {
                sqlHR = String.valueOf(sqlHR) + " AND AD_Org_ID = " + this.p_Org_ID;
            }
            sqlHR = String.valueOf(sqlHR) + " ORDER BY C_BPartner_ID,A_Asset_ID ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlPB, this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_DateTrxFrom);
                    pstmt.setTimestamp(2, this.p_DateTrxTo);
                    rs = pstmt.executeQuery();
                    int ID_BPartner = 0;
                    int ID_Asset = 0;
                    String strID_PreBitacora = "0";
                    while (rs.next()) {
                        ID_BPartner = rs.getInt("C_BPartner_ID");
                        ID_Asset = rs.getInt("A_Asset_ID");
                        int ID_Bitacora = DB.getSQLValue(this.get_TrxName(), "SELECT COALESCE(MAX(HR_Bitacora_ID),0) FROM HR_Bitacora WHERE DocStatus NOT IN ('CO','VO') AND  (C_BPartner_ID = " + ID_BPartner + " OR A_Asset_ID = " + ID_Asset + ")");
                        if (ID_Bitacora > 0) {
                            X_HR_BitacoraLine line = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                            line.setHR_Bitacora_ID(ID_Bitacora);
                            line.setHR_Prebitacora_ID(rs.getInt("HR_PreBitacora_ID"));
                            line.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                            line.setDescription("Ingresado Automaticamente");
                            line.set_CustomColumn("DateTrx", rs.getTimestamp("DateTrx"));
                            line.save();
                            ++cantLine;
                            strID_PreBitacora = String.valueOf(strID_PreBitacora) + "," + rs.getInt("HR_PreBitacora_ID");
                            continue;
                        }
                        X_HR_Bitacora bitacora = new X_HR_Bitacora(this.getCtx(), ID_Bitacora, this.get_TrxName());
                        bitacora.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                        bitacora.setDateTrx(this.p_DateTrxTo);
                        if (ID_BPartner > 0) {
                            bitacora.setC_BPartner_ID(ID_BPartner);
                        }
                        if (ID_Asset > 0) {
                            bitacora.setA_Asset_ID(ID_Asset);
                        }
                        bitacora.setDescription("Generado Automaticamente");
                        bitacora.setDocStatus("DR");
                        bitacora.save();
                        ++canthead;
                        X_HR_BitacoraLine line = new X_HR_BitacoraLine(this.getCtx(), 0, this.get_TrxName());
                        line.setHR_Bitacora_ID(bitacora.get_ID());
                        line.setHR_Prebitacora_ID(rs.getInt("HR_PreBitacora_ID"));
                        line.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                        line.setDescription("Ingresado Automaticamente");
                        line.set_CustomColumn("DateTrx", rs.getTimestamp("DateTrx"));
                        line.save();
                        ++cantLine;
                        strID_PreBitacora = String.valueOf(strID_PreBitacora) + "," + rs.getInt("HR_PreBitacora_ID");
                    }
                    DB.executeUpdate("UPDATE HR_Prebitacora SET Processed = 'Y' WHERE HR_Prebitacora_ID IN (" + strID_PreBitacora + ")", this.get_TrxName());
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(e.getMessage()) + " SQL:" + sqlPB, e);
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                    rs = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                rs.close();
                pstmt.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            rs = null;
        }
        return "Se han generado " + canthead + " bitacoras. Se han agregado " + cantLine + " lineas";
    }
}

