/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MCash;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CompleteCCash
extends SvrProcess {
    private Timestamp p_DateTrxFrom;
    private Timestamp p_DateTrxTo;
    private int p_Org_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateTrx")) {
                    this.p_DateTrxFrom = (Timestamp)para[i].getParameter();
                    this.p_DateTrxTo = (Timestamp)para[i].getParameter_To();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        int cantHeadVoided;
        int canthead;
        block8: {
            canthead = 0;
            cantHeadVoided = 0;
            String sql = "SELECT C_Cash_ID  FROM C_Cash cc  WHERE StatementDate BETWEEN ? AND ?  AND DocStatus IN ('DR','IN') AND cc.IsApproved = 'Y' ";
            if (this.p_Org_ID > 0) {
                sql = String.valueOf(sql) + " AND cc.AD_Org_ID = " + this.p_Org_ID;
            }
            sql = String.valueOf(sql) + " ORDER BY C_Cash_ID ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_DateTrxFrom);
                    pstmt.setTimestamp(2, this.p_DateTrxTo);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MCash cash = new MCash(this.getCtx(), rs.getInt("C_Cash_ID"), this.get_TrxName());
                        int cantFF = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM C_CashLine WHERE IsActive = 'Y' AND CashType = 'R' AND C_Cash_ID=" + cash.get_ID());
                        if (cantFF <= 0) continue;
                        BigDecimal amtValid = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(Amount) FROM C_CashLine  WHERE IsActive = 'Y' AND C_Cash_ID=" + cash.get_ID(), new Object[0]);
                        if (amtValid == null || amtValid.compareTo(Env.ZERO) <= 0) {
                            cash.setDocStatus("DR");
                            cash.processIt("VO");
                            if (!cash.save()) continue;
                            ++cantHeadVoided;
                            continue;
                        }
                        cash.setDocStatus("DR");
                        cash.processIt("CO");
                        if (!cash.save()) continue;
                        ++canthead;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, String.valueOf(e.getMessage()) + " SQL:" + sql, e);
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                    rs = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                rs.close();
                pstmt.close();
                pstmt = null;
                rs = null;
                throw throwable;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            rs = null;
        }
        return "Se han completado " + canthead + " fondos fijo. Se han anulado " + cantHeadVoided + " fondos fijos";
    }
}

