/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_MovementLine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Mod_TSM_ValidacionDetKmInicio
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(Mod_TSM_ValidacionDetKmInicio.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_MovementLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_M_MovementLine.Table_ID) {
            BigDecimal maxKmLine;
            X_M_MovementLine mml = (X_M_MovementLine)po;
            MMovement mo = new MMovement(po.getCtx(), mml.getM_Movement_ID(), po.get_TrxName());
            BigDecimal kmSalida = (BigDecimal)mml.get_Value("TP_FinalKM");
            int cantLineas = DB.getSQLValue(po.get_TrxName(), "select count(1) from m_movementLine where M_Movement_ID=? and m_movementLine_id <> ?", mo.get_ID(), mml.get_ID());
            if (cantLineas < 1) {
                maxKmLine = (BigDecimal)mo.get_Value("TP_InicialKM");
            } else {
                String sqlV1 = "select coalesce((max(mml.TP_inicialkm)),0) from m_movementLine mml inner join m_movement mm on (mml.m_movement_ID = mm.m_movement_ID) where mm.TP_Asset_ID = ? and mm.docstatus <> 'VO' and m_movementLine_ID <> ?";
                maxKmLine = DB.getSQLValueBD(po.get_TrxName(), sqlV1, mo.get_ValueAsInt("TP_Asset_ID"), mml.get_ID());
            }
            String activity = mml.get_ValueAsString("TP_ActivityCode");
            if (maxKmLine != null && activity.equalsIgnoreCase("01")) {
                BigDecimal maxKmCalLine = maxKmLine.add(Env.ONE);
                if (kmSalida.compareTo(maxKmLine) < 0 || kmSalida.compareTo(maxKmCalLine) > 0) {
                    return "Odometro Inicial Fuera de Rango. Ultimo odometro: " + maxKmLine;
                }
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

