/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMValidQtyReceipt
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMValidQtyReceipt.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("M_InOutLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MInOutLine.Table_ID) {
            MInOutLine iLine = (MInOutLine)po;
            MInOut receipt = new MInOut(po.getCtx(), iLine.getM_InOut_ID(), po.get_TrxName());
            if (!receipt.isSOTrx() && iLine.getC_OrderLine_ID() > 0) {
                MOrderLine oLine = new MOrderLine(po.getCtx(), iLine.getC_OrderLine_ID(), po.get_TrxName());
                String sqlVal = "SELECT SUM(miol.qtyEntered) FROM M_InOutLine miol  INNER JOIN M_InOut mio on (miol.M_InOut_ID = mio.M_InOut_ID) WHERE mio.DocStatus IN ('CO','CL','DR','IP')  AND mio.Reversal_ID IS NULL AND miol.C_OrderLine_ID = " + iLine.getC_OrderLine_ID() + " AND miol.M_InOutLine_ID <> " + iLine.get_ID();
                BigDecimal qtyTotal = DB.getSQLValueBD(po.get_TrxName(), sqlVal, new Object[0]);
                if (qtyTotal == null) {
                    qtyTotal = Env.ZERO;
                }
                if ((qtyTotal = qtyTotal.add(iLine.getQtyEntered())).compareTo(oLine.getQtyEntered()) > 0 && receipt.getReversal_ID() <= 0) {
                    return "Cantidad Supera Cantidad de la Orden";
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

