/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_OT;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMValidKMAssetOT
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMValidKMAssetOT.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("MP_OT", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal amtLog;
        BigDecimal actualKm;
        X_MP_OT ot;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 4 || type == 5) && po.get_Table_ID() == X_MP_OT.Table_ID && po.is_ValueChanged("DocStatus") && (ot = (X_MP_OT)po).getDocStatus().compareTo("CO") == 0 && (actualKm = (BigDecimal)ot.get_Value("tsm_km")) != null && actualKm.compareTo(Env.ZERO) > 0 && ot.getA_Asset_ID() > 0 && (amtLog = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(ml.amt)  FROM A_Asset aa  INNER JOIN MP_AssetMeter am ON (aa.A_Asset_ID = am.A_Asset_ID)  INNER JOIN MP_AssetMeter_Log ml ON (am.MP_AssetMeter_ID = ml.MP_AssetMeter_ID) INNER JOIN MP_Meter me ON (me.MP_Meter_ID = am.MP_Meter_ID)  WHERE upper(me.name) like 'KM' AND aa.A_Asset_ID = " + ot.getA_Asset_ID() + " AND aa.IsActive = 'Y' AND ml.IsActive = 'Y'", new Object[0])) != null && amtLog.compareTo(Env.ZERO) > 0 && actualKm.compareTo(amtLog) <= 0) {
            throw new AdempiereException("No se puede completar OT. Ultimo odometro registrado " + amtLog);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

