/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModTSMUpAssetCustodio
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMUpAssetCustodio.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", this);
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MAsset asset;
        int i;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInOut.Table_ID) {
            MInOut receipt = (MInOut)po;
            MInOutLine[] rlines = receipt.getLines(false);
            i = 0;
            while (i < rlines.length) {
                MInOutLine rline = rlines[i];
                if (rline.get_ValueAsInt("A_Asset_ID") > 0 && rline.getC_Charge().getC_ChargeType().getValue().compareToIgnoreCase("TCRC") == 0) {
                    asset = new MAsset(po.getCtx(), rline.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                    asset.set_CustomColumn("custodio", "TN");
                    asset.save();
                }
                if (rline.get_ValueAsInt("A_Asset_ID") > 0 && rline.getC_Charge().getC_ChargeType().getValue().compareToIgnoreCase("TCBN") == 0) {
                    asset = new MAsset(po.getCtx(), rline.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                    asset.set_CustomColumn("custodio", "DB");
                    asset.setIsActive(false);
                    asset.save();
                    DB.executeUpdate("UPDATE M_InOutLine SET MovementQty = 0 WHERE M_InOutLine_ID = " + rline.get_ID(), po.get_TrxName());
                }
                if (rline.get_ValueAsInt("A_Asset_ID") > 0 && rline.getC_Charge().getC_ChargeType().getValue().compareToIgnoreCase("TCAF") == 0) {
                    asset = new MAsset(po.getCtx(), rline.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                    asset.set_CustomColumn("custodio", "AN");
                    asset.save();
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)po;
            MOrderLine[] olines = order.getLines();
            i = 0;
            while (i < olines.length) {
                MOrderLine oline = olines[i];
                if (oline.get_ValueAsInt("A_Asset_ID") > 0 && oline.getC_Charge().getC_ChargeType().getValue().compareToIgnoreCase("TCRC") == 0) {
                    asset = new MAsset(po.getCtx(), oline.get_ValueAsInt("A_Asset_ID"), po.get_TrxName());
                    asset.set_CustomColumn("custodio", "ER");
                    asset.save();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    public static boolean isNumeric(String str) {
        return str.matches("[+-]?\\d*(\\.\\d+)?") && !str.equals("");
    }
}

