/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MMovement;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_MP_AssetMeter;
import org.compiere.model.X_MP_AssetMeter_Log;
import org.compiere.model.X_M_MovementLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModTSMInsertAssetMeterHR
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModTSMInsertAssetMeterHR.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_MovementLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_M_MovementLine.Table_ID) {
            X_M_MovementLine HRLine = (X_M_MovementLine)po;
            BigDecimal dif = (BigDecimal)HRLine.get_Value("TP_InicialKM");
            if (dif == null) {
                dif = Env.ZERO;
            }
            if ((dif = dif.subtract((BigDecimal)HRLine.get_Value("TP_FinalKM"))) == null) {
                dif = Env.ZERO;
            }
            if (dif.compareTo(Env.ZERO) > 0) {
                X_MP_AssetMeter_Log aMetLog;
                X_MP_AssetMeter aMeter;
                ResultSet rs;
                CPreparedStatement pstmt;
                Timestamp lastDate;
                BigDecimal lastOdo;
                int ID_AssetMLog;
                String sqlLast;
                MMovement mov = new MMovement(po.getCtx(), HRLine.getM_Movement_ID(), po.get_TrxName());
                if (mov.get_ValueAsInt("TP_Asset_Id") > 0) {
                    sqlLast = "SELECT * FROM MP_AssetMeter_Log ml INNER JOIN MP_AssetMeter m ON (ml.MP_AssetMeter_ID = m.MP_AssetMeter_ID) WHERE ml.IsActive='Y' AND A_Asset_ID = " + mov.get_ValueAsInt("TP_Asset_Id") + " AND MP_Meter_ID=1000001" + " ORDER BY ml.amt Desc";
                    ID_AssetMLog = 0;
                    lastOdo = Env.ZERO;
                    lastDate = null;
                    pstmt = DB.prepareStatement(sqlLast, po.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        lastOdo = rs.getBigDecimal("amt");
                        lastDate = rs.getTimestamp("DateTrx");
                        ID_AssetMLog = rs.getInt("MP_AssetMeter_Log_ID");
                    }
                    if (lastDate != null && lastOdo != null && lastOdo.compareTo(Env.ZERO) > 0) {
                        if (mov.getMovementDate().compareTo(lastDate) > 0) {
                            int IDAMeter = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(MP_AssetMeter_ID) FROM MP_AssetMeter m  WHERE A_Asset_ID = " + mov.get_ValueAsInt("TP_Asset_Id") + " AND MP_Meter_ID=1000001");
                            if (IDAMeter <= 0) {
                                aMeter = new X_MP_AssetMeter(po.getCtx(), 0, po.get_TrxName());
                                aMeter.setA_Asset_ID(mov.get_ValueAsInt("TP_Asset_Id"));
                                aMeter.set_CustomColumn("MP_Meter_ID", 1000001);
                                aMeter.setName(" Auto.");
                                aMeter.save();
                                IDAMeter = aMeter.get_ID();
                            }
                            aMetLog = new X_MP_AssetMeter_Log(po.getCtx(), 0, po.get_TrxName());
                            aMetLog.setMP_AssetMeter_ID(IDAMeter);
                            aMetLog.setAD_Org_ID(mov.getAD_Org_ID());
                            aMetLog.setDateTrx(mov.getMovementDate());
                            aMetLog.setAD_User_ID(mov.getCreatedBy());
                            aMetLog.setAmt(lastOdo.add(dif));
                            aMetLog.setcurrentamt(lastOdo.add(dif));
                            aMetLog.save();
                        } else {
                            X_MP_AssetMeter_Log aMetLog2 = new X_MP_AssetMeter_Log(po.getCtx(), ID_AssetMLog, po.get_TrxName());
                            aMetLog2.setAmt(lastOdo.add(dif));
                            aMetLog2.setcurrentamt(lastOdo.add(dif));
                            aMetLog2.save();
                        }
                    }
                }
                if (mov.get_ValueAsInt("tp_asset_id2") > 0) {
                    sqlLast = "SELECT * FROM MP_AssetMeter_Log ml INNER JOIN MP_AssetMeter m ON (ml.MP_AssetMeter_ID = m.MP_AssetMeter_ID) WHERE ml.IsActive='Y' AND A_Asset_ID = " + mov.get_ValueAsInt("tp_asset_id2") + " AND MP_Meter_ID=1000001" + " ORDER BY ml.amt Desc";
                    ID_AssetMLog = 0;
                    lastOdo = Env.ZERO;
                    lastDate = null;
                    pstmt = DB.prepareStatement(sqlLast, po.get_TrxName());
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        lastOdo = rs.getBigDecimal("amt");
                        lastDate = rs.getTimestamp("DateTrx");
                        ID_AssetMLog = rs.getInt("MP_AssetMeter_Log_ID");
                    }
                    if (lastDate != null && lastOdo != null && lastOdo.compareTo(Env.ZERO) > 0) {
                        if (mov.getMovementDate().compareTo(lastDate) > 0) {
                            int IDAMeter = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(MP_AssetMeter_ID) FROM MP_AssetMeter m  WHERE A_Asset_ID = " + mov.get_ValueAsInt("tp_asset_id2") + " AND MP_Meter_ID=1000001");
                            if (IDAMeter <= 0) {
                                aMeter = new X_MP_AssetMeter(po.getCtx(), 0, po.get_TrxName());
                                aMeter.setA_Asset_ID(mov.get_ValueAsInt("tp_asset_id2"));
                                aMeter.set_CustomColumn("MP_Meter_ID", 1000001);
                                aMeter.setName(" Auto.");
                                aMeter.save();
                                IDAMeter = aMeter.get_ID();
                            }
                            aMetLog = new X_MP_AssetMeter_Log(po.getCtx(), 0, po.get_TrxName());
                            aMetLog.setMP_AssetMeter_ID(IDAMeter);
                            aMetLog.setAD_Org_ID(mov.getAD_Org_ID());
                            aMetLog.setDateTrx(mov.getMovementDate());
                            aMetLog.setAD_User_ID(mov.getCreatedBy());
                            aMetLog.setAmt(lastOdo.add(dif));
                            aMetLog.setcurrentamt(lastOdo.add(dif));
                            aMetLog.save();
                        } else {
                            X_MP_AssetMeter_Log aMetLog3 = new X_MP_AssetMeter_Log(po.getCtx(), ID_AssetMLog, po.get_TrxName());
                            aMetLog3.setAmt(lastOdo.add(dif));
                            aMetLog3.setcurrentamt(lastOdo.add(dif));
                            aMetLog3.save();
                        }
                    }
                }
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

