/*
 * Decompiled with CFR 0.152.
 */
package org.tc.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModUpdateAmtShipment
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModUpdateAmtShipment.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("M_InOutLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInOutLine.Table_ID) {
            MInOutLine shline = (MInOutLine)po;
            MInOut ship = new MInOut(po.getCtx(), shline.getM_InOut_ID(), po.get_TrxName());
            if (ship.isSOTrx() && shline.get_ValueAsBoolean("ContingencyApproval")) {
                BigDecimal amtAcum = (BigDecimal)shline.get_Value("ContingencyAmt");
                BigDecimal amt = (BigDecimal)shline.get_Value("ContingencyAmt2");
                if (amtAcum == null) {
                    amtAcum = Env.ZERO;
                }
                if (amt == null) {
                    amt = Env.ZERO;
                }
                amtAcum = amtAcum.add(amt);
                amt = Env.ZERO;
                shline.set_CustomColumn("ContingencyAmt", amtAcum);
                shline.set_CustomColumn("ContingencyAmt2", amt);
                shline.set_CustomColumn("ContingencyApproval", false);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

