/*
 * Decompiled with CFR 0.152.
 */
package org.prototipos.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateInvoiceFromPR
extends SvrProcess {
    private int Record_ID;
    private String p_DocumentNo;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocumentNo")) {
                    this.p_DocumentNo = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_C_PaymentRequest pr = new X_C_PaymentRequest(Env.getCtx(), this.Record_ID, this.get_TrxName());
        String requestType = pr.getRequestType();
        requestType = Character.toString(requestType.charAt(0));
        if (pr.get_ValueAsInt("C_Invoice_ID") > 0) {
            this.log.log(Level.SEVERE, "Invoice Already Generated");
            throw new IllegalArgumentException("Factura ya generada");
        }
        if (requestType.equals("R") && pr.getDocStatus().equals("WC")) {
            MInvoice inv = new MInvoice(this.getCtx(), 0, this.get_TrxName());
            inv.setClientOrg(pr.getAD_Client_ID(), pr.getAD_Org_ID());
            inv.setIsSOTrx(false);
            MBPartner bp = new MBPartner(this.getCtx(), pr.getC_BPartner_ID(), this.get_TrxName());
            inv.setBPartner(bp);
            inv.setDocumentNo(this.p_DocumentNo);
            int id_PriceList = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(M_PriceList_ID) FROM M_PriceList WHERE IsDefault = 'Y' AND IsSOPriceList = 'N'");
            inv.setM_PriceList_ID(id_PriceList);
            inv.setC_Currency_ID(pr.getC_Currency_ID());
            inv.setDateInvoiced(pr.getDateTrx());
            inv.setDateAcct(pr.getDateAcct());
            inv.setDescription("Generado Automaticamente desde Solicitud de Pago " + pr.getDocumentNo());
            if (!inv.save()) {
                throw new IllegalArgumentException("Cannot save Invoice");
            }
            MInvoiceLine iLine = new MInvoiceLine(inv);
            iLine.setC_Invoice_ID(inv.get_ID());
            iLine.setC_Charge_ID(pr.getC_Charge_ID());
            iLine.setQtyEntered(Env.ONE);
            iLine.setQtyInvoiced(Env.ONE);
            iLine.setPriceActual(pr.getPayAmt());
            iLine.setPriceEntered(pr.getPayAmt());
            int id_Tax = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Tax_ID) FROM C_Tax WHERE IsTaxExempt = 'N' AND IsDefault='Y'");
            iLine.setC_Tax_ID(id_Tax);
            if (!iLine.save()) {
                throw new IllegalArgumentException("Cannot save Invoice Line");
            }
            MInvoiceLine iLine2 = new MInvoiceLine(inv);
            iLine2.setC_Invoice_ID(inv.get_ID());
            int ID_Charge2 = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Charge_ID) FROM C_Charge cc INNER JOIN C_ChargeType ct ON (cc.C_ChargeType_ID = ct.C_ChargeType_ID) WHERE ct.value = 'TCET'");
            iLine2.setC_Charge_ID(ID_Charge2);
            MCharge charge2 = new MCharge(this.getCtx(), ID_Charge2, this.get_TrxName());
            iLine2.setQtyEntered(Env.ONE);
            iLine2.setQtyInvoiced(Env.ONE);
            BigDecimal amtLine2 = pr.getPayAmt().divide(Env.ONEHUNDRED).multiply(charge2.getChargeAmt());
            iLine2.setPriceActual(amtLine2.negate());
            iLine2.setPriceEntered(amtLine2.negate());
            int id_TaxEx = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Tax_ID) FROM C_Tax WHERE IsTaxExempt = 'Y'");
            iLine2.setC_Tax_ID(id_TaxEx);
            if (!iLine2.save()) {
                throw new IllegalArgumentException("Cannot save Invoice Line");
            }
            MInvoiceLine iLine3 = new MInvoiceLine(inv);
            iLine3.setC_Invoice_ID(inv.get_ID());
            int ID_Charge3 = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Charge_ID) FROM C_Charge cc INNER JOIN C_ChargeType ct ON (cc.C_ChargeType_ID = ct.C_ChargeType_ID) WHERE ct.value = 'TCICA'");
            iLine3.setC_Charge_ID(ID_Charge3);
            MCharge charge3 = new MCharge(this.getCtx(), ID_Charge3, this.get_TrxName());
            iLine3.setQtyEntered(Env.ONE);
            iLine3.setQtyInvoiced(Env.ONE);
            BigDecimal amtLine3 = pr.getPayAmt().divide(Env.ONEHUNDRED).multiply(charge3.getChargeAmt());
            iLine3.setPriceActual(amtLine3.negate());
            iLine3.setPriceEntered(amtLine3.negate());
            iLine3.setC_Tax_ID(id_TaxEx);
            if (!iLine3.save()) {
                throw new IllegalArgumentException("Cannot save Invoice Line");
            }
            inv.calculateTaxTotal();
            inv.save();
            pr.set_CustomColumn("C_Invoice_ID", inv.get_ID());
            pr.setPayAmt(inv.getGrandTotal());
            pr.save();
        }
        return "Factura Generada";
    }
}

