/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPetroAmericaCustomTax
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPetroAmericaCustomTax.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        MInvoice inv2;
        MInvoiceLine iLine;
        BigDecimal taxNewLine;
        MOrderLine oLine;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == MOrderLine.Table_ID) {
            oLine = (MOrderLine)po;
            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
            if (order.getDocStatus().compareToIgnoreCase("CO") != 0 && order.getDocStatus().compareToIgnoreCase("CL") != 0) {
                if (oLine.getM_Product_ID() > 0) {
                    int ID_PriceListVersion = 0;
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    String sql = "SELECT plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            pstmt.setInt(1, oLine.getC_Order().getM_PriceList_ID());
                            pstmt.setTimestamp(2, oLine.getC_Order().getDateOrdered());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                ID_PriceListVersion = rs.getInt(1);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.SEVERE, sql, e);
                            String string = e.getLocalizedMessage();
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            return string;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    BigDecimal taxNewPro = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(FixedTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + ID_PriceListVersion + " AND M_Product_ID = " + oLine.getM_Product_ID(), new Object[0]);
                    BigDecimal taxNewLine2 = (BigDecimal)oLine.get_Value("FixedTax");
                    if ((taxNewLine2 == null || taxNewLine2.compareTo(Env.ZERO) == 0) && taxNewPro != null) {
                        oLine.set_CustomColumn("FixedTax", taxNewPro);
                        taxNewLine2 = taxNewPro;
                    }
                    if (taxNewLine2 != null) {
                        taxNewPro = taxNewLine2.multiply(oLine.getQtyOrdered());
                        oLine.set_CustomColumn("FixedTaxAmt", taxNewPro);
                    }
                    taxNewPro = null;
                    taxNewLine2 = null;
                    taxNewPro = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(VariableTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + ID_PriceListVersion + " AND M_Product_ID = " + oLine.getM_Product_ID(), new Object[0]);
                    taxNewLine2 = (BigDecimal)oLine.get_Value("VariableTax");
                    if ((taxNewLine2 == null || taxNewLine2.compareTo(Env.ZERO) == 0) && taxNewPro != null) {
                        oLine.set_CustomColumn("VariableTax", taxNewPro);
                        taxNewLine2 = taxNewPro;
                    }
                    if (taxNewLine2 != null) {
                        taxNewPro = taxNewLine2.multiply(oLine.getQtyOrdered());
                        oLine.set_CustomColumn("VariableTaxAmt", taxNewPro);
                    }
                }
                BigDecimal IVATax = (BigDecimal)oLine.get_Value("IVATaxAmt");
                if (oLine.getC_Tax().getName().toLowerCase().contains("iva")) {
                    IVATax = oLine.getLineNetAmt().multiply(oLine.getC_Tax().getRate());
                    IVATax = IVATax.divide(Env.ONEHUNDRED);
                    IVATax = IVATax.setScale(10, 6);
                    oLine.set_CustomColumn("IVATaxAmt", IVATax);
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MOrderLine.Table_ID) {
            oLine = (MOrderLine)po;
            BigDecimal taxNewLine3 = Env.ZERO;
            if ((BigDecimal)oLine.get_Value("FixedTaxAmt") != null) {
                taxNewLine3 = taxNewLine3.add((BigDecimal)oLine.get_Value("FixedTaxAmt"));
            }
            if ((BigDecimal)oLine.get_Value("VariableTax") != null) {
                taxNewLine3 = taxNewLine3.add((BigDecimal)oLine.get_Value("VariableTaxAmt"));
            }
            if ((BigDecimal)oLine.get_Value("IVATaxAmt") != null) {
                taxNewLine3 = taxNewLine3.add((BigDecimal)oLine.get_Value("IVATaxAmt"));
            }
            if (taxNewLine3 != null) {
                taxNewLine3 = taxNewLine3.setScale(10, 6);
                BigDecimal newGrandTotalSD = oLine.getC_Order().getTotalLines().add(taxNewLine3).setScale(0, RoundingMode.HALF_EVEN);
                DB.executeUpdate("UPDATE C_Order SET GrandTotal = " + newGrandTotalSD + " " + " WHERE C_Order_ID = " + oLine.getC_Order_ID(), po.get_TrxName());
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)po;
            MOrderLine[] olines = order.getLines();
            taxNewLine = Env.ZERO;
            int i = 0;
            while (i < olines.length) {
                MOrderLine oline = olines[i];
                if ((BigDecimal)oline.get_Value("FixedTaxAmt") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("FixedTaxAmt"));
                }
                if ((BigDecimal)oline.get_Value("VariableTax") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("VariableTaxAmt"));
                }
                if ((BigDecimal)oline.get_Value("IVATaxAmt") != null) {
                    taxNewLine = taxNewLine.add((BigDecimal)oline.get_Value("IVATaxAmt"));
                }
                ++i;
            }
            if (taxNewLine != null) {
                taxNewLine = taxNewLine.setScale(10, 6);
                BigDecimal newGrandTotalSD = order.getTotalLines().add(taxNewLine).setScale(0, RoundingMode.HALF_EVEN);
                DB.executeUpdate("UPDATE C_Order SET GrandTotal = " + newGrandTotalSD + " " + " WHERE C_Order_ID = " + order.get_ID(), po.get_TrxName());
            }
        }
        if ((type == 1 || type == 2) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            iLine = (MInvoiceLine)po;
            inv2 = new MInvoice(po.getCtx(), iLine.getC_Invoice_ID(), po.get_TrxName());
            if (inv2.getC_DocTypeTarget().getDocBaseType().compareTo("APB") != 0 && (inv2.isSOTrx() && inv2.getDocStatus().compareToIgnoreCase("CO") != 0 || po.is_ValueChanged("QtyEntered") && inv2.getDocStatus().compareToIgnoreCase("CO") != 0 || po.is_ValueChanged("IVATaxAmt") && inv2.getDocStatus().compareToIgnoreCase("CO") != 0)) {
                MOrderLine oLine2 = null;
                if (iLine.getC_OrderLine_ID() > 0) {
                    oLine2 = new MOrderLine(po.getCtx(), iLine.getC_OrderLine_ID(), po.get_TrxName());
                }
                if (iLine.getM_Product_ID() > 0) {
                    BigDecimal taxOLine = null;
                    int ID_PriceListVersion = 0;
                    CPreparedStatement pstmt = null;
                    ResultSet rs = null;
                    String sql = "SELECT plv.M_PriceList_Version_ID,plv.ValidFrom FROM M_PriceList pl,C_Currency c,M_PriceList_Version plv WHERE pl.C_Currency_ID=c.C_Currency_ID AND pl.M_PriceList_ID=plv.M_PriceList_ID AND pl.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                    try {
                        try {
                            pstmt = DB.prepareStatement(sql, null);
                            pstmt.setInt(1, iLine.getC_Invoice().getM_PriceList_ID());
                            pstmt.setTimestamp(2, iLine.getC_Invoice().getDateInvoiced());
                            rs = pstmt.executeQuery();
                            if (rs.next()) {
                                ID_PriceListVersion = rs.getInt(1);
                            }
                        }
                        catch (SQLException e) {
                            log.log(Level.SEVERE, sql, e);
                            String string = e.getLocalizedMessage();
                            DB.close(rs, pstmt);
                            rs = null;
                            pstmt = null;
                            return string;
                        }
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    if (oLine2 != null && (taxOLine = (BigDecimal)oLine2.get_Value("FixedTax")) != null) {
                        iLine.set_CustomColumn("FixedTax", taxOLine);
                    }
                    BigDecimal taxNewProd = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(FixedTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + ID_PriceListVersion + " AND M_Product_ID = " + iLine.getM_Product_ID(), new Object[0]);
                    BigDecimal taxNewLine4 = (BigDecimal)iLine.get_Value("FixedTax");
                    if (taxNewLine4 == null && taxNewProd != null) {
                        iLine.set_CustomColumn("FixedTax", taxNewProd);
                        taxNewLine4 = taxNewProd;
                    }
                    if (taxNewLine4 != null) {
                        taxNewProd = taxNewLine4.multiply(iLine.getQtyInvoiced());
                        iLine.set_CustomColumn("FixedTaxAmt", taxNewProd);
                    }
                    if (oLine2 != null && (taxOLine = (BigDecimal)oLine2.get_Value("VariableTax")) != null) {
                        iLine.set_CustomColumn("VariableTax", taxOLine);
                    }
                    taxNewProd = null;
                    taxNewLine4 = null;
                    taxNewProd = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(VariableTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + ID_PriceListVersion + " AND M_Product_ID = " + iLine.getM_Product_ID(), new Object[0]);
                    taxNewLine4 = (BigDecimal)iLine.get_Value("VariableTax");
                    if (taxNewLine4 == null && taxNewProd != null) {
                        iLine.set_CustomColumn("VariableTax", taxNewProd);
                        taxNewLine4 = taxNewProd;
                    }
                    if (taxNewLine4 != null) {
                        taxNewProd = taxNewLine4.multiply(iLine.getQtyInvoiced());
                        iLine.set_CustomColumn("VariableTaxAmt", taxNewProd);
                    }
                }
                BigDecimal IVATax = null;
                if (oLine2 != null) {
                    IVATax = (BigDecimal)oLine2.get_Value("IVATaxAmt");
                    if (IVATax != null) {
                        IVATax = IVATax.multiply(iLine.getQtyEntered());
                        IVATax = oLine2.getQtyOrdered().compareTo(Env.ZERO) == 0 ? IVATax.divide(Env.ONE, 10, RoundingMode.HALF_EVEN) : IVATax.divide(oLine2.getQtyOrdered(), 10, RoundingMode.HALF_EVEN);
                    }
                    iLine.set_CustomColumn("IVATaxAmt", IVATax);
                } else if (iLine.getC_Tax_ID() > 0 && iLine.getC_Tax().getName().toLowerCase().contains("iva")) {
                    IVATax = iLine.getLineNetAmt().multiply(iLine.getC_Tax().getRate());
                    IVATax = IVATax.divide(Env.ONEHUNDRED);
                    IVATax = IVATax.setScale(10, 6);
                    iLine.set_CustomColumn("IVATaxAmt", IVATax);
                }
                BigDecimal totalTaxNewLine = Env.ZERO;
                if ((BigDecimal)iLine.get_Value("FixedTaxAmt") != null) {
                    totalTaxNewLine = totalTaxNewLine.add((BigDecimal)iLine.get_Value("FixedTaxAmt"));
                }
                if ((BigDecimal)iLine.get_Value("VariableTax") != null) {
                    totalTaxNewLine = totalTaxNewLine.add((BigDecimal)iLine.get_Value("VariableTaxAmt"));
                }
                if ((BigDecimal)iLine.get_Value("IVATaxAmt") != null) {
                    totalTaxNewLine = totalTaxNewLine.add((BigDecimal)iLine.get_Value("IVATaxAmt"));
                }
                if (totalTaxNewLine != null) {
                    iLine.setTaxAmt(totalTaxNewLine);
                    iLine.setLineTotalAmt(iLine.getLineNetAmt().add(totalTaxNewLine));
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MInvoiceLine.Table_ID) {
            iLine = (MInvoiceLine)po;
            inv2 = new MInvoice(po.getCtx(), iLine.getC_Invoice_ID(), po.get_TrxName());
            if (inv2.getDocStatus().compareToIgnoreCase("CO") != 0 && inv2.getC_DocTypeTarget().getDocBaseType().compareTo("APB") != 0) {
                MInvoiceLine[] ilines = inv2.getLines();
                BigDecimal taxNewLine5 = Env.ZERO;
                BigDecimal taxLineFixed = Env.ZERO;
                BigDecimal taxLineVariable = Env.ZERO;
                BigDecimal taxLineIVA = Env.ZERO;
                int i = 0;
                while (i < ilines.length) {
                    MInvoiceLine iline = ilines[i];
                    if ((BigDecimal)iline.get_Value("FixedTaxAmt") != null) {
                        taxLineFixed = taxLineFixed.add((BigDecimal)iline.get_Value("FixedTaxAmt"));
                    }
                    if ((BigDecimal)iline.get_Value("VariableTax") != null) {
                        taxLineVariable = taxLineVariable.add((BigDecimal)iline.get_Value("VariableTaxAmt"));
                    }
                    if ((BigDecimal)iline.get_Value("IVATaxAmt") != null) {
                        taxLineIVA = taxLineIVA.add((BigDecimal)iline.get_Value("IVATaxAmt"));
                    }
                    ++i;
                }
                taxLineFixed = taxLineFixed.setScale(0, 6);
                taxLineVariable = taxLineVariable.setScale(0, 6);
                taxLineIVA = taxLineIVA.setScale(0, 6);
                taxNewLine5 = taxLineFixed.add(taxLineVariable).add(taxLineIVA);
                if (taxNewLine5 != null) {
                    taxNewLine5 = taxNewLine5.setScale(10, 6);
                    BigDecimal newGrandTotalSD = inv2.getTotalLines().add(taxNewLine5).setScale(0, RoundingMode.HALF_EVEN);
                    DB.executeUpdate("UPDATE C_Invoice SET GrandTotal = " + newGrandTotalSD + " " + " WHERE C_Invoice_ID = " + inv2.get_ID(), po.get_TrxName());
                }
            }
        }
        if ((type == 4 || type == 5) && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).getC_DocTypeTarget().getDocBaseType().compareTo("APB") != 0) {
            MInvoiceLine[] ilines = inv.getLines();
            taxNewLine = Env.ZERO;
            BigDecimal taxLineFixed = Env.ZERO;
            BigDecimal taxLineVariable = Env.ZERO;
            BigDecimal taxLineIVA = Env.ZERO;
            int i = 0;
            while (i < ilines.length) {
                MInvoiceLine iline = ilines[i];
                if ((BigDecimal)iline.get_Value("FixedTaxAmt") != null) {
                    taxLineFixed = taxLineFixed.add((BigDecimal)iline.get_Value("FixedTaxAmt"));
                }
                if ((BigDecimal)iline.get_Value("VariableTax") != null) {
                    taxLineVariable = taxLineVariable.add((BigDecimal)iline.get_Value("VariableTaxAmt"));
                }
                if ((BigDecimal)iline.get_Value("IVATaxAmt") != null) {
                    taxLineIVA = taxLineIVA.add((BigDecimal)iline.get_Value("IVATaxAmt"));
                }
                ++i;
            }
            taxLineFixed = taxLineFixed.setScale(0, 6);
            taxLineVariable = taxLineVariable.setScale(0, 6);
            taxLineIVA = taxLineIVA.setScale(0, 6);
            taxNewLine = taxLineFixed.add(taxLineVariable).add(taxLineIVA);
            if (taxNewLine != null) {
                taxNewLine = taxNewLine.setScale(10, 6);
                BigDecimal newGrandTotalSD = inv.getTotalLines().add(taxNewLine).setScale(0, RoundingMode.HALF_EVEN);
                DB.executeUpdate("UPDATE C_Invoice SET GrandTotal = " + newGrandTotalSD + " " + " WHERE C_Invoice_ID = " + inv.get_ID(), po.get_TrxName());
            }
        }
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoice inv = (MInvoice)po;
            BigDecimal amtTaxNew = DB.getSQLValueBD(po.get_TrxName(), "SELECT SUM(FixedTaxAmt) + SUM(VariableTaxAmt)  FROM C_Invoice WHERE C_Invoice_ID = " + inv.get_ID(), new Object[0]);
            if (amtTaxNew != null) {
                amtTaxNew = amtTaxNew.add(inv.getGrandTotal());
                amtTaxNew = amtTaxNew.setScale(4, 6);
                DB.executeUpdate("UPDATE C_Invoice SET GrandTotal = " + amtTaxNew + " WHERE C_Invoice_ID = " + inv.get_ID(), po.get_TrxName());
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

