/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModPAValidPriceLVersion
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAValidPriceLVersion.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx() && !order.get_ValueAsBoolean("Override") && order.get_ValueAsInt("M_PriceList_Version_ID") > 0) {
            MPriceListVersion PListV = new MPriceListVersion(po.getCtx(), order.get_ValueAsInt("M_PriceList_Version_ID"), po.get_TrxName());
            Timestamp vFrom = PListV.getValidFrom();
            Timestamp vTo = (Timestamp)PListV.get_Value("ValidTo");
            if (vFrom != null && vTo != null && (order.getDateOrdered().compareTo(vFrom) < 0 || order.getDateOrdered().compareTo(vTo) > 0)) {
                return "Error: Lista de Precios no V\u00e1lida";
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

