/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.sql.Timestamp;
import java.util.Calendar;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModPAValidDateInOut
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAValidDateInOut.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("M_InOut", this);
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MInvoice inv;
        Timestamp NextDate;
        Timestamp PreviousDate;
        Calendar cal;
        MInOut inOut;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 7 && po.get_Table_ID() == MInOut.Table_ID && (inOut = (MInOut)po).isSOTrx() && !inOut.get_ValueAsBoolean("Override")) {
            cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -7);
            PreviousDate = new Timestamp(cal.getTime().getTime());
            cal = Calendar.getInstance();
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 2);
            NextDate = new Timestamp(cal.getTime().getTime());
            if (inOut.getC_Order().getDateOrdered().compareTo(PreviousDate) < 0 || inOut.getC_Order().getDateOrdered().compareTo(NextDate) > 0) {
                return "Error: Fecha de despacho debe estar entre " + PreviousDate.toString() + " y " + NextDate.toString();
            }
        }
        if (timing == 7 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx() && !inv.get_ValueAsBoolean("Override")) {
            cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, -7);
            PreviousDate = new Timestamp(cal.getTime().getTime());
            cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.add(5, 2);
            NextDate = new Timestamp(cal.getTime().getTime());
            if (inv.getC_Order().getDateOrdered().compareTo(PreviousDate) < 0 || inv.getC_Order().getDateOrdered().compareTo(NextDate) > 0) {
                return "Error: Fecha de despacho debe estar entre " + PreviousDate.toString() + " y " + NextDate.toString();
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

