/*
 * Decompiled with CFR 0.152.
 */
package org.petroamerica.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProductPricing;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPAUpdateAmtOLineCL
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPAUpdateAmtOLineCL.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine oLine = (MOrderLine)po;
            MOrder order = new MOrder(po.getCtx(), oLine.getC_Order_ID(), po.get_TrxName());
            if (oLine.get_ValueAsInt("C_OrderLineRef_ID") > 0 && order.getDocStatus().compareToIgnoreCase("CO") != 0) {
                MProductPricing pp = new MProductPricing(oLine.getM_Product_ID(), oLine.getC_Order().getC_BPartner_ID(), oLine.getQtyOrdered(), oLine.getC_Order().isSOTrx());
                int M_PriceList_ID = oLine.getC_Order().getM_PriceList_ID();
                pp.setM_PriceList_ID(M_PriceList_ID);
                Timestamp orderDate = oLine.getC_Order().getDateOrdered();
                int M_PriceList_Version_ID = 0;
                if (M_PriceList_Version_ID == 0 && M_PriceList_ID > 0) {
                    String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                    M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, M_PriceList_ID, orderDate);
                }
                pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                pp.setPriceDate(orderDate);
                BigDecimal newPrice = pp.getPriceList();
                oLine.setPrice(newPrice);
                oLine.setLineNetAmt();
                oLine.setTax();
                BigDecimal taxNewPro = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(FixedTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + M_PriceList_Version_ID + " AND M_Product_ID = " + oLine.getM_Product_ID(), new Object[0]);
                BigDecimal taxNewLine = null;
                if ((taxNewLine == null || taxNewLine.compareTo(Env.ZERO) == 0) && taxNewPro != null) {
                    oLine.set_CustomColumn("FixedTax", taxNewPro);
                    taxNewLine = taxNewPro;
                }
                if (taxNewLine != null) {
                    taxNewPro = taxNewLine.multiply(oLine.getQtyOrdered());
                    oLine.set_CustomColumn("FixedTaxAmt", taxNewPro);
                }
                taxNewPro = null;
                taxNewLine = null;
                taxNewPro = DB.getSQLValueBD(po.get_TrxName(), "SELECT MAX(VariableTax) FROM M_ProductPrice WHERE M_PriceList_Version_ID = " + M_PriceList_Version_ID + " AND M_Product_ID = " + oLine.getM_Product_ID(), new Object[0]);
                taxNewLine = null;
                if ((taxNewLine == null || taxNewLine.compareTo(Env.ZERO) == 0) && taxNewPro != null) {
                    oLine.set_CustomColumn("VariableTax", taxNewPro);
                    taxNewLine = taxNewPro;
                }
                if (taxNewLine != null) {
                    taxNewPro = taxNewLine.multiply(oLine.getQtyOrdered());
                    oLine.set_CustomColumn("VariableTaxAmt", taxNewPro);
                }
                BigDecimal IVATax = null;
                if (oLine.getC_Tax().getName().toLowerCase().contains("iva")) {
                    IVATax = oLine.getLineNetAmt().multiply(oLine.getC_Tax().getRate());
                    IVATax = IVATax.divide(Env.ONEHUNDRED);
                    IVATax = IVATax.setScale(10, 6);
                    oLine.set_CustomColumn("IVATaxAmt", IVATax);
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

