/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateAmtInvoicePaySchedule
extends SvrProcess {
    private int p_Org_ID;
    private String P_DocAction;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        int cantUpdated = 0;
        String sqlOrders = "SELECT cps.C_InvoicePaySchedule_ID  FROM C_InvoicePaySchedule cps INNER JOIN C_Invoice ci ON (cps.C_Invoice_ID = ci.C_Invoice_ID) WHERE ci.DocStatus IN ('CO','CL') and cps.foreignprice is not null and cps.foreignprice > 0 and cps.IsPaid <> 'Y'";
        if (this.p_Org_ID > 0) {
            sqlOrders = String.valueOf(sqlOrders) + " AND co.AD_Org_ID = ? ";
        }
        try {
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(sqlOrders, this.get_TrxName());
            if (this.p_Org_ID > 0) {
                pstmt.setInt(1, this.p_Org_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            Timestamp p_DateDoc = new Timestamp(System.currentTimeMillis());
            p_DateDoc.setHours(0);
            p_DateDoc.setMinutes(0);
            p_DateDoc.setSeconds(0);
            p_DateDoc.setNanos(0);
            while (true) {
                if (!rs.next()) {
                    rs.close();
                    pstmt.close();
                    return "Se Han actualizado " + cantUpdated + " Cuotas";
                }
                MInvoicePaySchedule ps = new MInvoicePaySchedule(this.getCtx(), rs.getInt("C_InvoicePaySchedule_ID"), this.get_TrxName());
                MInvoice inv = new MInvoice(this.getCtx(), ps.getC_Invoice_ID(), this.get_TrxName());
                BigDecimal fprice = (BigDecimal)ps.get_Value("ForeignPrice");
                if (fprice.compareTo(Env.ZERO) > 0 && inv.getC_Currency().getISO_Code().equals("CLP")) {
                    BigDecimal amt = MConversionRate.convert(this.getCtx(), fprice, 1000000, inv.getC_Currency_ID(), p_DateDoc, 114, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                    if (amt == null) {
                        return "No existe tasa de cambio para UF, no se puede completar la operacion";
                    }
                    if (amt.compareTo(Env.ZERO) > 0) {
                        try {
                            String sqlUpdate = "UPDATE C_InvoicePaySchedule SET dueamt = " + amt + " WHERE C_InvoicePaySchedule_ID = " + ps.get_ID();
                            DB.executeUpdate(sqlUpdate, this.get_TrxName());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                    }
                }
                ++cantUpdated;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se Han actualizado " + cantUpdated + " Cuotas";
    }
}

