/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProductPricing;
import org.compiere.model.X_EO_Agreement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateAmtCOrderFull
extends SvrProcess {
    private int p_Org_ID;
    private String P_DocAction;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.p_Org_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        int cantUpdated = 0;
        String sqlOrders = "SELECT C_Order_ID FROM C_Order co WHERE co.DocStatus IN ('CO','CL') and (co.issotrx = 'Y' and C_DocTypeTarget_ID IN (1000030)) OR co.issotrx = 'N'";
        if (this.p_Org_ID > 0) {
            sqlOrders = String.valueOf(sqlOrders) + " AND co.AD_Org_ID = ? ";
        }
        try {
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(sqlOrders, this.get_TrxName());
            if (this.p_Org_ID > 0) {
                pstmt.setInt(1, this.p_Org_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            Timestamp p_DateDoc = new Timestamp(System.currentTimeMillis());
            p_DateDoc.setHours(0);
            p_DateDoc.setMinutes(0);
            p_DateDoc.setSeconds(0);
            p_DateDoc.setNanos(0);
            block14: while (true) {
                if (!rs.next()) {
                    rs.close();
                    pstmt.close();
                    return "Se Han actualizado " + cantUpdated + " ordenes";
                }
                MOrder order = new MOrder(this.getCtx(), rs.getInt("C_Order_ID"), this.get_TrxName());
                order.setDateOrdered(p_DateDoc);
                order.setDateAcct(p_DateDoc);
                order.save();
                MOrderLine[] lines = order.getLines();
                int i = 0;
                while (true) {
                    block30: {
                        MOrderLine line;
                        block28: {
                            block29: {
                                if (i >= lines.length) {
                                    ++cantUpdated;
                                    continue block14;
                                }
                                line = lines[i];
                                if (line.getM_Product_ID() <= 0) break block28;
                                if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATR\u00cdCULA") < 0 && line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATRICULA") < 0) break block29;
                                if (order.getC_Currency().getISO_Code().equals("CLP")) {
                                    MProductPricing pp = new MProductPricing(line.getM_Product_ID(), order.getC_BPartner_ID(), line.getQtyEntered(), order.isSOTrx());
                                    pp.setM_PriceList_ID(order.getM_PriceList_ID());
                                    int M_PriceList_Version_ID = 0;
                                    String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                                    M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
                                    pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                                    pp.setPriceDate(p_DateDoc);
                                    BigDecimal amt = MConversionRate.convert(line.getCtx(), pp.getPriceLimit(), 1000000, order.getC_Currency_ID(), p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                                    if (amt == null) {
                                        return "No existe tasa de cambio para UF, no se puede completar la operacion";
                                    }
                                    try {
                                        line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                                        line.set_CustomColumn("ForeignPrice", pp.getPriceLimit());
                                    }
                                    catch (Exception e) {
                                        this.log.log(Level.SEVERE, e.getMessage(), e);
                                    }
                                    line.setPriceList(amt);
                                    line.setPrice(amt);
                                    line.setLineNetAmt();
                                    line.save();
                                }
                                break block30;
                            }
                            if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("COLEGIATURA") < 0 || !order.getC_Currency().getISO_Code().equals("CLP")) break block30;
                            MPaymentTerm termco = new MPaymentTerm(order.getCtx(), order.get_ValueAsInt("C_PaymentTerm2_ID"), order.get_TrxName());
                            MProductPricing pp = new MProductPricing(line.getM_Product_ID(), order.getC_BPartner_ID(), line.getQtyEntered(), order.isSOTrx());
                            pp.setM_PriceList_ID(order.getM_PriceList_ID());
                            int M_PriceList_Version_ID = 0;
                            String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                            M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
                            pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                            pp.setPriceDate(p_DateDoc);
                            BigDecimal amt = MConversionRate.convert(line.getCtx(), pp.getPriceLimit(), 1000000, order.getC_Currency_ID(), p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                            if (amt == null) {
                                return "No existe tasa de cambio para UF, no se puede completar la operacion";
                            }
                            BigDecimal amtAcum = new BigDecimal("0.0");
                            if (line.get_ValueAsInt("EO_Agreement_ID") > 0) {
                                X_EO_Agreement agree = new X_EO_Agreement(line.getCtx(), line.get_ValueAsInt("EO_Agreement_ID"), line.get_TrxName());
                                BigDecimal tmp = Env.ONEHUNDRED.subtract(Env.ONEHUNDRED.multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4)));
                                tmp = tmp.subtract(tmp.multiply(agree.getDiscount().divide(Env.ONEHUNDRED, 4)));
                                BigDecimal totalDiscount = Env.ONEHUNDRED.subtract(tmp);
                                try {
                                    line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                amtAcum = amt.subtract(amt.multiply(totalDiscount.divide(Env.ONEHUNDRED, 4)));
                                line.setPriceList(amt);
                                line.setPrice(amtAcum);
                                line.setDiscount(totalDiscount);
                                line.setLineNetAmt();
                                BigDecimal amtAcumUF = MConversionRate.convert(line.getCtx(), amtAcum, order.getC_Currency_ID(), 1000000, p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                                try {
                                    line.set_CustomColumn("ForeignPrice", amtAcumUF);
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                line.save();
                                break block30;
                            } else {
                                try {
                                    line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                amtAcum = amt.subtract(amt.multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4)));
                                line.setPriceList(amt);
                                line.setPrice(amtAcum);
                                line.setDiscount(termco.getDiscount());
                                line.setLineNetAmt();
                                BigDecimal amtAcumUF = MConversionRate.convert(line.getCtx(), amtAcum, order.getC_Currency_ID(), 1000000, p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                                try {
                                    line.set_CustomColumn("ForeignPrice", amtAcumUF);
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                line.save();
                            }
                            break block30;
                        }
                        if (line.getC_Charge_ID() > 0) {
                            MCharge charge = new MCharge(this.getCtx(), line.getC_Charge_ID(), this.get_TrxName());
                            if (order.getC_Currency().getISO_Code().equals("CLP")) {
                                BigDecimal amt = MConversionRate.convert(line.getCtx(), charge.getChargeAmt(), 1000000, order.getC_Currency_ID(), p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                                if (amt == null) {
                                    return "No existe tasa de cambio para UF, no se puede completar la operacion";
                                }
                                try {
                                    line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                                    line.set_CustomColumn("ForeignPrice", charge.getChargeAmt());
                                }
                                catch (Exception e) {
                                    this.log.log(Level.SEVERE, e.getMessage(), e);
                                }
                                line.setPriceList(amt);
                                line.setPrice(amt);
                                line.setLineNetAmt();
                                line.save();
                            }
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se Han actualizado " + cantUpdated + " ordenes";
    }
}

