/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProductPricing;
import org.compiere.model.X_EO_Agreement;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateAmtCOrder
extends SvrProcess {
    private int p_Order_ID;
    private Properties m_ctx;
    private Timestamp p_DateDoc = null;

    @Override
    protected void prepare() {
        this.p_Order_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateDoc")) {
                    this.p_DateDoc = (Timestamp)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.p_Order_ID, this.get_TrxName());
        if (this.p_DateDoc == null) {
            this.p_DateDoc = new Timestamp(System.currentTimeMillis());
        }
        order.setDateOrdered(this.p_DateDoc);
        order.setDateAcct(this.p_DateDoc);
        order.save();
        MOrderLine[] lines = order.getLines();
        int i = 0;
        while (i < lines.length) {
            MOrderLine line = lines[i];
            if (line.getM_Product_ID() > 0) {
                if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATR\u00cdCULA") >= 0 || line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATRICULA") >= 0) {
                    if (order.getC_Currency().getISO_Code().equals("CLP")) {
                        MProductPricing pp = new MProductPricing(line.getM_Product_ID(), order.getC_BPartner_ID(), line.getQtyEntered(), order.isSOTrx());
                        pp.setM_PriceList_ID(order.getM_PriceList_ID());
                        int M_PriceList_Version_ID = 0;
                        String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                        M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
                        pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                        pp.setPriceDate(this.p_DateDoc);
                        BigDecimal amt = MConversionRate.convertBase(line.getCtx(), pp.getPriceLimit(), 1000000, this.p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                        if (amt == null) {
                            return "No existe tasa de cambio para UF, no se puede completar la operacion";
                        }
                        try {
                            line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                            line.set_CustomColumn("ForeignPrice", pp.getPriceLimit());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        line.setPriceList(amt);
                        line.setPrice(amt);
                        line.setLineNetAmt();
                        line.save();
                    }
                } else if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("COLEGIATURA") >= 0 && order.getC_Currency().getISO_Code().equals("CLP")) {
                    MPaymentTerm termco = new MPaymentTerm(order.getCtx(), order.get_ValueAsInt("C_PaymentTerm2_ID"), order.get_TrxName());
                    MProductPricing pp = new MProductPricing(line.getM_Product_ID(), order.getC_BPartner_ID(), line.getQtyEntered(), order.isSOTrx());
                    pp.setM_PriceList_ID(order.getM_PriceList_ID());
                    int M_PriceList_Version_ID = 0;
                    String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                    M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
                    pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                    pp.setPriceDate(this.p_DateDoc);
                    BigDecimal amt = MConversionRate.convertBase(line.getCtx(), pp.getPriceLimit(), 1000000, this.p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                    if (amt == null) {
                        return "No existe tasa de cambio para UF, no se puede completar la operacion";
                    }
                    BigDecimal amtAcum = new BigDecimal("0.0");
                    if (line.get_ValueAsInt("EO_Agreement_ID") > 0) {
                        X_EO_Agreement agree = new X_EO_Agreement(line.getCtx(), line.get_ValueAsInt("EO_Agreement_ID"), line.get_TrxName());
                        BigDecimal tmp = Env.ONEHUNDRED.subtract(Env.ONEHUNDRED.multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4)));
                        tmp = tmp.subtract(tmp.multiply(agree.getDiscount().divide(Env.ONEHUNDRED, 4)));
                        BigDecimal totalDiscount = Env.ONEHUNDRED.subtract(tmp);
                        try {
                            line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        amtAcum = amt.subtract(amt.multiply(totalDiscount.divide(Env.ONEHUNDRED, 4)));
                        line.setPriceList(amt);
                        line.setPrice(amtAcum);
                        line.setDiscount(totalDiscount);
                        line.setLineNetAmt();
                        BigDecimal amtAcumUF = MConversionRate.convert(line.getCtx(), amtAcum, order.getC_Currency_ID(), 1000000, this.p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                        try {
                            line.set_CustomColumn("ForeignPrice", amtAcumUF);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        line.save();
                    } else {
                        try {
                            line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        amtAcum = amt.subtract(amt.multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4)));
                        line.setPriceList(amt);
                        line.setPrice(amtAcum);
                        line.setDiscount(termco.getDiscount());
                        line.setLineNetAmt();
                        BigDecimal amtAcumUF = MConversionRate.convert(line.getCtx(), amtAcum, order.getC_Currency_ID(), 1000000, this.p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                        try {
                            line.set_CustomColumn("ForeignPrice", amtAcumUF);
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        line.save();
                    }
                }
            } else if (line.getC_Charge_ID() > 0) {
                MCharge charge = new MCharge(this.getCtx(), line.getC_Charge_ID(), this.get_TrxName());
                if (order.getC_Currency().getISO_Code().equals("CLP")) {
                    BigDecimal amt = MConversionRate.convertBase(line.getCtx(), charge.getChargeAmt(), 1000000, this.p_DateDoc, 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                    if (amt == null) {
                        return "No existe tasa de cambio para UF, no se puede completar la operacion";
                    }
                    try {
                        line.set_CustomColumn("AmtBeforeProcess", line.getPriceActual());
                        line.set_CustomColumn("ForeignPrice", charge.getChargeAmt());
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                    line.setPriceList(amt);
                    line.setPrice(amt);
                    line.setLineNetAmt();
                    line.save();
                }
            }
            ++i;
        }
        return "Orden Actualizada";
    }
}

