/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.X_EO_Budget;
import org.compiere.model.X_EO_BudgetHdr;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class GenerateBudgetCPV
extends SvrProcess {
    private int p_cant;
    private int p_IDBudget;

    @Override
    protected void prepare() {
        this.p_IDBudget = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("Qty")) {
                this.p_cant = para[i].getParameterAsInt();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        X_EO_BudgetHdr budHdr = new X_EO_BudgetHdr(this.getCtx(), this.p_IDBudget, this.get_TrxName());
        String sql = "SELECT * FROM EO_Budget WHERE  EO_BudgetHdr_ID = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, budHdr.get_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                X_EO_Budget bud = new X_EO_Budget(this.getCtx(), rs.getInt("EO_Budget_ID"), this.get_TrxName());
                int i = 1;
                while (i <= this.p_cant) {
                    X_EO_Budget budNew = new X_EO_Budget(this.getCtx(), 0, this.get_TrxName());
                    budNew.setEO_BudgetHdr_ID(bud.getEO_BudgetHdr_ID());
                    budNew.setAD_Org_ID(bud.getAD_Org_ID());
                    budNew.setM_Product_ID(bud.getM_Product_ID());
                    budNew.setM_AttributeSetInstance_ID(bud.getM_AttributeSetInstance_ID());
                    budNew.setQty(bud.getQty());
                    budNew.setPriceActual(bud.getPriceActual());
                    budNew.setM_ProductRef_ID(bud.getM_ProductRef_ID());
                    if (bud.getC_BPartner_ID() > 0) {
                        budNew.setC_BPartner_ID(bud.getC_BPartner_ID());
                    }
                    budNew.setC_Period_ID(bud.getC_Period_ID() + i);
                    budNew.set_CustomColumn("Comments", bud.get_ValueAsString("Comments"));
                    budNew.save();
                    ++i;
                }
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "BP - " + sql.toString(), e);
        }
        return "Detalle Generado";
    }
}

