/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import java.math.BigDecimal;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModPDVValidCantidadColegiatura
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVValidCantidadColegiatura.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)po).isSOTrx()) {
            BigDecimal qtyColegio;
            BigDecimal qtyMatricula;
            String SqlMatricula = "select coalesce(sum(col.qtyentered),0) from c_orderline col inner join m_product mp on (col.m_product_id = mp.m_product_id) inner join m_product_category mpc on (mp.m_product_category_id = mpc.m_product_category_id) where col.C_Order_ID = " + order.get_ID() + " and upper(mpc.name) like '%MATRICULA%'";
            String SqlColegio = "select coalesce(sum(col.qtyentered),0) from c_orderline col inner join m_product mp on (col.m_product_id = mp.m_product_id) inner join m_product_category mpc on (mp.m_product_category_id = mpc.m_product_category_id) where col.C_Order_ID = " + order.get_ID() + " and upper(mpc.name) like '%COLEGIATURA%'";
            try {
                qtyMatricula = DB.getSQLValueBD(po.get_TrxName(), SqlMatricula, new Object[0]);
                qtyColegio = DB.getSQLValueBD(po.get_TrxName(), SqlColegio, new Object[0]);
            }
            catch (Exception e) {
                qtyMatricula = Env.ZERO;
                qtyColegio = Env.ZERO;
            }
            if (qtyMatricula.compareTo(qtyColegio) != 0) {
                return "Error: Cantidad de Matriculas y Colegiaturas no coincide. Matriculas: " + qtyMatricula + " Colegiaturas: " + qtyColegio;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

