/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ModPDVRoundPay
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVRoundPay.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        BigDecimal d;
        BigDecimal result;
        MPayment pay;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 5 || type == 4) && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)po).isReceipt() && pay.getTenderType().compareToIgnoreCase("K") == 0 && (result = (d = pay.getPayAmt().divide(Env.ONEHUNDRED)).subtract(d.setScale(0, RoundingMode.FLOOR)).movePointRight(d.scale())).compareTo(Env.ZERO) != 0) {
            if (result.compareTo(BigDecimal.valueOf(50L)) >= 0) {
                pay.setPayAmt(pay.getPayAmt().add(Env.ONEHUNDRED.subtract(result)));
            } else {
                pay.setPayAmt(pay.getPayAmt().subtract(result));
            }
            pay.save();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

