/*
 * Decompiled with CFR 0.152.
 */
package org.pdv.model;

import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModPDVCustodios
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModPDVCustodios.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_AllocationHdr", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_BankStatement", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MBankStatementLine sline;
        MBankStatementLine[] slines;
        MBankStatement statement;
        MInvoiceLine iline;
        MInvoiceLine[] ilines;
        MInvoice inv;
        MPayment pay;
        String cusOld;
        MPayment pay2;
        MAllocationLine aline;
        int i;
        MAllocationLine[] alines;
        MAllocationHdr allo;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            allo = (MAllocationHdr)po;
            alines = allo.getLines(false);
            i = 0;
            while (i < alines.length) {
                aline = alines[i];
                if (aline.getC_Payment_ID() > 0) {
                    pay2 = new MPayment(po.getCtx(), aline.getC_Payment_ID(), po.get_TrxName());
                    pay2.set_CustomColumn("custodio_old", pay2.get_ValueAsString("custodio"));
                    pay2.set_CustomColumn("custodio", "A");
                    pay2.set_CustomColumn("DocTypeName", "Asignacion de Pago");
                    pay2.save();
                }
                if (aline.getC_Invoice_ID() > 0) {
                    MInvoice inv2 = new MInvoice(po.getCtx(), aline.getC_Invoice_ID(), po.get_TrxName());
                    inv2.set_CustomColumn("custodio_old", inv2.get_ValueAsString("custodio"));
                    inv2.set_CustomColumn("custodio", "A");
                    inv2.set_CustomColumn("DocTypeName", "Asignacion de Pago");
                    inv2.save();
                }
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MAllocationHdr.Table_ID) {
            allo = (MAllocationHdr)po;
            alines = allo.getLines(false);
            i = 0;
            while (i < alines.length) {
                boolean ind;
                aline = alines[i];
                cusOld = "";
                if (aline.getC_Payment_ID() > 0) {
                    pay = new MPayment(po.getCtx(), aline.getC_Payment_ID(), po.get_TrxName());
                    cusOld = pay.get_ValueAsString("custodio_old");
                    pay.set_CustomColumn("custodio_old", pay.get_ValueAsString("custodio"));
                    ind = false;
                    if (cusOld != null && cusOld != "" && cusOld != " ") {
                        pay.set_CustomColumn("custodio", cusOld);
                        ind = true;
                    }
                    pay.save();
                    if (!ind) {
                        DB.executeUpdate("UPDATE C_Payment set Custodio=null WHERE C_Payment_ID = " + pay.get_ID(), po.get_TrxName());
                    }
                }
                if (aline.getC_Invoice_ID() > 0) {
                    MInvoice inv3 = new MInvoice(po.getCtx(), aline.getC_Invoice_ID(), po.get_TrxName());
                    cusOld = inv3.get_ValueAsString("custodio_old");
                    inv3.set_CustomColumn("custodio_old", inv3.get_ValueAsString("custodio"));
                    ind = false;
                    if (cusOld != null && cusOld != "" && cusOld != " ") {
                        inv3.set_CustomColumn("custodio", cusOld);
                        ind = true;
                    }
                    inv3.save();
                    if (!ind) {
                        DB.executeUpdate("UPDATE C_Invoice set Custodio=null WHERE C_Invoice_ID = " + inv3.get_ID(), po.get_TrxName());
                    }
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            ilines = inv.getLines(false);
            i = 0;
            while (i < ilines.length) {
                iline = ilines[i];
                String cus = "";
                String glosa = "";
                String auxGlosa = "";
                if (inv.getC_DocType_ID() == 1000102) {
                    cus = "B";
                    auxGlosa = DB.getSQLValueString(po.get_TrxName(), "SELECT NAME FROM AD_Ref_List WHERE AD_Reference_ID=1000067AND value like '" + inv.get_ValueAsString("DepositType") + "'", new Object[0]);
                    glosa = String.valueOf(inv.getC_DocType().getName()) + " - " + auxGlosa;
                } else if (inv.getC_DocType_ID() == 1000052) {
                    cus = "C";
                    glosa = inv.getC_DocType().getName();
                } else if (inv.getC_DocType_ID() == 1000051) {
                    cus = "F";
                    glosa = inv.getC_DocType().getName();
                } else if (inv.getC_DocType_ID() == 1000050 || inv.getC_DocType_ID() == 1000124 || inv.getC_DocType_ID() == 1000122) {
                    cus = "P";
                    glosa = inv.getC_DocType().getName();
                } else if (inv.getC_DocType().getDocBaseType().compareTo("CDC") == 0) {
                    cus = "C";
                    glosa = inv.getC_DocType().getName();
                } else {
                    glosa = inv.getC_DocType().getName();
                }
                if (iline.get_ValueAsInt("C_Payment_ID") > 0) {
                    MPayment pay3 = new MPayment(po.getCtx(), iline.get_ValueAsInt("C_Payment_ID"), po.get_TrxName());
                    pay3.set_CustomColumn("custodio_old", pay3.get_ValueAsString("custodio"));
                    if (cus != null && cus != "" && cus != " ") {
                        pay3.set_CustomColumn("custodio", cus);
                    }
                    pay3.set_CustomColumn("DocTypeName", glosa);
                    pay3.save();
                }
                if (iline.get_ValueAsInt("c_invoicefac_id") > 0) {
                    MInvoice invDe = new MInvoice(po.getCtx(), iline.get_ValueAsInt("c_invoicefac_id"), po.get_TrxName());
                    invDe.set_CustomColumn("custodio_old", inv.get_ValueAsString("custodio"));
                    if (cus != null && cus != "" && cus != " ") {
                        invDe.set_CustomColumn("custodio", cus);
                    }
                    invDe.set_CustomColumn("DocTypeName", glosa);
                    invDe.save();
                }
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            ilines = inv.getLines(false);
            i = 0;
            while (i < ilines.length) {
                iline = ilines[i];
                cusOld = "";
                if (iline.get_ValueAsInt("C_Payment_ID") > 0) {
                    pay = new MPayment(po.getCtx(), iline.get_ValueAsInt("C_Payment_ID"), po.get_TrxName());
                    cusOld = pay.get_ValueAsString("custodio_old");
                    pay.set_CustomColumn("custodio_old", pay.get_ValueAsString("custodio"));
                    boolean ind = false;
                    if (cusOld != null && cusOld != "" && cusOld != " ") {
                        pay.set_CustomColumn("custodio", cusOld);
                        ind = true;
                    }
                    pay.save();
                    if (!ind) {
                        DB.executeUpdate("UPDATE C_Payment set Custodio=null WHERE C_Payment_ID = " + pay.get_ID(), po.get_TrxName());
                    }
                }
                if (iline.get_ValueAsInt("c_invoicefac_id") > 0) {
                    MInvoice invDe = new MInvoice(po.getCtx(), iline.get_ValueAsInt("c_invoicefac_id"), po.get_TrxName());
                    cusOld = invDe.get_ValueAsString("custodio_old");
                    invDe.set_CustomColumn("custodio_old", invDe.get_ValueAsString("custodio"));
                    boolean ind = false;
                    if (cusOld != null && cusOld != "" && cusOld != " ") {
                        invDe.set_CustomColumn("custodio", cusOld);
                        ind = true;
                    }
                    invDe.save();
                    if (!ind) {
                        DB.executeUpdate("UPDATE C_Invoice set Custodio=null WHERE C_Invoice_ID = " + invDe.get_ID(), po.get_TrxName());
                    }
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MBankStatement.Table_ID) {
            statement = (MBankStatement)po;
            slines = statement.getLines(false);
            i = 0;
            while (i < slines.length) {
                sline = slines[i];
                if (sline.getC_Payment_ID() > 0) {
                    pay2 = new MPayment(po.getCtx(), sline.getC_Payment_ID(), po.get_TrxName());
                    pay2.set_CustomColumn("custodio_old", pay2.get_ValueAsString("custodio"));
                    pay2.set_CustomColumn("custodio", "O");
                    pay2.set_CustomColumn("DocTypeName", "Estado de Cuentas Bancario");
                    pay2.save();
                }
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MBankStatement.Table_ID) {
            statement = (MBankStatement)po;
            slines = statement.getLines(false);
            i = 0;
            while (i < slines.length) {
                sline = slines[i];
                if (sline.getC_Payment_ID() > 0) {
                    pay2 = new MPayment(po.getCtx(), sline.getC_Payment_ID(), po.get_TrxName());
                    String cusOld2 = pay2.get_ValueAsString("custodio_old");
                    pay2.set_CustomColumn("custodio_old", pay2.get_ValueAsString("custodio"));
                    boolean ind = false;
                    if (cusOld2 != null && cusOld2 != "" && cusOld2 != " ") {
                        pay2.set_CustomColumn("custodio", cusOld2);
                        ind = true;
                    }
                    pay2.save();
                    if (!ind) {
                        DB.executeUpdate("UPDATE C_Payment set Custodio=null WHERE C_Payment_ID = " + pay2.get_ID(), po.get_TrxName());
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

