/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MChat;
import org.compiere.model.MChatEntry;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.X_C_Project;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.model.X_RH_AdministrativeRequests;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ProcessDMDocument
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        X_DM_Document doc = new X_DM_Document(Env.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.equals("CO") && !doc.isProcessed()) {
            ResultSet rs;
            String mysql;
            CPreparedStatement pstmt;
            if (doc.getDM_DocumentType().equals("CM")) {
                if (doc.getDM_MandateAgreement_ID() <= 0) {
                    return "se necesita un Convenio Mandato asignada a este documento";
                }
                if (doc.getDM_RS_ID() <= 0) {
                    return "se necesita una Resolucion de Asignacion  relacionada a este documento";
                }
            }
            if (doc.getDM_DocumentType().equals("PM")) {
                if (doc.getC_Project_ID() == 0) {
                    return "Proyecto es Obligatorio";
                }
                String sqlfx = "SELECT SUM(FixAmt) FROM DM_DocumentLine WHERE DM_Document_ID = ?";
                BigDecimal fxAmt = DB.getSQLValueBD(this.get_TrxName(), sqlfx, doc.get_ID());
                MProject pj = new MProject(this.getCtx(), doc.getC_Project_ID(), this.get_TrxName());
                if (fxAmt.signum() == 0) {
                    return "El monto solicitado no puede ser 0";
                }
                if (doc.getDocStatus().equals("DR")) {
                    doc.setDocStatus("WC");
                    doc.save();
                    int chat_id = this.getChat_ID(X_C_Project.Table_ID, doc.getC_Project_ID());
                    MChat chat = null;
                    if (chat_id > 0) {
                        chat = new MChat(Env.getCtx(), chat_id, this.get_TrxName());
                    } else {
                        chat = new MChat(Env.getCtx(), X_C_Project.Table_ID, doc.getC_Project_ID(), "C_Project : " + doc.getC_Project_ID(), this.get_TrxName());
                        chat.saveEx();
                    }
                    MChatEntry chatentry = new MChatEntry(chat, "Se Solicita Aprobacion Cambio Monto a " + pj.getCommittedAmt().add(fxAmt).longValue() + " Documento :" + doc.getDocumentNo());
                    chatentry.saveEx();
                    return "Solicitado";
                }
                String sqlcm = "SELECT SUM(CommittedAmt) FROM DM_DocumentLine WHERE DM_Document_ID = ?";
                BigDecimal cmAmt = DB.getSQLValueBD(this.get_TrxName(), sqlcm, doc.get_ID());
                if (cmAmt.signum() == 0) {
                    return "El monto Aprovado no puede ser 0, debe ser mayor o igual al monto original del proyecto";
                }
                if (doc.getDocStatus().equals("WC")) {
                    doc.setProcessed(true);
                    doc.setDocStatus("CO");
                    doc.save();
                    int chat_id = this.getChat_ID(X_C_Project.Table_ID, doc.getC_Project_ID());
                    MChat chat = null;
                    if (chat_id > 0) {
                        chat = new MChat(Env.getCtx(), chat_id, this.get_TrxName());
                    } else {
                        chat = new MChat(Env.getCtx(), X_C_Project.Table_ID, doc.getC_Project_ID(), "C_Project : " + doc.getC_Project_ID(), this.get_TrxName());
                        chat.saveEx();
                    }
                    MChatEntry chatentry = new MChatEntry(chat, "Completado Cambio Monto, nuevo monto " + pj.getCommittedAmt().add(cmAmt).longValue() + " Documento :" + doc.getDocumentNo());
                    chatentry.saveEx();
                    CPreparedStatement pstmt2 = null;
                    String sqlp = "SELECT * FROM DM_DocumentLine WHERE DM_Document_ID = ?";
                    try {
                        pstmt2 = DB.prepareStatement(sqlp, this.get_TrxName());
                        pstmt2.setInt(1, doc.get_ID());
                        ResultSet rs2 = pstmt2.executeQuery();
                        while (rs2.next()) {
                            X_DM_DocumentLine dl = new X_DM_DocumentLine(this.getCtx(), rs2.getInt("DM_DocumentLine_ID"), this.get_TrxName());
                            MProjectLine pl = new MProjectLine(this.getCtx(), dl.get_ValueAsInt("C_ProjectLine2_ID"), this.get_TrxName());
                            BigDecimal sum = pl.getCommittedAmt().add((BigDecimal)dl.get_Value("CommittedAmt"));
                            pl.setCommittedAmt(sum);
                            pl.save();
                        }
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                    pj.setCommittedAmt(pj.getCommittedAmt().add(cmAmt));
                    return "Completado";
                }
            }
            if (doc.getDM_DocumentType().equals("AP")) {
                if (doc.getC_Project_ID() == 0) {
                    return "Proyecto es Obligatorio";
                }
                if (doc.getAmt().signum() == 0) {
                    return "El monto asignado no puede ser 0";
                }
                if (doc.get_ValueAsInt("C_Charge_ID") == 0) {
                    return "El cargo es obligatorio";
                }
                int lines = DB.getSQLValue(this.get_TrxName(), "select count(1) from DM_DocumentLine where DM_Document_ID=" + doc.getDM_Document_ID());
                if (lines <= 0) {
                    return "El documento no posee lineas";
                }
                pstmt = null;
                mysql = "SELECT * from DM_DocumentLine where DM_Document_ID= ?";
                try {
                    block47: {
                        int item;
                        int existe;
                        pstmt = DB.prepareStatement(mysql, this.get_TrxName());
                        pstmt.setInt(1, doc.getDM_Document_ID());
                        rs = pstmt.executeQuery();
                        do {
                            if (!rs.next()) break block47;
                            item = rs.getInt("M_Product_ID");
                        } while ((existe = DB.getSQLValue(this.get_TrxName(), "select count(1) from C_ProjectLine where C_Project_ID=" + doc.getC_Project_ID() + " and M_Product_ID=" + item)) > 0);
                        return "el Item :" + MProduct.get(this.getCtx(), item).getName() + " no pertenece al Proyecto";
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                MProject pj = new MProject(this.getCtx(), doc.getC_Project_ID(), this.get_TrxName());
                if (pj.getPlannedMarginAmt().add(doc.getAmt()).compareTo(pj.getCommittedAmt()) > 0) {
                    return "esta asignaci\u00f3n supera el monto que posee el proyecto";
                }
            }
            if (doc.getDM_DocumentType().equals("RS")) {
                if (doc.getAmt().signum() == 0) {
                    return "El monto asignado no puede ser 0";
                }
                int lines = DB.getSQLValue(this.get_TrxName(), "select count(1) from DM_DocumentLine where DM_Document_ID=" + doc.getDM_Document_ID());
                if (lines <= 0) {
                    return "El documento no posee lineas";
                }
                pstmt = null;
                mysql = "SELECT DM_DocumentLine_ID from DM_DocumentLine where DM_Document_ID= ?";
                try {
                    pstmt = DB.prepareStatement(mysql, this.get_TrxName());
                    pstmt.setInt(1, doc.getDM_Document_ID());
                    rs = pstmt.executeQuery();
                    block10: while (true) {
                        if (!rs.next()) {
                            rs.close();
                            pstmt.close();
                            pstmt = null;
                            break;
                        }
                        X_DM_DocumentLine line = new X_DM_DocumentLine(this.getCtx(), rs.getInt(1), this.get_TrxName());
                        MProject pj = new MProject(this.getCtx(), line.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                        pj.setPlannedMarginAmt(pj.getPlannedMarginAmt().add(line.getAmt()));
                        pj.save();
                        CPreparedStatement pstmt2 = null;
                        String sql2 = "select dm_documentline_id from dm_documentline where dm_document_id = ?";
                        pstmt2 = DB.prepareStatement(mysql, this.get_TrxName());
                        pstmt2.setInt(1, line.get_ValueAsInt("DM_DocumentRef_ID"));
                        ResultSet rs2 = pstmt2.executeQuery();
                        while (true) {
                            if (!rs2.next()) continue block10;
                            X_DM_DocumentLine line2 = new X_DM_DocumentLine(this.getCtx(), rs2.getInt(1), this.get_TrxName());
                            MProjectLine pjline = new MProjectLine(this.getCtx(), line2.get_ValueAsInt("C_ProjectLine_ID"), this.get_TrxName());
                            pjline.setPlannedMarginAmt(pjline.getPlannedMarginAmt().add(line2.getAmt()));
                            pjline.save();
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            if (doc.getDM_DocumentType().equals("AC")) {
                MJournalBatch jb = new MJournalBatch(Env.getCtx(), 0, this.get_TrxName());
                jb.setPostingType("A");
                jb.setDescription("Contabilizacion resolucion de cometido ID: " + doc.getDM_Document_ID() + " Numero documento: " + doc.getDocumentNo());
                jb.setC_DocType_ID(1000000);
                jb.setDateDoc(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                jb.setDateAcct(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                jb.setC_Period_ID(MPeriod.getC_Period_ID(Env.getCtx(), new Timestamp(TimeUtil.getToday().getTimeInMillis())));
                jb.setC_Currency_ID(228);
                jb.save();
                MJournal j = new MJournal(Env.getCtx(), 0, this.get_TrxName());
                j.setGL_JournalBatch_ID(jb.get_ID());
                j.setPostingType("A");
                j.setDescription("Contabilizacion resolucion de cometido ID: " + doc.getDM_Document_ID() + " Numero documento: " + doc.getDocumentNo());
                j.setC_DocType_ID(1000000);
                j.setC_Currency_ID(228);
                j.setC_AcctSchema_ID(1000000);
                j.setGL_Category_ID(1000000);
                j.setDateDoc(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                j.setDateAcct(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                j.setC_Period_ID(MPeriod.getC_Period_ID(Env.getCtx(), new Timestamp(TimeUtil.getToday().getTimeInMillis())));
                j.setC_ConversionType_ID(114);
                j.save();
                BigDecimal totalamt = new BigDecimal("0.0");
                int line = 0;
                String sqlcc = "select max(Accountability_Acct) from C_AcctSchema_Default where ad_client_id = 1000000";
                int contracuenta = DB.getSQLValue(this.get_TrxName(), sqlcc);
                CPreparedStatement pstmt3 = null;
                String sql = "SELECT dl.RH_Administrativerequests_ID FROM DM_DocumentLine dl INNER JOIN RH_Administrativerequests ar on (dl.RH_Administrativerequests_ID = ar.RH_Administrativerequests_ID) inner join c_bpartner cbp on (cbp.c_bpartner_ID = ar.c_bpartner_ID) WHERE dl.DM_Document_ID = ? order by cbp.name";
                try {
                    pstmt3 = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt3.setInt(1, doc.getDM_Document_ID());
                    ResultSet rs3 = pstmt3.executeQuery();
                    line = 10;
                    while (rs3.next()) {
                        int combinacionID;
                        String sqltype;
                        X_RH_AdministrativeRequests ar = new X_RH_AdministrativeRequests(this.getCtx(), rs3.getInt(1), this.get_TrxName());
                        String sqlCP = "select COALESCE (commitmentamt,0) from c_bpartner where c_bpartner_id = ?";
                        String sqlSP = "select COALESCE (commitmentamtSP,0) from c_bpartner where c_bpartner_id = ?";
                        BigDecimal montoCP = DB.getSQLValueBD(this.get_TrxName(), sqlCP, ar.getC_BPartner_ID());
                        BigDecimal montoSP = DB.getSQLValueBD(this.get_TrxName(), sqlSP, ar.getC_BPartner_ID());
                        BigDecimal montoTCP = montoCP.multiply((BigDecimal)ar.get_Value("QtyCP"));
                        BigDecimal montoTSP = montoSP.multiply((BigDecimal)ar.get_Value("QtySP"));
                        BigDecimal montoT = montoTCP.add(montoTSP);
                        String sqlTC = "SELECT MAX(dm.typecontract) FROM DM_Document dm\twhere dm.dm_documentType = 'CE' AND dm.c_bpartner_id = ? ";
                        String typecontract = DB.getSQLValueString(this.get_TrxName(), sqlTC, ar.getC_BPartner_ID());
                        if (typecontract == null) {
                            return "Tipo de Contrato desconocido";
                        }
                        if (typecontract.equals("CO")) {
                            sqltype = "select max(viaticoc_acct) from C_AcctSchema_Default where ad_client_id = 1000000";
                            combinacionID = DB.getSQLValue(this.get_TrxName(), sqltype);
                        } else if (typecontract.equals("HO")) {
                            sqltype = "select max(viaticoh_acct) from C_AcctSchema_Default where ad_client_id = 1000000";
                            combinacionID = DB.getSQLValue(this.get_TrxName(), sqltype);
                        } else if (typecontract.equals("PL")) {
                            sqltype = "select max(viaticop_acct) from C_AcctSchema_Default where ad_client_id = 1000000";
                            combinacionID = DB.getSQLValue(this.get_TrxName(), sqltype);
                        } else {
                            if (!typecontract.equals("HP")) {
                                return "Tipo de Contrato desconocido";
                            }
                            sqltype = "select max(viaticohp_acct) from C_AcctSchema_Default where ad_client_id = 1000000";
                            combinacionID = DB.getSQLValue(this.get_TrxName(), sqltype);
                        }
                        MJournalLine jl = new MJournalLine(j);
                        jl.setC_ValidCombination_ID(combinacionID);
                        jl.setAmtSourceDr(montoT);
                        jl.setAmtSourceCr(new BigDecimal("0.0"));
                        jl.setAmtAcct(montoT, new BigDecimal("0.0"));
                        jl.setLine(line);
                        jl.set_CustomColumn("C_Bpartner_ID", ar.getC_BPartner_ID());
                        jl.save();
                        totalamt = totalamt.add(montoT);
                        line += 10;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                MJournalLine jl = new MJournalLine(j);
                jl.setAmtSourceCr(totalamt);
                jl.setAmtSourceDr(new BigDecimal("0.0"));
                jl.setC_ValidCombination_ID(contracuenta);
                jl.setAmtAcct(new BigDecimal("0.0"), totalamt);
                jl.setLine(line);
                jl.save();
                doc.set_CustomColumn("Gl_Journal_ID", j.get_ID());
            }
            doc.setProcessed(true);
            doc.setDocStatus("CO");
            doc.save();
            return "Confirmado";
        }
        if (this.P_DocAction.equals("VO") && doc.isProcessed() && doc.getDocStatus().equals("CO")) {
            doc.setProcessed(false);
            doc.setDocStatus("VO");
            doc.save();
            return "Anulado";
        }
        return "No es posible Cumplir la Accion ";
    }

    private int getChat_ID(int Table_ID, int Record_ID) {
        int returnValue = DB.getSQLValue(this.get_TrxName(), "select cm_chat_id from cm_chat where ad_table_id = " + Table_ID + " and record_id = " + Record_ID);
        return returnValue;
    }
}

