/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.X_DM_Document;
import org.compiere.model.X_DM_DocumentLine;
import org.compiere.model.X_DM_MandateAgreement;
import org.compiere.model.X_PM_Tender;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class ImportGoreProyect
extends SvrProcess {
    private Properties m_ctx;
    private int p_tender_id = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PM_Tender_ID")) {
                    this.p_tender_id = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        X_PM_Tender Ten = new X_PM_Tender(Env.getCtx(), this.p_tender_id, this.get_TrxName());
        String sql = "select * from t_goreproject where concurso=?";
        CPreparedStatement pstmt = null;
        int count = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setString(1, Ten.getValue());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getString("ingreso") == null || rs.getString("ingreso").length() < 1) continue;
                BigDecimal montoSol = new BigDecimal(rs.getString("montosolicitado").trim().replaceAll(",", ""));
                BigDecimal montoAsig = new BigDecimal(rs.getString("montoasignado").trim().replaceAll(",", ""));
                MProject pj = new MProject(Env.getCtx(), 0, this.get_TrxName());
                String CodigoBip = String.valueOf(Ten.getName()) + "-" + rs.getString("ingreso");
                pj.setValue(CodigoBip);
                pj.setPOReference(CodigoBip);
                pj.setName(rs.getString("nombreproyecto"));
                pj.set_CustomColumn("Year", rs.getString("year"));
                pj.setPlannedAmt(montoSol);
                pj.set_CustomColumn("IsPriorized", true);
                pj.setC_Currency_ID(228);
                if (rs.getString("evaluacion") != null && rs.getString("evaluacion").length() >= 1) {
                    try {
                        Integer score = Integer.parseInt(rs.getString("evaluacion").trim().replaceAll(",", ""));
                        pj.set_CustomColumn("Score", score);
                    }
                    catch (Exception score) {
                        // empty catch block
                    }
                }
                pj.save();
                MProjectLine pjl = new MProjectLine(pj);
                pjl.setLine(10);
                pjl.setPlannedPrice(montoSol);
                pjl.setM_Product_ID(1000884);
                pjl.save();
                X_DM_MandateAgreement cm = new X_DM_MandateAgreement(Env.getCtx(), 0, this.get_TrxName());
                cm.setAD_Org_ID(pj.getAD_Org_ID());
                cm.setDocStatus("DR");
                cm.setC_Project_ID(pj.getC_Project_ID());
                cm.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                cm.setAmt(montoAsig);
                cm.setAllocatedAmt(montoAsig);
                cm.set_CustomColumn("Year", pj.get_Value("Year"));
                cm.set_CustomColumn("Code", pj.get_Value("POReference"));
                cm.set_CustomColumn("C_BPartner_ID", pj.get_Value("C_BPartner_ID"));
                cm.set_CustomColumn("C_BPartnerC_ID", pj.get_Value("C_BPartnerC_ID"));
                cm.set_CustomColumn("C_BPartnerA_ID", pj.get_Value("C_BPartnerA_ID"));
                BigDecimal factor = DB.getSQLValueBD(this.get_TrxName(), "select factor from PM_YearFactor where Year=?", rs.getString("Year"));
                cm.set_CustomColumn("Factor", factor == null ? Env.ONE : factor);
                if (pj.get_ValueAsBoolean("PM_Gore_UT")) {
                    cm.set_CustomColumn("DM_MandateAgreementType", "02");
                } else {
                    cm.set_CustomColumn("DM_MandateAgreementType", "01");
                }
                cm.save();
                cm.setProcessed(true);
                cm.setDocStatus("CO");
                DB.executeUpdate("update dm_mandateagreementline set processed='Y' where dm_mandateagreement_id = " + cm.getDM_MandateAgreement_ID(), this.get_TrxName());
                cm.save();
                X_DM_Document rss = new X_DM_Document(Env.getCtx(), 0, this.get_TrxName());
                rss.setAD_Org_ID(pj.getAD_Org_ID());
                rss.setDocStatus("DR");
                rss.setC_Project_ID(pj.getC_Project_ID());
                rss.setDM_DocumentType("AP");
                rss.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                rss.setAmt(montoAsig);
                rss.setProcessed(true);
                rss.setDocStatus("CO");
                rss.save();
                X_DM_Document ra = new X_DM_Document(Env.getCtx(), 0, this.get_TrxName());
                ra.setAD_Org_ID(pj.getAD_Org_ID());
                ra.setDocStatus("DR");
                ra.setDM_DocumentType("RS");
                ra.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                ra.setAmt(montoAsig);
                ra.setProcessed(true);
                ra.setDocStatus("CO");
                ra.save();
                X_DM_DocumentLine dline = new X_DM_DocumentLine(Env.getCtx(), 0, this.get_TrxName());
                dline.setAmt(montoAsig);
                dline.setDateTrx(new Timestamp(TimeUtil.getToday().getTimeInMillis()));
                dline.setDM_Document_ID(ra.getDM_Document_ID());
                dline.setM_Product_ID(1000884);
                dline.set_CustomColumn("C_ProjectLine_ID", pjl.getC_ProjectLine_ID());
                dline.save();
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Importados " + count;
    }
}

