/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MAssetAcct;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Depreciation_Workfile;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateAssetWF
extends SvrProcess {
    @Override
    protected void prepare() {
    }

    @Override
    protected String doIt() throws Exception {
        int x = 0;
        String sql = "select a.a_asset_id from a_asset a where a.ad_client_id=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Asset asset = new X_A_Asset(this.getCtx(), rs.getInt(1), this.get_TrxName());
                String sql2 = "SELECT COUNT(*) FROM A_Depreciation_Workfile WHERE A_Asset_ID=? ";
                if (DB.getSQLValue(this.get_TrxName(), sql2, asset.getA_Asset_ID()) != 0 || !asset.isDepreciated()) continue;
                String sql3 = "SELECT A_Asset_Acct_ID FROM A_Asset_Acct WHERE A_Asset_ID = ? AND IsActive='Y'";
                int acct_ID = DB.getSQLValue(this.get_TrxName(), sql3, asset.getA_Asset_ID());
                if (acct_ID <= 0) continue;
                MAssetAcct assetgrpacct = new MAssetAcct(this.getCtx(), acct_ID, this.get_TrxName());
                X_A_Depreciation_Workfile assetwk = new X_A_Depreciation_Workfile(this.getCtx(), 0, this.get_TrxName());
                assetwk.setA_Asset_ID(asset.getA_Asset_ID());
                assetwk.setA_Life_Period(asset.getUseLifeMonths());
                assetwk.setA_Asset_Life_Years(asset.getUseLifeYears());
                assetwk.setIsDepreciated(true);
                assetwk.setPostingType(assetgrpacct.getPostingType());
                assetwk.setA_Accumulated_Depr(new BigDecimal(0.0));
                assetwk.setA_QTY_Current(new BigDecimal(0.0));
                assetwk.setA_Asset_Cost(new BigDecimal(0.0));
                assetwk.setA_Period_Posted(0);
                assetwk.setA_QTY_Current(Env.ONE);
                assetwk.save();
                ++x;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return "Generados :" + x;
    }
}

