/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_M_InOut;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ExportDTEInvoiceNGem
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXML(inv);
        return msg;
    }

    public String CreateXML(MInvoice invoice) {
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            PO refdoc;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "DTE", null);
            document.setXmlVersion("1.0");
            Element Documento = document.createElement("Documento");
            document.getDocumentElement().appendChild(Documento);
            Documento.setAttribute("ID", "DTE-" + invoice.getDocumentNo());
            Element Encabezado = document.createElement("Encabezado");
            Documento.appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            mylog = "IdDoc";
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            Element FchCancel = document.createElement("FchCancel");
            Text cancel = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchCancel.appendChild(cancel);
            IdDoc.appendChild(FchCancel);
            Element FchVenc = document.createElement("FchVenc");
            Text venc = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            FchVenc.appendChild(venc);
            IdDoc.appendChild(FchVenc);
            Element TpoTranVenta = document.createElement("TpoTranVenta");
            Text TpoTranVentaTxt = document.createTextNode(invoice.get_ValueAsString("TipoTranVenta"));
            TpoTranVenta.appendChild(TpoTranVentaTxt);
            IdDoc.appendChild(TpoTranVenta);
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get(this.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(company.getName());
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(this.getCtx(), invoice.getC_BPartner_ID(), this.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(this.getCtx(), invoice.getC_BPartner_Location_ID(), this.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(this.getAD_User_ID() > 0 ? invoice.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element CorreoRecep = document.createElement("CorreoRecep");
            Text corrRecep = document.createTextNode(invoice.getAD_User().getEMail() == null ? " " : invoice.getAD_User().getEMail());
            CorreoRecep.appendChild(corrRecep);
            Receptor.appendChild(CorreoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            if (bloc.getLocation(true).getAddress2() != null && bloc.getLocation(true).getAddress2().length() > 0) {
                Element CmnaRecep = document.createElement("CmnaRecep");
                Text Cmna = document.createTextNode(bloc.getLocation(true).getAddress2());
                CmnaRecep.appendChild(Cmna);
                Receptor.appendChild(CmnaRecep);
            }
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(this.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : "Santiago");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountex = DB.getSQLValueBD(this.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(this.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element Detalle = document.createElement("Detalle");
                    Documento.appendChild(Detalle);
                    MTax tax = new MTax(this.getCtx(), iLine.getC_Tax_ID(), this.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(iLine.getDescription() == null ? " " : iLine.getDescription());
                    DscItem.appendChild(desc);
                    Detalle.appendChild(DscItem);
                    Element QtyRef = document.createElement("QtyRef");
                    Text qty = document.createTextNode(iLine.getQtyEntered().toString());
                    QtyRef.appendChild(qty);
                    Detalle.appendChild(QtyRef);
                    Element PrcRef = document.createElement("PrcRef");
                    Text pl = document.createTextNode(iLine.getPriceList().toString());
                    PrcRef.appendChild(pl);
                    Detalle.appendChild(PrcRef);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    Element PrcItem = document.createElement("PrcItem");
                    Text pa = document.createTextNode(iLine.getPriceActual().setScale(0, 4).toString());
                    PrcItem.appendChild(pa);
                    Detalle.appendChild(PrcItem);
                    Element MontoItem = document.createElement("MontoItem");
                    Text tl = document.createTextNode(iLine.getLineNetAmt().setScale(0, 4).toString());
                    MontoItem.appendChild(tl);
                    Detalle.appendChild(MontoItem);
                }
                ++i;
            }
            mylog = "referencia";
            String tiporeferencia = new String();
            String folioreferencia = new String();
            String fechareferencia = new String();
            int tipo_Ref = 0;
            if (invoice.get_Value("C_RefDoc_ID") != null && (Integer)invoice.get_Value("C_RefDoc_ID") > 0) {
                mylog = "referencia:invoice";
                refdoc = new MInvoice(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefDoc_ID")), invoice.get_TrxName());
                MDocType Refdoctype = new MDocType(invoice.getCtx(), ((X_C_Invoice)refdoc).getC_DocType_ID(), invoice.get_TrxName());
                tiporeferencia = (String)Refdoctype.get_Value("DocumentNo");
                folioreferencia = ((X_C_Invoice)refdoc).getDocumentNo();
                fechareferencia = ((X_C_Invoice)refdoc).getDateInvoiced().toString().substring(0, 10);
                tipo_Ref = 1;
            }
            if (invoice.getPOReference() != null && invoice.getPOReference().length() > 0) {
                mylog = "referencia:order";
                tiporeferencia = "801";
                folioreferencia = invoice.getPOReference();
                fechareferencia = invoice.getDateOrdered().toString().substring(0, 10);
                tipo_Ref = 2;
            }
            if (invoice.get_Value("C_RefInOut_ID") != null && (Integer)invoice.get_Value("C_RefInOut_ID") > 0) {
                mylog = "referencia:despacho";
                refdoc = new MInOut(invoice.getCtx(), (int)((Integer)invoice.get_Value("C_RefInOut_ID")), invoice.get_TrxName());
                tiporeferencia = "52";
                folioreferencia = ((X_M_InOut)refdoc).getDocumentNo();
                fechareferencia = ((X_M_InOut)refdoc).getMovementDate().toString().substring(0, 10);
                tipo_Ref = 3;
            }
            if (tipo_Ref > 0) {
                Element Referencia = document.createElement("Referencia");
                Documento.appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(tiporeferencia);
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(folioreferencia);
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(fechareferencia);
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element CodRef = document.createElement("CodRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("CodRef"));
                CodRef.appendChild(codref);
                Referencia.appendChild(CodRef);
                String sqlDN = "Select o.DocumentNo FROM C_Order o INNER JOIN C_Invoice i ON (o.C_Order_ID = i.C_Order_ID) WHERE i.C_Invoice_ID= ?";
                String docNoRef = DB.getSQLValueString(this.get_TrxName(), sqlDN, invoice.get_ID());
                if (docNoRef != null) {
                    Element Referencia2 = document.createElement("Referencia");
                    Documento.appendChild(Referencia2);
                    Element NroLinRef2 = document.createElement("NroLinRef");
                    Text Nro2 = document.createTextNode("2");
                    NroLinRef2.appendChild(Nro2);
                    Referencia2.appendChild(NroLinRef2);
                    Element TpoDocRef2 = document.createElement("TpoDocRef");
                    Text tpo2 = document.createTextNode("HES");
                    TpoDocRef2.appendChild(tpo2);
                    Referencia2.appendChild(TpoDocRef2);
                    Element FolioRef2 = document.createElement("FolioRef");
                    Text ref2 = document.createTextNode(docNoRef);
                    FolioRef2.appendChild(ref2);
                    Referencia2.appendChild(FolioRef2);
                    Element FchRef2 = document.createElement("FchRef");
                    Text fchref2 = document.createTextNode(fechareferencia);
                    FchRef2.appendChild(fchref2);
                    Referencia2.appendChild(FchRef2);
                    Element CodRef2 = document.createElement("CodRef");
                    Text codref2 = document.createTextNode(invoice.get_ValueAsString("CodRef"));
                    CodRef2.appendChild(codref2);
                    Referencia2.appendChild(CodRef2);
                }
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            Documento.appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Geminis Generated";
    }
}

