/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrg;
import org.compiere.model.MTax;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ExportDTEInvoiceITSA
extends SvrProcess {
    private Properties m_ctx;
    private int p_C_Invoice_ID = 0;
    public String urlPdf = "";

    @Override
    protected void prepare() {
        this.p_C_Invoice_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.m_ctx, this.p_C_Invoice_ID, this.get_TrxName());
        String msg = this.CreateXMLCGITSA(inv);
        return msg;
    }

    public String CreateXMLCGITSA(MInvoice invoice) {
        MDocType doc = new MDocType(invoice.getCtx(), invoice.getC_DocTypeTarget_ID(), invoice.get_TrxName());
        if (doc.get_Value("CreateXML") == null) {
            return "";
        }
        if (!((Boolean)doc.get_Value("CreateXML")).booleanValue()) {
            return "";
        }
        int typeDoc = Integer.parseInt((String)doc.get_Value("DocumentNo"));
        if (typeDoc == 0) {
            return "";
        }
        String mylog = new String();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            String obs;
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation implementation = builder.getDOMImplementation();
            Document document = implementation.createDocument(null, "Documento", null);
            document.setXmlVersion("1.0");
            document.setTextContent("text/xml");
            Attr atr = document.createAttribute("xmlns");
            atr.setValue("http://www.sii.cl/SiiDte");
            Element Encabezado = document.createElement("Encabezado");
            document.getDocumentElement().appendChild(Encabezado);
            Element IdDoc = document.createElement("IdDoc");
            Encabezado.appendChild(IdDoc);
            Element TipoDTE = document.createElement("TipoDTE");
            Text text = document.createTextNode(Integer.toString(typeDoc));
            TipoDTE.appendChild(text);
            IdDoc.appendChild(TipoDTE);
            Element Folio = document.createElement("Folio");
            Text fo = document.createTextNode(invoice.getDocumentNo());
            Folio.appendChild(fo);
            IdDoc.appendChild(Folio);
            Element FchEmis = document.createElement("FchEmis");
            Text emis = document.createTextNode(invoice.getDateInvoiced().toString().substring(0, 10));
            this.log.config("Fecha Emision " + invoice.getDateInvoiced().toString().substring(0, 10));
            FchEmis.appendChild(emis);
            IdDoc.appendChild(FchEmis);
            String fmapagodocumento = null;
            fmapagodocumento = invoice.getDateInvoiced().toString().substring(0, 10).compareToIgnoreCase(invoice.getDatePrinted().toString().substring(0, 10)) == 0 ? "1" : "2";
            Element FmaPago = document.createElement("FmaPago");
            Text fma = document.createTextNode(fmapagodocumento);
            FmaPago.appendChild(fma);
            IdDoc.appendChild(FmaPago);
            Timestamp datevenc = invoice.getDatePrinted();
            String datevenc2 = null;
            this.log.config("Fecha Vencimiento: " + datevenc);
            datevenc2 = datevenc == null ? "invoiced" : "printed";
            this.log.config("");
            this.log.config("datevenc2: " + datevenc2);
            datevenc2 = datevenc2 == "printed" ? invoice.getDatePrinted().toString().substring(0, 10) : invoice.getDateInvoiced().toString().substring(0, 10);
            Element FchVenc = document.createElement("FchVenc");
            this.log.config("Fecha Vencimiento: " + datevenc2);
            Text venc = document.createTextNode(datevenc2);
            FchVenc.appendChild(venc);
            IdDoc.appendChild(FchVenc);
            Element Emisor = document.createElement("Emisor");
            Encabezado.appendChild(Emisor);
            mylog = "Emisor";
            MOrg company = MOrg.get(this.getCtx(), invoice.getAD_Org_ID());
            Element Rut = document.createElement("RUTEmisor");
            Text rut = document.createTextNode((String)company.get_Value("Rut"));
            this.log.config("Rut Emisor: " + (String)company.get_Value("Rut"));
            Rut.appendChild(rut);
            Emisor.appendChild(Rut);
            String nameRzn = company.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = company.getName();
            }
            Element RznSoc = document.createElement("RznSoc");
            Text rzn = document.createTextNode(nameRzn);
            RznSoc.appendChild(rzn);
            Emisor.appendChild(RznSoc);
            Element GiroEmis = document.createElement("GiroEmis");
            Text gi = document.createTextNode((String)company.get_Value("Giro"));
            GiroEmis.appendChild(gi);
            Emisor.appendChild(GiroEmis);
            Element Acteco = document.createElement("Acteco");
            Text teco = document.createTextNode((String)company.get_Value("Acteco"));
            this.log.config("ACTECO: " + (String)company.get_Value("Acteco"));
            Acteco.appendChild(teco);
            Emisor.appendChild(Acteco);
            Element DirOrigen = document.createElement("DirOrigen");
            Text dir = document.createTextNode((String)company.get_Value("Address1"));
            DirOrigen.appendChild(dir);
            Emisor.appendChild(DirOrigen);
            Element CmnaOrigen = document.createElement("CmnaOrigen");
            Text com = document.createTextNode((String)company.get_Value("Comuna"));
            this.log.config("COMUNA " + (String)company.get_Value("Comuna"));
            CmnaOrigen.appendChild(com);
            Emisor.appendChild(CmnaOrigen);
            Element CiudadOrigen = document.createElement("CiudadOrigen");
            Text city = document.createTextNode((String)company.get_Value("City"));
            this.log.config("COMUNA " + (String)company.get_Value("City"));
            CiudadOrigen.appendChild(city);
            Emisor.appendChild(CiudadOrigen);
            mylog = "receptor";
            MBPartner BP = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
            MBPartnerLocation bloc = new MBPartnerLocation(invoice.getCtx(), invoice.getC_BPartner_Location_ID(), invoice.get_TrxName());
            Element Receptor = document.createElement("Receptor");
            Encabezado.appendChild(Receptor);
            Element RUTRecep = document.createElement("RUTRecep");
            Text rutc = document.createTextNode(BP.getValue() + "-" + BP.get_ValueAsString("Digito"));
            RUTRecep.appendChild(rutc);
            Receptor.appendChild(RUTRecep);
            Element RznSocRecep = document.createElement("RznSocRecep");
            Text RznSocR = document.createTextNode(BP.getName());
            RznSocRecep.appendChild(RznSocR);
            Receptor.appendChild(RznSocRecep);
            Element GiroRecep = document.createElement("GiroRecep");
            Text giro = document.createTextNode((String)BP.get_Value("Giro"));
            GiroRecep.appendChild(giro);
            Receptor.appendChild(GiroRecep);
            Element ContactoRecep = document.createElement("Contacto");
            Text contacto = document.createTextNode(invoice.getAD_User_ID() > 0 ? invoice.getAD_User().getName() : " ");
            ContactoRecep.appendChild(contacto);
            Receptor.appendChild(ContactoRecep);
            Element DirRecep = document.createElement("DirRecep");
            Text dirr = document.createTextNode(bloc.getLocation(true).getAddress1());
            DirRecep.appendChild(dirr);
            Receptor.appendChild(DirRecep);
            String ciudad2 = "";
            ciudad2 = DB.getSQLValueString(invoice.get_TrxName(), "SELECT city from c_location where c_location_id = ?", bloc.getLocation(true).get_ID());
            this.log.config("CIUDAD2" + ciudad2);
            this.log.config("ID " + bloc.get_ID());
            if (ciudad2 == null) {
                ciudad2 = "Santiago";
            }
            Element CmnaRecep = document.createElement("CmnaRecep");
            Text reg2 = document.createTextNode(bloc.getLocation(true).getC_City_ID() > 0 ? MCity.get(this.getCtx(), bloc.getLocation(true).getC_City_ID()).getName() : ciudad2);
            CmnaRecep.appendChild(reg2);
            Receptor.appendChild(CmnaRecep);
            Element CiudadRecep = document.createElement("CiudadRecep");
            Text reg = document.createTextNode(bloc.getLocation(true).getAddress2() != null ? bloc.getLocation(true).getAddress2() : "");
            CiudadRecep.appendChild(reg);
            Receptor.appendChild(CiudadRecep);
            String validaciontransporte = invoice.get_ValueAsString("IsCarrier");
            this.log.config("validacion " + validaciontransporte);
            if (validaciontransporte.equals("true")) {
                mylog = "Transporte";
                Element Transporte = document.createElement("Transporte");
                Encabezado.appendChild(Transporte);
                Element Patente = document.createElement("Patente");
                Text patent = document.createTextNode(invoice.get_ValueAsString("Patent"));
                Patente.appendChild(patent);
                Transporte.appendChild(Patente);
                Element RUTTrans = document.createElement("RUTTrans");
                Text ruttrans = document.createTextNode(invoice.get_ValueAsString("CarrierID"));
                RUTTrans.appendChild(ruttrans);
                Transporte.appendChild(RUTTrans);
                Element DirDest = document.createElement("DirDest");
                Text dirde = document.createTextNode(invoice.get_ValueAsString("Address4"));
                this.log.config("rut transportista : " + invoice.get_ValueAsString("Address4"));
                this.log.config("Fecha Emision " + invoice.getDateInvoiced().toString().substring(0, 10));
                DirDest.appendChild(dirde);
                Transporte.appendChild(DirDest);
                Element CmnaDest = document.createElement("CmnaDest");
                Text cmna = document.createTextNode(invoice.get_ValueAsString("DestinationCity1"));
                this.log.config("Comuna destino " + invoice.get_ValueAsString("DestinationCity1"));
                CmnaDest.appendChild(cmna);
                Transporte.appendChild(CmnaDest);
                Element CiudadDest = document.createElement("CiudadDest");
                this.log.config("Fecha Vencimiento: " + datevenc2);
                Text ciudad = document.createTextNode(invoice.get_ValueAsString("DestinationCity2"));
                CiudadDest.appendChild(ciudad);
                Transporte.appendChild(CiudadDest);
            }
            mylog = "Totales";
            Element Totales = document.createElement("Totales");
            Encabezado.appendChild(Totales);
            BigDecimal amountex = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='Y' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            BigDecimal amountNeto = DB.getSQLValueBD(invoice.get_TrxName(), "select Round(COALESCE(SUM(il.LineNetAmt),0),0) from C_InvoiceLine il  inner join C_Tax t on (il.C_Tax_ID=t.C_Tax_ID) and t.istaxexempt='N' and il.C_Invoice_ID=" + invoice.getC_Invoice_ID(), new Object[0]);
            Element MntNeto = document.createElement("MntNeto");
            Text neto = document.createTextNode(amountNeto != null ? amountNeto.toString() : "0");
            MntNeto.appendChild(neto);
            Totales.appendChild(MntNeto);
            Element MntExe = document.createElement("MntExe");
            Text exe = document.createTextNode(amountex != null ? amountex.toString() : "0");
            MntExe.appendChild(exe);
            Totales.appendChild(MntExe);
            if (amountNeto.signum() > 0) {
                Element TasaIVA = document.createElement("TasaIVA");
                Text tiva = document.createTextNode("19");
                TasaIVA.appendChild(tiva);
                Totales.appendChild(TasaIVA);
            }
            Element IVA = document.createElement("IVA");
            BigDecimal ivaamt = Env.ZERO;
            if (amountex.intValue() != invoice.getGrandTotal().intValue()) {
                ivaamt = invoice.getGrandTotal().subtract(invoice.getTotalLines()).setScale(0, 4);
            }
            Text iva = document.createTextNode(ivaamt.toString());
            IVA.appendChild(iva);
            Totales.appendChild(IVA);
            Element MntTotal = document.createElement("MntTotal");
            Text total = document.createTextNode(invoice.getGrandTotal().setScale(0, 4).toString());
            MntTotal.appendChild(total);
            Totales.appendChild(MntTotal);
            mylog = "detalle";
            MInvoiceLine[] iLines = invoice.getLines(false);
            int i = 0;
            while (i < iLines.length) {
                MInvoiceLine iLine = iLines[i];
                if (iLine.getM_Product_ID() != 0 || iLine.getC_Charge_ID() != 0) {
                    Element MontoItem;
                    BigDecimal monto2;
                    int res2;
                    Element Detalle = document.createElement("Detalle");
                    document.getDocumentElement().appendChild(Detalle);
                    MTax tax = new MTax(invoice.getCtx(), iLine.getC_Tax_ID(), invoice.get_TrxName());
                    if (tax.isTaxExempt()) {
                        Element IndEx = document.createElement("IndExe");
                        Text lineE = document.createTextNode("1");
                        IndEx.appendChild(lineE);
                        Detalle.appendChild(IndEx);
                    }
                    Element NroLinDet = document.createElement("NroLinDet");
                    Text line = document.createTextNode(Integer.toString(iLine.getLine() / 10));
                    NroLinDet.appendChild(line);
                    Detalle.appendChild(NroLinDet);
                    Element cdgitem = document.createElement("CdgItem");
                    document.getDocumentElement().appendChild(cdgitem);
                    Element tpocodigo = document.createElement("TpoCodigo");
                    Text dd = document.createTextNode("");
                    tpocodigo.appendChild(dd);
                    cdgitem.appendChild(tpocodigo);
                    String tpocodigostring = "";
                    int attributesetinstanceid = iLine.getM_AttributeSetInstance_ID();
                    tpocodigostring = attributesetinstanceid != 0 ? DB.getSQLValueString(invoice.get_TrxName(), "SELECT value from m_attributeinstance where m_Attribute_id = 1000014 and m_attributesetinstance_id = " + iLine.getM_AttributeSetInstance_ID(), new Object[0]) : (iLine.getProduct() != null ? DB.getSQLValueString(invoice.get_TrxName(), "SELECT value from m_product where m_product_id = " + iLine.getM_Product_ID(), new Object[0]) : DB.getSQLValueString(invoice.get_TrxName(), "SELECT name from c_charge where c_charge_id = " + iLine.getC_Charge_ID(), new Object[0]));
                    this.log.config("TpoCodigo " + tpocodigostring);
                    Element vlrcodigo = document.createElement("VlrCodigo");
                    Text vlr = document.createTextNode(tpocodigostring);
                    vlrcodigo.appendChild(vlr);
                    cdgitem.appendChild(vlrcodigo);
                    Detalle.appendChild(cdgitem);
                    Element NmbItem = document.createElement("NmbItem");
                    String pname = "";
                    pname = iLine.getProduct() != null ? iLine.getProduct().getName() : iLine.getC_Charge().getName();
                    this.log.config("obane " + pname);
                    Text Item = document.createTextNode(pname);
                    NmbItem.appendChild(Item);
                    Detalle.appendChild(NmbItem);
                    String dscitem = "";
                    dscitem = iLine.getDescription().length() < 171 ? iLine.getDescription() : iLine.getDescription().substring(0, 170);
                    this.log.config("descitem: " + dscitem);
                    Element DscItem = document.createElement("DscItem");
                    Text desc = document.createTextNode(dscitem);
                    DscItem.appendChild(desc);
                    Detalle.appendChild(DscItem);
                    Element QtyItem = document.createElement("QtyItem");
                    Text qt = document.createTextNode(iLine.getQtyInvoiced().setScale(2, RoundingMode.HALF_UP).toString());
                    QtyItem.appendChild(qt);
                    Detalle.appendChild(QtyItem);
                    String sqluom = DB.getSQLValueString(invoice.get_TrxName(), "SELECT UOMSymbol from c_uom where c_uom_id in (select c_uom_id from c_invoiceline where c_invoiceline_id = ?)", iLine.get_ID());
                    Element UnmdItem = document.createElement("UnmdItem");
                    Text Unn = document.createTextNode(sqluom);
                    UnmdItem.appendChild(Unn);
                    Detalle.appendChild(UnmdItem);
                    BigDecimal monto = iLine.getPriceActual();
                    BigDecimal zerovalue = new BigDecimal("0");
                    String value1 = "0";
                    int res = monto.compareTo(zerovalue);
                    this.log.config("valor resultado = " + res);
                    if (res != -1) {
                        BigDecimal preciounitario = Env.ZERO;
                        preciounitario = iLine.getPriceList() == Env.ZERO ? iLine.getPriceActual() : iLine.getPriceList();
                        Element PrcItem = document.createElement("PrcItem");
                        Text pa = document.createTextNode(preciounitario.setScale(2, RoundingMode.HALF_UP).toString());
                        PrcItem.appendChild(pa);
                        Detalle.appendChild(PrcItem);
                    }
                    if (iLine.getPriceList().compareTo(iLine.getPriceActual()) == 1) {
                        BigDecimal porcentajedescuento = Env.ZERO;
                        BigDecimal porcentajedescuentoreal = Env.ZERO;
                        porcentajedescuento = iLine.getPriceActual().multiply(Env.ONEHUNDRED);
                        porcentajedescuento = porcentajedescuento.divide(iLine.getPriceList(), 2, RoundingMode.HALF_EVEN);
                        porcentajedescuentoreal = Env.ONEHUNDRED.subtract(porcentajedescuento);
                        this.log.config("porcentajedescuentoreal " + porcentajedescuentoreal);
                        Element DescuentoPct = document.createElement("DescuentoPct");
                        Text pa1 = document.createTextNode(porcentajedescuentoreal.toString());
                        DescuentoPct.appendChild(pa1);
                        Detalle.appendChild(DescuentoPct);
                        BigDecimal descuentomonto = iLine.getPriceList().subtract(iLine.getPriceActual());
                        descuentomonto = iLine.getQtyInvoiced().multiply(descuentomonto).setScale(0, RoundingMode.HALF_UP);
                        this.log.config("decuento por monto " + descuentomonto);
                        Element DescuentoMonto = document.createElement("DescuentoMonto");
                        Text pa2 = document.createTextNode(descuentomonto.toString());
                        DescuentoMonto.appendChild(pa2);
                        Detalle.appendChild(DescuentoMonto);
                    }
                    if ((res2 = (monto2 = iLine.getLineNetAmt()).compareTo(zerovalue)) == -1) {
                        MontoItem = document.createElement("MontoItem");
                        Text t1 = document.createTextNode(value1);
                        MontoItem.appendChild(t1);
                        Detalle.appendChild(MontoItem);
                    } else {
                        MontoItem = document.createElement("MontoItem");
                        Text tl = document.createTextNode(iLine.getLineNetAmt().setScale(0, 4).toString());
                        MontoItem.appendChild(tl);
                        Detalle.appendChild(MontoItem);
                    }
                }
                ++i;
            }
            String sqldescuentos = "select sum(linenetamt) from c_invoiceline where linenetamt < 0 and c_invoice_id = " + invoice.get_ID();
            this.log.config("SQL DE FACTURA = " + sqldescuentos);
            int descuento = DB.getSQLValue(this.get_TrxName(), sqldescuentos);
            this.log.config("descuento = " + descuento);
            if (descuento < 0) {
                descuento *= -1;
                mylog = "DscRcgGlobal";
                Element DscRcgGlobal = document.createElement("DscRcgGlobal");
                document.getDocumentElement().appendChild(DscRcgGlobal);
                Element NroLinDR = document.createElement("NroLinDR");
                Text Nro = document.createTextNode("1");
                NroLinDR.appendChild(Nro);
                DscRcgGlobal.appendChild(NroLinDR);
                Element TpoMov = document.createElement("TpoMov");
                Text Nro2 = document.createTextNode("D");
                TpoMov.appendChild(Nro2);
                DscRcgGlobal.appendChild(TpoMov);
                Element GlosaDR = document.createElement("GlosaDR");
                Text Nro3 = document.createTextNode("Descuento");
                GlosaDR.appendChild(Nro3);
                DscRcgGlobal.appendChild(GlosaDR);
                Element TpoValor = document.createElement("TpoValor");
                Text Nro4 = document.createTextNode("$");
                TpoValor.appendChild(Nro4);
                DscRcgGlobal.appendChild(TpoValor);
                Element ValorDR = document.createElement("ValorDR");
                Text Nro5 = document.createTextNode(String.valueOf(descuento));
                ValorDR.appendChild(Nro5);
                DscRcgGlobal.appendChild(ValorDR);
            }
            String attachment1 = invoice.get_ValueAsString("Attachment1");
            this.log.config("attachment 1 = " + attachment1);
            if (attachment1 == "true") {
                mylog = "Referencia";
                Element Referencia = document.createElement("Referencia");
                document.getDocumentElement().appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("1");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(invoice.get_ValueAsString("RefDocType1"));
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(invoice.get_ValueAsString("FolioNumber1"));
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(invoice.get_ValueAsString("DateRef1").toString().substring(0, 10));
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element RazonRef = document.createElement("RazonRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("RefReason1"));
                RazonRef.appendChild(codref);
                Referencia.appendChild(RazonRef);
            }
            String attachment2 = invoice.get_ValueAsString("Attachment2");
            this.log.config("attachment 2 = " + attachment2);
            if (attachment2 == "true") {
                mylog = "Referencia";
                Element Referencia = document.createElement("Referencia");
                document.getDocumentElement().appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("2");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(invoice.get_ValueAsString("RefDocType2"));
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(invoice.get_ValueAsString("FolioNumber2"));
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(invoice.get_ValueAsString("DateRef2").toString().substring(0, 10));
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element RazonRef = document.createElement("RazonRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("RefReason2"));
                RazonRef.appendChild(codref);
                Referencia.appendChild(RazonRef);
            }
            String attachment3 = invoice.get_ValueAsString("Attachment3");
            this.log.config("attachment 3 = " + attachment3);
            if (attachment3 == "true") {
                mylog = "Referencia";
                Element Referencia = document.createElement("Referencia");
                document.getDocumentElement().appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("3");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(invoice.get_ValueAsString("RefDocType3"));
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(invoice.get_ValueAsString("FolioNumber3"));
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(invoice.get_ValueAsString("DateRef3").toString().substring(0, 10));
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element RazonRef = document.createElement("RazonRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("RefReason3"));
                RazonRef.appendChild(codref);
                Referencia.appendChild(RazonRef);
            }
            String attachment4 = invoice.get_ValueAsString("Attachment4");
            this.log.config("attachment 4 = " + attachment4);
            if (attachment4 == "true") {
                mylog = "Referencia";
                Element Referencia = document.createElement("Referencia");
                document.getDocumentElement().appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("4");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(invoice.get_ValueAsString("RefDocType4"));
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(invoice.get_ValueAsString("FolioNumber4"));
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(invoice.get_ValueAsString("DateRef4").toString().substring(0, 10));
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element RazonRef = document.createElement("RazonRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("RefReason4"));
                RazonRef.appendChild(codref);
                Referencia.appendChild(RazonRef);
            }
            String attachment5 = invoice.get_ValueAsString("Attachment5");
            this.log.config("attachment 5 = " + attachment5);
            if (attachment5 == "true") {
                mylog = "Referencia";
                Element Referencia = document.createElement("Referencia");
                document.getDocumentElement().appendChild(Referencia);
                Element NroLinRef = document.createElement("NroLinRef");
                Text Nro = document.createTextNode("5");
                NroLinRef.appendChild(Nro);
                Referencia.appendChild(NroLinRef);
                Element TpoDocRef = document.createElement("TpoDocRef");
                Text tpo = document.createTextNode(invoice.get_ValueAsString("RefDocType5"));
                TpoDocRef.appendChild(tpo);
                Referencia.appendChild(TpoDocRef);
                Element FolioRef = document.createElement("FolioRef");
                Text ref = document.createTextNode(invoice.get_ValueAsString("FolioNumber5"));
                FolioRef.appendChild(ref);
                Referencia.appendChild(FolioRef);
                Element FchRef = document.createElement("FchRef");
                Text fchref = document.createTextNode(invoice.get_ValueAsString("DateRef5").toString().substring(0, 10));
                FchRef.appendChild(fchref);
                Referencia.appendChild(FchRef);
                Element RazonRef = document.createElement("RazonRef");
                Text codref = document.createTextNode(invoice.get_ValueAsString("RefReason5"));
                RazonRef.appendChild(codref);
                Referencia.appendChild(RazonRef);
            }
            if ((obs = invoice.get_ValueAsString("Help")) != null) {
                mylog = "Adjuntos";
                Element Adjuntos = document.createElement("Adjuntos");
                document.getDocumentElement().appendChild(Adjuntos);
                Element Observacion = document.createElement("Observacion");
                Text adj = document.createTextNode(obs);
                Observacion.appendChild(adj);
                Adjuntos.appendChild(Observacion);
            }
            mylog = "firma";
            Element Firma = document.createElement("TmstFirma");
            Timestamp today = new Timestamp(TimeUtil.getToday().getTimeInMillis());
            Text Ftext = document.createTextNode(today.toString().substring(0, 10) + "T" + today.toString().substring(11, 19));
            Firma.appendChild(Ftext);
            document.getDocumentElement().appendChild(Firma);
            mylog = "archivo";
            String ExportDir = (String)company.get_Value("ExportDir");
            this.log.config("EXPORTDIR1 " + ExportDir);
            try {
                File theDir = new File(ExportDir);
                if (!theDir.exists()) {
                    ExportDir = (String)company.get_Value("ExportDir");
                }
            }
            catch (Exception e) {
                throw new AdempiereException("no existe directorio");
            }
            this.log.config("EXPORTDIR " + ExportDir);
            ExportDir = ExportDir.replace("\\", "/");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(new File(ExportDir, invoice.getDocumentNo() + ".xml"));
            String nombrearchivo = String.valueOf(invoice.getDocumentNo()) + ".xml";
            this.log.config("To string :" + nombrearchivo);
            StreamResult console = new StreamResult(System.out);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            transformer.transform(source, result);
            transformer.transform(source, console);
        }
        catch (Exception e) {
            this.log.severe("CreateXML: " + mylog + "--" + e.getMessage());
            return "CreateXML: " + mylog + "--" + e.getMessage();
        }
        return "XML Generated";
    }

    public Node findReturn(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:SolicitarSesionResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturn(childNode);
            ++i;
        }
        return value;
    }

    public Node findReturnEnviarDTE(Node node) {
        Node value = null;
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node childNode = list.item(i);
            if (childNode.getNodeName().equals("ns1:EnviarDTEResponse")) {
                value = childNode;
                break;
            }
            value = this.findReturnEnviarDTE(childNode);
            ++i;
        }
        return value;
    }

    public String findText(String cadena, String fragmentoIni, String fragmentoFin) {
        String newText = "";
        int indiceIni = 0;
        int indiceFin = 0;
        boolean flag = cadena.contains(fragmentoIni);
        if (flag) {
            indiceIni = cadena.indexOf(fragmentoIni);
            indiceFin = cadena.indexOf(fragmentoFin);
            newText = cadena.substring(indiceIni += fragmentoIni.length(), indiceFin);
        } else {
            newText = "Error - No existe Cadena Especificada";
        }
        return newText;
    }

    public String PrintPDF(String p_url) {
        block11: {
            SimpleDoc pdfDoc;
            DocPrintJob job;
            HashPrintRequestAttributeSet attributes;
            PrintService service;
            block10: {
                block9: {
                    try {
                        service = PrintServiceLookup.lookupDefaultPrintService();
                        if (service != null) {
                            DocFlavor.INPUT_STREAM psFormat = DocFlavor.INPUT_STREAM.AUTOSENSE;
                            HashPrintRequestAttributeSet attributes2 = new HashPrintRequestAttributeSet();
                            DocPrintJob job2 = service.createPrintJob();
                            SimpleDoc pdfDoc2 = new SimpleDoc(new URL(p_url).openStream(), psFormat, null);
                            job2.print(pdfDoc2, attributes2);
                            break block9;
                        }
                        return "No Print Service";
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
                try {
                    service = PrintServiceLookup.lookupDefaultPrintService();
                    if (service != null) {
                        attributes = new HashPrintRequestAttributeSet();
                        job = service.createPrintJob();
                        pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.URL.AUTOSENSE, null);
                        job.print(pdfDoc, attributes);
                        break block10;
                    }
                    return "No Print Service";
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            try {
                service = PrintServiceLookup.lookupDefaultPrintService();
                if (service != null) {
                    attributes = new HashPrintRequestAttributeSet();
                    job = service.createPrintJob();
                    pdfDoc = new SimpleDoc(new URL(p_url).openStream(), DocFlavor.BYTE_ARRAY.AUTOSENSE, null);
                    job.print(pdfDoc, attributes);
                    break block11;
                }
                return "No Print Service";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return "Imprimiendo...";
    }
}

