/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.I_GL_Journal;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MClient;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MDocType;
import org.compiere.model.MGLCategory;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPeriod;
import org.compiere.model.X_A_Asset;
import org.compiere.model.X_A_Asset_Dep;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.model.X_GL_JournalBatch;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DepreAssetsDefensoria
extends SvrProcess {
    private Properties m_ctx;
    private int Record_ID;
    X_A_Asset_Dep DepDoc = null;

    @Override
    protected void prepare() {
        this.m_ctx = Env.getCtx();
        this.Record_ID = this.getRecord_ID();
        this.DepDoc = new X_A_Asset_Dep(this.m_ctx, this.Record_ID, this.get_TrxName());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String doIt() throws Exception {
        Calendar cal;
        Timestamp datefrom = null;
        Timestamp dateto = null;
        if (this.DepDoc.getDepType().equalsIgnoreCase("DCM") && this.DepDoc.getDocStatus().equals("DR")) {
            this.replanningDPP(0, this.DepDoc.getAD_Org_ID(), this.DepDoc.getA_Asset_Group_ID(), "Y");
            this.commitEx();
        }
        String sql = "select a.a_asset_id,a.name,a.value,acct.c_acctschema_id, acct.a_asset_acct,  acct.a_depreciation_acct, fore.amount,fore.a_asset_forecast_id,p.c_period_id,p.name, acct.a_accumdepreciation_acct,acct.A_Disposal_Gain_Acct,wk.a_asset_cost,acct.A_Disposal_RevenueC_Acct, acct.A_Disposal_RevenueD_Acct,acct.A_Disposal_Loss_Acct, wk.a_accumulated_depr, acct.A_AssetComplement_Acct from a_asset a inner join a_asset_acct acct on (a.a_asset_id=acct.a_asset_id) inner join A_Depreciation_Workfile wk on (a.a_asset_id=wk.a_asset_id) inner join a_asset_forecast fore on (a.a_asset_id=fore.a_asset_id) inner join c_period p on (fore.datedoc between p.startdate and p.enddate) where a.ad_client_id=? and p.c_period_id=? and acct.IsActive='Y' ";
        if (this.DepDoc.isSameYear()) {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            datefrom = new Timestamp(cal.getTimeInMillis());
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            dateto = new Timestamp(cal.getTimeInMillis());
        } else {
            cal = Calendar.getInstance();
            cal.set(6, 1);
            cal.set(1, cal.get(1) - 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            datefrom = new Timestamp(cal.getTimeInMillis());
            cal.set(2, 11);
            cal.set(5, 31);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            dateto = new Timestamp(cal.getTimeInMillis());
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
            sql = String.valueOf(sql) + " And fore.processed='N' and a.isinposession='Y' And a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
            sql = String.valueOf(sql) + " And fore.Corrected='N' And a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("REV") || this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
            sql = this.DepDoc.getA_Asset_ID() > 0 ? String.valueOf(sql) + " And wk.a_asset_cost>wk.a_accumulated_depr+2 And a.A_Asset_ID=" + this.DepDoc.getA_Asset_ID() + " and fore.amount > 0  and a.isinposession=" + (this.DepDoc.isInPosession() ? "'Y'" : "'N'") : String.valueOf(sql) + " And wk.a_asset_cost>wk.a_accumulated_depr+2 And a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID() + " and fore.amount > 0 and a.isinposession=" + (this.DepDoc.isInPosession() ? "'Y'" : "'N'");
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
            int id_invoice = 0;
            try {
                id_invoice = this.DepDoc.get_ValueAsInt("C_Invoice_ID");
            }
            catch (Exception e) {
                id_invoice = 0;
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            sql = id_invoice > 0 ? String.valueOf(sql) + " And a.A_Asset_ID IN (SELECT DISTINCT(A_Asset_ID) FROM C_InvoiceLine WHERE C_Invoice_ID = " + this.DepDoc.get_ValueAsInt("C_Invoice_ID") + ")" : String.valueOf(sql) + " And a.A_Asset_ID=" + this.DepDoc.getA_Asset_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("CRN")) {
            sql = String.valueOf(sql) + " And fore.Corrected='N' And a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (this.DepDoc.getDepType().equalsIgnoreCase("DCM")) {
            sql = String.valueOf(sql) + " And fore.Corrected='N' and a.isinposession='Y' and a.a_asset_group_id=" + this.DepDoc.getA_Asset_Group_ID();
        }
        if (this.DepDoc.getAD_Org_ID() > 0) {
            sql = String.valueOf(sql) + " and a.AD_Org_ID=" + this.DepDoc.getAD_Org_ID();
        }
        sql = String.valueOf(sql) + " and a.IsInPosession = 'Y' and a.IsActive = 'Y' ";
        CPreparedStatement pstmt = null;
        this.log.config("SQL: " + sql);
        X_GL_JournalBatch batch = null;
        MJournal journal = null;
        MClient client = MClient.get(this.m_ctx, Env.getAD_Client_ID(this.m_ctx));
        int count = 0;
        if (this.DepDoc.getDocStatus().equals("DR")) {
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.DepDoc.getAD_Client_ID());
                if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    int period_ID = DB.getSQLValue(this.get_TrxName(), "select max(p.c_period_id) from A_Asset_Forecast fore inner join c_period p on (fore.datedoc between p.startdate and p.enddate)where A_Asset_ID = " + this.DepDoc.getA_Asset_ID());
                    pstmt.setInt(2, period_ID);
                } else {
                    pstmt.setInt(2, this.DepDoc.getC_Period_ID());
                }
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    MJournalLine line2;
                    MJournalLine line1;
                    BigDecimal newAmount;
                    MJournalLine line4;
                    MJournalLine line3;
                    MJournalLine line22;
                    MJournalLine line12;
                    if (batch == null) {
                        batch = new MJournalBatch(this.m_ctx, 0, this.get_TrxName());
                        batch.setAD_Org_ID(this.DepDoc.getAD_Org_ID());
                        batch.setDescription("Assets Deprecation Process");
                        batch.setPostingType("A");
                        batch.setC_DocType_ID(MDocType.getOfDocBaseType(this.m_ctx, "GLJ")[0].getC_DocType_ID());
                        batch.setGL_Category_ID(MGLCategory.getDefault(this.m_ctx, "M").getGL_Category_ID());
                        ((MJournalBatch)batch).setDateAcct(this.DepDoc.getDateDoc());
                        batch.setDateDoc(this.DepDoc.getDateDoc());
                        batch.setC_Period_ID(MPeriod.getC_Period_ID(this.m_ctx, this.DepDoc.getDateAcct()));
                        batch.setC_Currency_ID(client.getC_Currency_ID());
                        if (!batch.save()) {
                            return "la transaccion no puede ser generara para *";
                        }
                    }
                    ++count;
                    journal = new MJournal((MJournalBatch)batch);
                    journal.setDescription(String.valueOf(rs.getString("value")) + "-" + rs.getString("name"));
                    journal.setC_AcctSchema_ID(MAcctSchema.getClientAcctSchema(this.m_ctx, Env.getAD_Client_ID(this.m_ctx))[0].getC_AcctSchema_ID());
                    journal.setGL_Category_ID(MGLCategory.getDefault(this.m_ctx, "D").getGL_Category_ID());
                    journal.setC_ConversionType_ID(114);
                    journal.set_ValueOfColumn("A_Asset_ID", (Object)rs.getInt("a_asset_id"));
                    journal.set_ValueOfColumn("A_Asset_Forecast_ID", (Object)rs.getInt("a_asset_forecast_id"));
                    journal.save();
                    if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                        line12 = new MJournalLine(journal);
                        line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line12.setAmtSourceDr(rs.getBigDecimal("amount"));
                        line12.setAmtSourceCr(Env.ZERO);
                        line12.setAmtAcct(rs.getBigDecimal("amount"), Env.ZERO);
                        line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line12.save();
                        line22 = new MJournalLine(journal);
                        line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line22.setAmtSourceDr(Env.ZERO);
                        line22.setAmtSourceCr(rs.getBigDecimal("amount"));
                        line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("amount"));
                        line22.setC_ValidCombination_ID(rs.getInt("A_AssetComplement_Acct"));
                        line22.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                        batch.setDescription("Correcion Monetaria");
                        line12 = new MJournalLine(journal);
                        line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line12.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line12.setAmtSourceCr(Env.ZERO);
                            line12.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                        } else if (this.DepDoc.getRate().signum() < 0) {
                            line12.setAmtSourceDr(Env.ZERO);
                            line12.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line12.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        }
                        line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line12.save();
                        line22 = new MJournalLine(journal);
                        line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line22.setAmtSourceDr(Env.ZERO);
                            line22.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line22.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line22.setAmtSourceCr(Env.ZERO);
                            line22.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        line22.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                        line22.save();
                        line3 = new MJournalLine(journal);
                        line3.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line3.setAmtSourceDr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line3.setAmtSourceCr(Env.ZERO);
                            line3.setAmtAcct(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line3.setAmtSourceDr(Env.ZERO);
                            line3.setAmtSourceCr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line3.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        }
                        line3.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line3.save();
                        line4 = new MJournalLine(journal);
                        line4.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line4.setAmtSourceDr(Env.ZERO);
                            line4.setAmtSourceCr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line4.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line4.setAmtSourceDr(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line4.setAmtSourceCr(Env.ZERO);
                            line4.setAmtAcct(rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        line4.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                        line4.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                        batch.setDescription("Reevaluacion Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = ((BigDecimal)this.DepDoc.get_Value("Amt")).compareTo(Env.ZERO) != 0 ? (BigDecimal)this.DepDoc.get_Value("Amt") : rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("A_Disposal_Gain_Acct"));
                        line2.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                        batch.setDescription("Deteriodo Activos");
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED));
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("A_Disposal_Loss_Acct"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(rs.getInt("a_asset_id"));
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line2.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                        newAmount = new BigDecimal(0.0);
                        newAmount = rs.getBigDecimal("a_asset_cost").subtract(rs.getBigDecimal("a_accumulated_depr"));
                        newAmount = newAmount.add(Env.ONE);
                        line1 = new MJournalLine(journal);
                        line1.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line1.setAmtSourceDr(newAmount);
                        line1.setAmtSourceCr(Env.ZERO);
                        line1.setAmtAcct(newAmount, Env.ZERO);
                        line1.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                        line1.save();
                        line2 = new MJournalLine(journal);
                        line2.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line2.setAmtSourceDr(Env.ZERO);
                        line2.setAmtSourceCr(newAmount);
                        line2.setAmtAcct(Env.ZERO, newAmount);
                        line2.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line2.save();
                        MJournalLine line32 = new MJournalLine(journal);
                        line32.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line32.setAmtSourceDr(this.DepDoc.getRate());
                        line32.setAmtSourceCr(Env.ZERO);
                        line32.setAmtAcct(this.DepDoc.getRate(), Env.ZERO);
                        line32.setC_ValidCombination_ID(rs.getInt("A_Disposal_RevenueD_Acct"));
                        line32.save();
                        MJournalLine line42 = new MJournalLine(journal);
                        line42.setA_Asset_ID(this.DepDoc.getA_Asset_ID());
                        line42.setAmtSourceDr(Env.ZERO);
                        line42.setAmtSourceCr(this.DepDoc.getRate());
                        line42.setAmtAcct(Env.ZERO, this.DepDoc.getRate());
                        line42.setC_ValidCombination_ID(rs.getInt("A_Disposal_RevenueC_Acct"));
                        line42.save();
                        continue;
                    }
                    if (this.DepDoc.getDepType().equalsIgnoreCase("CRN")) {
                        batch.setDescription("Correcion Monetaria");
                        line12 = new MJournalLine(journal);
                        line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line12.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line12.setAmtSourceCr(Env.ZERO);
                            line12.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                        } else if (this.DepDoc.getRate().signum() < 0) {
                            line12.setAmtSourceDr(Env.ZERO);
                            line12.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line12.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        }
                        line12.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                        line12.save();
                        line22 = new MJournalLine(journal);
                        line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                        if (this.DepDoc.getRate().signum() > 0) {
                            line22.setAmtSourceDr(Env.ZERO);
                            line22.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                            line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        }
                        if (this.DepDoc.getRate().signum() < 0) {
                            line22.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                            line22.setAmtSourceCr(Env.ZERO);
                            line22.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                        }
                        line22.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                        line22.save();
                        continue;
                    }
                    if (!this.DepDoc.getDepType().equalsIgnoreCase("DCM")) continue;
                    line12 = new MJournalLine(journal);
                    line12.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line12.setAmtSourceDr(rs.getBigDecimal("amount"));
                    line12.setAmtSourceCr(Env.ZERO);
                    line12.setAmtAcct(rs.getBigDecimal("amount"), Env.ZERO);
                    line12.setC_ValidCombination_ID(rs.getInt("a_depreciation_acct"));
                    line12.save();
                    line22 = new MJournalLine(journal);
                    line22.setA_Asset_ID(rs.getInt("a_asset_id"));
                    line22.setAmtSourceDr(Env.ZERO);
                    line22.setAmtSourceCr(rs.getBigDecimal("amount"));
                    line22.setAmtAcct(Env.ZERO, rs.getBigDecimal("amount"));
                    line22.setC_ValidCombination_ID(rs.getInt("A_AssetComplement_Acct"));
                    line22.save();
                    batch.setDescription("Depreciacion y Correcion Monetaria");
                    line3 = new MJournalLine(journal);
                    line3.setA_Asset_ID(rs.getInt("a_asset_id"));
                    if (this.DepDoc.getRate().signum() > 0) {
                        line3.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        line3.setAmtSourceCr(Env.ZERO);
                        line3.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)), Env.ZERO);
                    } else if (this.DepDoc.getRate().signum() < 0) {
                        line3.setAmtSourceDr(Env.ZERO);
                        line3.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        line3.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                    }
                    line3.setC_ValidCombination_ID(rs.getInt("a_accumdepreciation_acct"));
                    line3.save();
                    line4 = new MJournalLine(journal);
                    line4.setA_Asset_ID(rs.getInt("a_asset_id"));
                    if (this.DepDoc.getRate().signum() > 0) {
                        line4.setAmtSourceDr(Env.ZERO);
                        line4.setAmtSourceCr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                        line4.setAmtAcct(Env.ZERO, rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().divide(Env.ONEHUNDRED)));
                    }
                    if (this.DepDoc.getRate().signum() < 0) {
                        line4.setAmtSourceDr(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)));
                        line4.setAmtSourceCr(Env.ZERO);
                        line4.setAmtAcct(rs.getBigDecimal("a_accumulated_depr").multiply(this.DepDoc.getRate().abs().divide(Env.ONEHUNDRED)), Env.ZERO);
                    }
                    line4.setC_ValidCombination_ID(rs.getInt("a_asset_acct"));
                    line4.save();
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            if (count > 0) {
                this.DepDoc.setGL_JournalBatch_ID(batch.getGL_JournalBatch_ID());
                this.DepDoc.setDocStatus("IP");
                this.DepDoc.save();
                DB.executeUpdate("Update GL_JournalLine set A_Asset_Dep_ID=" + this.DepDoc.getA_Asset_Dep_ID() + " Where GL_Journal_ID IN (select GL_Journal_ID from GL_Journal where GL_JournalBatch_ID=" + batch.getGL_JournalBatch_ID() + " )", this.get_TrxName());
            } else if (batch != null) {
                batch.delete(true, this.get_TrxName());
            }
        } else if (this.DepDoc.getDocStatus().equals("IP") && !this.DepDoc.isVoid()) {
            this.log.info("IP");
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            ((MJournalBatch)batch).processIt("CO");
            batch.save();
            batch.setProcessed(true);
            batch.save();
            MJournal[] journals = ((MJournalBatch)batch).getJournals(true);
            int i = 0;
            while (i < journals.length) {
                BigDecimal acum;
                MAssetAcct group;
                X_A_Asset_Forecast fore;
                MDepreciationWorkfile workfile;
                MJournal jour = journals[i];
                X_A_Asset asset = new X_A_Asset(this.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), null);
                if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() + 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setProcessed(true);
                    fore.setGL_Journal_ID(jour.getGL_Journal_ID());
                    fore.save();
                    asset.setLastMaintenanceNote("Depreciacion Periodo :" + (workfile.getA_Period_Posted() + 1) + " por " + jour.getTotalCr());
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]);
                    acum = acum.subtract(DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]));
                    BigDecimal neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct(), new Object[0]);
                    neto = neto.subtract(DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Asset_Acct(), new Object[0]));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(acum));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(neto));
                    workfile.save();
                    X_A_Asset_Forecast fore2 = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore2.setCorrected(true);
                    fore2.save();
                    asset.setLastMaintenanceNote("CM Periodo " + this.DepDoc.getRate() + " % Valor:" + neto);
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Calc_Accumulated_Depr(workfile.getA_Accumulated_Depr());
                    workfile.setA_Accumulated_Depr(workfile.getA_Asset_Cost());
                    workfile.save();
                    asset.setLastMaintenanceNote("Venta Activo");
                    DB.executeUpdate("Update A_Asset_Forecast set processed='Y', corrected='Y' where A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID"), this.get_TrxName());
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("CRN")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(acum));
                    workfile.save();
                    X_A_Asset_Forecast fore3 = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore3.setCorrected(true);
                    fore3.save();
                    asset.setLastMaintenanceNote("CM DPP Periodo " + this.DepDoc.getRate() + " % Valor:" + acum);
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DCM")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() + 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setProcessed(true);
                    fore.setGL_Journal_ID(jour.getGL_Journal_ID());
                    fore.save();
                    MAssetAcct group2 = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    BigDecimal acum2 = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group2.getA_Accumdepreciation_Acct(), new Object[0]);
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().add(acum2));
                    workfile.save();
                    fore.setCorrected(true);
                    fore.save();
                    asset.setLastMaintenanceNote("Depreciacion y CM DPP Periodo " + this.DepDoc.getRate() + " % Valor:" + acum2);
                }
                ++i;
            }
            this.DepDoc.setDocStatus("CO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
            i = "Y".equals(DB.getSQLValueString(this.get_TrxName(), "select assetadvise from ad_client where ad_client_id=" + this.getAD_Client_ID(), new Object[0])) ? 1 : 0;
        } else if (this.DepDoc.getDocStatus().equals("CO") && this.DepDoc.isVoid()) {
            batch = new MJournalBatch(this.m_ctx, this.DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
            MJournal[] journals = ((MJournalBatch)batch).getJournals(true);
            int i = 0;
            while (i < journals.length) {
                BigDecimal acum;
                MAssetAcct group;
                MAsset asset;
                MDepreciationWorkfile workfile;
                MJournal jour = journals[i];
                if (this.DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(jour.getTotalCr()));
                    workfile.setA_Period_Posted(workfile.getA_Period_Posted() - 1);
                    workfile.setAssetDepreciationDate(this.DepDoc.getDateDoc());
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), this.get_TrxName());
                    fore.setProcessed(false);
                    fore.setGL_Journal_ID(0);
                    fore.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("COR")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    asset = new MAsset(Env.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), this.get_TrxName());
                    group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]);
                    BigDecimal neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setCorrected(false);
                    fore.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("REV")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("DET")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                    workfile.save();
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    workfile.setA_Accumulated_Depr(workfile.getA_Calc_Accumulated_Depr());
                    workfile.save();
                    DB.executeUpdate("Update A_Asset_Forecast set processed='N', corrected='N' where gl_journal_id is null and A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID"), this.get_TrxName());
                } else if (this.DepDoc.getDepType().equalsIgnoreCase("CRN")) {
                    workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                    asset = new MAsset(Env.getCtx(), jour.get_ValueAsInt("A_Asset_ID"), this.get_TrxName());
                    group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                    acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                    workfile.save();
                    X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                    fore.setCorrected(false);
                    fore.save();
                }
                ++i;
            }
            MJournal[] mJournalArray = journals;
            int n = journals.length;
            int n2 = 0;
            while (n2 < n) {
                MJournal j = mJournalArray[n2];
                DB.executeUpdate("delete from fact_acct where record_id=" + j.getGL_Journal_ID() + " and ad_table_id=" + I_GL_Journal.Table_ID, this.get_TrxName());
                DB.executeUpdate("delete from gl_journalline where gl_journal_id=" + j.getGL_Journal_ID(), this.get_TrxName());
                ++n2;
            }
            DB.executeUpdate("delete from gl_journal where gl_journalbatch_id=" + batch.getGL_JournalBatch_ID(), this.get_TrxName());
            this.DepDoc.setDocStatus("VO");
            this.DepDoc.setProcessed(true);
            this.DepDoc.save();
        }
        this.commitEx();
        return "";
    }

    public void replanningDPP(int asset_ID, int Org_ID, int PGroup_ID, String PPosession) {
        String sql = "Select A.A_Asset_ID, C.A_Asset_Acct_ID  From A_Asset A  Inner join A_Asset_Acct C on (A.A_Asset_ID=C.A_Asset_ID) where 1=1";
        sql = asset_ID > 0 ? String.valueOf(sql) + " and A.A_Asset_ID=?" : String.valueOf(sql) + " and A.A_Asset_Group_ID=?";
        sql = String.valueOf(sql) + " and A.IsInPosession=?";
        if (Org_ID > 0) {
            sql = String.valueOf(sql) + " and A.AD_Org_ID=?";
        }
        int count = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            if (asset_ID > 0) {
                pstmt.setInt(1, asset_ID);
            } else {
                pstmt.setInt(1, PGroup_ID);
            }
            pstmt.setString(2, PPosession);
            if (Org_ID > 0) {
                pstmt.setInt(3, Org_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Asset asset = new X_A_Asset(this.getCtx(), rs.getInt(1), this.get_TrxName());
                MDepreciationWorkfile workfile = MAsset.getWorkFile(rs.getInt(1));
                MAssetAcct acct = new MAssetAcct(this.getCtx(), rs.getInt(2), this.get_TrxName());
                if (workfile == null || workfile.getA_Period_Posted() == acct.getA_Period_End()) continue;
                this.replanningForecast(asset, workfile.getA_Asset_Cost().subtract(workfile.getA_Accumulated_Depr()), acct, workfile.getA_Period_Posted(), DB.getSQLValueTS(this.get_TrxName(), "select max(datedoc) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + rs.getInt(1), new Object[0]));
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
    }

    public void replanningForecast(X_A_Asset asset, BigDecimal Amount, MAssetAcct acct, int Period, Timestamp lastdate) {
        BigDecimal SalvageAmt = acct.getA_Salvage_Value();
        BigDecimal Currentamt = Amount;
        Currentamt = Currentamt.divide(new BigDecimal(acct.getA_Period_End() - Period), 2, 1);
        DB.executeUpdate("Update A_Asset_Forecast set amount=" + Currentamt + " Where Processed='N' AND A_Asset_ID=" + asset.getA_Asset_ID(), this.get_TrxName());
        if (asset.isInPosession()) {
            DB.executeUpdate("Delete from A_Asset_Forecast where Processed='N' and Corrected='N' and A_Asset_ID=" + asset.getA_Asset_ID(), this.get_TrxName());
            Period = DB.getSQLValue(this.get_TrxName(), "select max(PeriodNo) from a_asset_forecast where corrected='Y' and A_Asset_ID=" + asset.getA_Asset_ID());
        } else {
            DB.executeUpdate("Delete from A_Asset_Forecast where Processed='N' and A_Asset_ID=" + asset.getA_Asset_ID(), this.get_TrxName());
        }
        int mes = 1;
        if (!acct.get_ValueAsBoolean("IsByYear")) {
            int i = Period + 1;
            while (i < acct.getA_Period_End() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(2, mes);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        } else {
            int i = Period + 1;
            while (i < asset.getUseLifeYears() + 1) {
                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), 0, null);
                fore.setA_Asset_ID(asset.getA_Asset_ID());
                fore.setAD_Org_ID(asset.getAD_Org_ID());
                Calendar cal = Calendar.getInstance();
                if (lastdate == null) {
                    cal.setTimeInMillis(asset.getAssetServiceDate().getTime());
                } else {
                    cal.setTimeInMillis(lastdate.getTime());
                }
                cal.add(1, mes);
                cal.set(2, 11);
                cal.set(5, 1);
                fore.setDateDoc(new Timestamp(cal.getTimeInMillis()));
                fore.setPeriodNo(i);
                BigDecimal amtAcct = Currentamt;
                if (i == acct.getA_Period_End()) {
                    amtAcct = amtAcct.subtract(SalvageAmt);
                }
                fore.setAmount(amtAcct.setScale(2, 1));
                fore.getAmount();
                fore.save();
                ++mes;
                ++i;
            }
        }
    }
}

