/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.adempiere.exceptions.DBException;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCampaign;
import org.compiere.model.MLocation;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.model.X_I_BPartnerXML;
import org.compiere.model.X_R_ContactInterest;
import org.compiere.model.X_R_InterestArea;
import org.compiere.model.X_R_InterestAreaValues;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CreateBPMetlifeSC
extends SvrProcess
implements ImportProcess {
    private int m_AD_Client_ID = 0;
    private ArrayList<Integer> ArrayIDS_Campaign = new ArrayList();
    private int ID_EtiquetaUrlGL = 0;

    @Override
    protected void prepare() {
        this.m_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
    }

    @Override
    protected String doIt() throws Exception {
        if (!this.insertBPartner().booleanValue() || !this.asignBPartner().booleanValue() || !this.asignUser().booleanValue() || this.SubAsignUser().booleanValue()) {
            // empty if block
        }
        return "OK";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean insertBPartner() throws SQLException {
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = this.getWhereClause();
        sql = new StringBuffer("UPDATE I_BPartnerXML SET AD_Client_ID = COALESCE (AD_Client_ID, ").append(this.m_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID, 0), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE (I_IsImported<>'Y' OR I_IsImported IS NULL) AND I_IsAsigned<>'Y' ");
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Reset=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 10);
        sql = new StringBuffer("UPDATE I_BPartnerXML  SET Value = I_BPartnerXML_ID WHERE Value IS NULL AND I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Set Value Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML  SET name = COALESCE(IA_Nombre,n'') ||' '||COALESCE(IA_Paterno,n'')||' '||COALESCE(IA_Materno,n'')  WHERE I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Set Name Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML i SET C_BPartner_ID=(SELECT C_BPartner_ID FROM C_BPartner p WHERE i.Value=p.Value AND p.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND Value IS NOT NULL AND I_IsImported='N' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Found BPartner=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML set C_BP_Group_ID =  (SELECT MIN(C_BP_Group_ID) FROM C_BP_Group WHERE IsDefault = 'Y' AND AD_Client_ID = 1000000) WHERE I_IsImported<>'Y' AND I_IsAsigned<>'Y' ").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.fine("Set Group Default=" + no);
        sql = new StringBuffer("UPDATE I_BPartnerXML SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Value is mandatory, ' WHERE Value IS NULL  AND I_IsImported<>'Y' AND I_IsAsigned<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.log.config("Value is mandatory=" + no);
        ModelValidationEngine.get().fireImportValidate(this, null, null, 20);
        this.commitEx();
        int noInsert = 0;
        int noUpdate = 0;
        sql = new StringBuffer("SELECT * FROM I_BPartnerXML WHERE I_IsImported='N' AND I_IsAsigned='N'").append(clientCheck);
        sql.append(" ORDER BY Value, I_BPartnerXML_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                String Old_BPValue = "";
                MBPartner bp = null;
                MBPartnerLocation bpl = null;
                while (true) {
                    X_I_BPartnerXML impBP;
                    block50: {
                        String New_BPValue;
                        block51: {
                            block54: {
                                block55: {
                                    block53: {
                                        MLocation location;
                                        block52: {
                                            block49: {
                                                if (!rs.next()) {
                                                    DB.close(rs, pstmt);
                                                    break;
                                                }
                                                New_BPValue = rs.getString("Value");
                                                impBP = new X_I_BPartnerXML(this.getCtx(), rs, this.get_TrxName());
                                                this.log.fine("I_BPartner_ID=" + impBP.getI_BPartnerXML_ID() + ", C_BPartner_ID=" + impBP.getC_BPartner_ID() + ", C_BPartner_Location_ID=" + impBP.getC_BPartner_Location_ID() + ", AD_User_ID=" + impBP.getAD_User_ID());
                                                if (New_BPValue.equals(Old_BPValue)) break block51;
                                                bp = null;
                                                if (impBP.getC_BPartner_ID() == 0) {
                                                    this.log.config("Inserta BP");
                                                    bp = new MBPartner(impBP);
                                                    ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                                    this.setTypeOfBPartner(impBP, bp);
                                                    if (bp.save()) {
                                                        impBP.setC_BPartner_ID(bp.getC_BPartner_ID());
                                                        this.log.finest("Insert BPartner - " + bp.getC_BPartner_ID());
                                                        ++noInsert;
                                                        break block49;
                                                    } else {
                                                        sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPartner, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                                        DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                                        continue;
                                                    }
                                                }
                                                this.log.config("Actualiza BP");
                                                bp = new MBPartner(this.getCtx(), impBP.getC_BPartner_ID(), this.get_TrxName());
                                                if (impBP.getName() != null) {
                                                    bp.setName(impBP.getName());
                                                    bp.setName2(impBP.getName2());
                                                }
                                                if (impBP.getDUNS() != null) {
                                                    bp.setDUNS(impBP.getDUNS());
                                                }
                                                if (impBP.getTaxID() != null) {
                                                    bp.setTaxID(impBP.getTaxID());
                                                }
                                                if (impBP.getNAICS() != null) {
                                                    bp.setNAICS(impBP.getNAICS());
                                                }
                                                if (impBP.getDescription() != null) {
                                                    bp.setDescription(impBP.getDescription());
                                                }
                                                if (impBP.getC_BP_Group_ID() != 0) {
                                                    bp.setC_BP_Group_ID(impBP.getC_BP_Group_ID());
                                                }
                                                ModelValidationEngine.get().fireImportValidate(this, impBP, bp, 40);
                                                this.setTypeOfBPartner(impBP, bp);
                                                if (bp.save()) {
                                                    this.log.finest("Update BPartner - " + bp.getC_BPartner_ID());
                                                    ++noUpdate;
                                                } else {
                                                    sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Update BPartner, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                                    DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                                    continue;
                                                }
                                            }
                                            bpl = null;
                                            if (impBP.getC_BPartner_Location_ID() == 0) break block52;
                                            this.log.config("actualiza BP loc");
                                            bpl = new MBPartnerLocation(this.getCtx(), impBP.getC_BPartner_Location_ID(), this.get_TrxName());
                                            location = new MLocation(this.getCtx(), bpl.getC_Location_ID(), this.get_TrxName());
                                            location.setC_Country_ID(impBP.getC_Country_ID());
                                            location.setC_Region_ID(impBP.getC_Region_ID());
                                            location.setCity(impBP.getCity());
                                            location.setAddress1(impBP.getAddress1());
                                            location.setAddress2(impBP.getAddress2());
                                            location.setPostal(impBP.getPostal());
                                            location.setPostal_Add(impBP.getPostal_Add());
                                            if (!location.save()) {
                                                this.log.warning("Location not updated");
                                            } else {
                                                bpl.setC_Location_ID(location.getC_Location_ID());
                                            }
                                            if (impBP.getPhone() != null) {
                                                bpl.setPhone(impBP.getPhone());
                                            }
                                            if (impBP.getPhone2() != null) {
                                                bpl.setPhone2(impBP.getPhone2());
                                            }
                                            if (impBP.getFax() != null) {
                                                bpl.setFax(impBP.getFax());
                                            }
                                            ModelValidationEngine.get().fireImportValidate(this, impBP, bpl, 40);
                                            bpl.save();
                                            break block51;
                                        }
                                        if (impBP.getC_Country_ID() == 0 || impBP.getAddress1() == null || impBP.getCity() == null) break block51;
                                        this.log.config("crea BP loc");
                                        location = new MLocation(this.getCtx(), impBP.getC_Country_ID(), impBP.getC_Region_ID(), impBP.getCity(), this.get_TrxName());
                                        location.setAddress1(impBP.getAddress1());
                                        location.setAddress2(impBP.getAddress2());
                                        location.setPostal(impBP.getPostal());
                                        location.setPostal_Add(impBP.getPostal_Add());
                                        if (!location.save()) break block53;
                                        this.log.finest("Insert Location - " + location.getC_Location_ID());
                                        bpl = new MBPartnerLocation(bp);
                                        bpl.setC_Location_ID(location.getC_Location_ID());
                                        bpl.setPhone(impBP.getPhone());
                                        bpl.setPhone2(impBP.getPhone2());
                                        bpl.setFax(impBP.getFax());
                                        ModelValidationEngine.get().fireImportValidate(this, impBP, bpl, 40);
                                        if (!bpl.save()) break block54;
                                        break block55;
                                    }
                                    this.rollback();
                                    --noInsert;
                                    sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert Location, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                                    DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                                    continue;
                                }
                                this.log.finest("Insert BP Location - " + bpl.getC_BPartner_Location_ID());
                                impBP.setC_BPartner_Location_ID(bpl.getC_BPartner_Location_ID());
                                break block51;
                            }
                            this.rollback();
                            --noInsert;
                            sql = new StringBuffer("UPDATE I_BPartnerXML i SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||").append("'Cannot Insert BPLocation, ' ").append("WHERE I_BPartnerXML_ID=").append(impBP.getI_BPartnerXML_ID());
                            DB.executeUpdateEx(sql.toString(), this.get_TrxName());
                            continue;
                        }
                        Old_BPValue = New_BPValue;
                        String[] namesAInterest = new String[]{"TelFijo", "Celular", "Direccion", "Comuna", "Ciudad", "Region", "Email", "MotivoContacto", "Origen", "Inmueble", "AreaFono", "TipoPropiedad", "ValorPropiedad", "MontoCredito", "Financ", "FechaNac", "Genero", "EstadoCivil", "RazonSocial", "RutEmpresa", "SolColab", "ProdInteres", "Corredora", "UrlOrigen", "Observacion"};
                        int i = 0;
                        while (true) {
                            if (i >= namesAInterest.length) {
                                if (impBP.get_ValueAsString("IA_TipoEtiqueta") != null && impBP.get_ValueAsString("IA_TipoEtiqueta") != " " && impBP.get_ValueAsString("IA_TipoEtiqueta") != "") break;
                                break block50;
                            }
                            X_R_InterestArea IArea = null;
                            String nameIA = namesAInterest[i];
                            String sqlIA1 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + nameIA + "'";
                            int IA_ID = DB.getSQLValue(this.get_TrxName(), sqlIA1);
                            if (IA_ID > 0) {
                                IArea = new X_R_InterestArea(this.getCtx(), IA_ID, this.get_TrxName());
                            } else {
                                IArea = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                                IArea.setName(nameIA);
                                IArea.setValue(nameIA);
                            }
                            IArea.save();
                            X_R_InterestAreaValues IAreaValue = null;
                            String sqlVIA1 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_" + nameIA).replace("'", "") + "'";
                            int IAV_ID = DB.getSQLValue(this.get_TrxName(), sqlVIA1);
                            if (IAV_ID > 0) {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), IAV_ID, this.get_TrxName());
                            } else if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                IAreaValue = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue.setR_InterestArea_ID(IArea.get_ID());
                                IAreaValue.setValue(impBP.get_ValueAsString("IA_" + nameIA));
                                String valueEtiquetaRM = impBP.get_ValueAsString("IA_" + nameIA).toLowerCase();
                                if ((IArea.getValue().toLowerCase().contains("regi\u00f1n") || IArea.getValue().toLowerCase().contains("region")) && valueEtiquetaRM.contains("metropo")) {
                                    IAreaValue.set_CustomColumn("IsValueRM", true);
                                }
                                IAreaValue.save();
                            }
                            if (impBP.get_ValueAsString("IA_" + nameIA) != null && impBP.get_ValueAsString("IA_" + nameIA) != "" && impBP.get_ValueAsString("IA_" + nameIA) != " ") {
                                X_R_ContactInterest cInterest;
                                if (IArea.get_ValueAsBoolean("IsEditable")) {
                                    cInterest = null;
                                    String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + " AND R_InterestArea_ID = " + IArea.get_ID();
                                    int CInterest_ID = DB.getSQLValue(this.get_TrxName(), sqlcInteret);
                                    if (CInterest_ID > 0) {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue.get_ID());
                                    } else {
                                        cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                        cInterest.set_CustomColumn("C_BPartner_ID", bp.get_ID());
                                        cInterest.setR_InterestArea_ID(IArea.get_ID());
                                        cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue.get_ID());
                                    }
                                    cInterest.save();
                                } else if (IArea.get_ID() > 0 && IAreaValue.get_ID() > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue.get_ID());
                                    cInterest.save();
                                }
                            }
                            ++i;
                        }
                        X_R_InterestArea IArea2 = null;
                        String sqlIA2 = "Select R_InterestArea_ID from R_InterestArea WHERE name = '" + impBP.get_ValueAsString("IA_TipoEtiqueta").replace("'", "") + "'";
                        int IA_ID2 = DB.getSQLValue(this.get_TrxName(), sqlIA2);
                        if (IA_ID2 > 0) {
                            IArea2 = new X_R_InterestArea(this.getCtx(), IA_ID2, this.get_TrxName());
                        } else {
                            IArea2 = new X_R_InterestArea(this.getCtx(), 0, this.get_TrxName());
                            IArea2.setName(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                            IArea2.setValue(impBP.get_ValueAsString("IA_TipoEtiqueta"));
                        }
                        IArea2.save();
                        if (impBP.get_ValueAsString("IA_ValorEtiqueta") == null || impBP.get_ValueAsString("IA_ValorEtiqueta") == "" || impBP.get_ValueAsString("IA_ValorEtiqueta") == " ") {
                            String sqlcInteret2 = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                            int CInterest_ID2 = DB.getSQLValue(this.get_TrxName(), sqlcInteret2);
                            if (CInterest_ID2 <= 0) {
                                X_R_ContactInterest cInterest2 = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest2.set_CustomColumn("C_BPartner_ID", bp.get_ID());
                                cInterest2.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest2.save();
                            }
                        } else {
                            X_R_ContactInterest cInterest;
                            X_R_InterestAreaValues IAreaValue2 = null;
                            String sqlVIA2 = "SELECT R_InterestAreaValues_ID FROM R_InterestAreaValues WHERE R_InterestArea_ID = " + IArea2.get_ID() + " AND value = '" + impBP.get_ValueAsString("IA_ValorEtiqueta") + "'";
                            int IAV_ID2 = DB.getSQLValue(this.get_TrxName(), sqlVIA2);
                            if (IAV_ID2 > 0) {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), IAV_ID2, this.get_TrxName());
                            } else {
                                IAreaValue2 = new X_R_InterestAreaValues(this.getCtx(), 0, this.get_TrxName());
                                IAreaValue2.setR_InterestArea_ID(IArea2.get_ID());
                                IAreaValue2.setValue(impBP.get_ValueAsString("IA_ValorEtiqueta"));
                            }
                            IAreaValue2.save();
                            if (IArea2.get_ValueAsBoolean("IsEditable")) {
                                cInterest = null;
                                String sqlcInteret = "SELECT MAX(R_ContactInterest_ID) FROM R_ContactInterest WHERE C_BPartner_ID = " + bp.get_ID() + "AND R_InterestArea_ID = " + IArea2.get_ID();
                                int CInterest_ID = DB.getSQLValue(this.get_TrxName(), sqlcInteret);
                                if (CInterest_ID > 0) {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), CInterest_ID, this.get_TrxName());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue2.get_ID());
                                } else {
                                    cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                    cInterest.set_CustomColumn("C_BPartner_ID", bp.get_ID());
                                    cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                    cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue2.get_ID());
                                }
                                cInterest.save();
                            } else if (IArea2.get_ID() > 0 && IAreaValue2.get_ID() > 0) {
                                cInterest = new X_R_ContactInterest(this.getCtx(), 0, this.get_TrxName());
                                cInterest.set_CustomColumn("C_BPartner_ID", bp.get_ID());
                                cInterest.setR_InterestArea_ID(IArea2.get_ID());
                                cInterest.set_CustomColumn("R_InterestAreaValues_ID", IAreaValue2.get_ID());
                                cInterest.save();
                            }
                        }
                    }
                    impBP.setI_IsImported(true);
                    impBP.setProcessed(true);
                    impBP.setProcessing(false);
                    impBP.saveEx();
                    this.commitEx();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
            this.addLog(0, null, new BigDecimal(no), "@Errors@");
            this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
            this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        sql = new StringBuffer("UPDATE I_BPartner SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdateEx(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@C_BPartner_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noUpdate), "@C_BPartner_ID@: @Updated@");
        this.commitEx();
        return true;
    }

    @Override
    public String getWhereClause() {
        return " AND AD_Client_ID=" + this.m_AD_Client_ID;
    }

    @Override
    public String getImportTableName() {
        return "I_BPartnerXML";
    }

    private void setTypeOfBPartner(X_I_BPartnerXML impBP, MBPartner bp) {
        if (impBP.isVendor()) {
            bp.setIsVendor(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isEmployee()) {
            bp.setIsEmployee(true);
            bp.setIsCustomer(false);
        }
        if (impBP.isCustomer()) {
            bp.setIsCustomer(true);
        }
    }

    public Boolean asignBPartner() throws SQLException {
        this.log.config("asignBPartner");
        String clientCheck = this.getWhereClause();
        StringBuffer sql = null;
        sql = new StringBuffer("SELECT C_Bpartner_ID, I_BPartnerXML_ID FROM I_BPartnerXML WHERE I_IsImported='Y' AND I_IsAsigned='N' AND C_Bpartner_ID IS NOT NULL ").append(clientCheck);
        sql.append("ORDER BY C_Bpartner_ID");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MBPartner bp = new MBPartner(this.getCtx(), rs.getInt("C_Bpartner_ID"), this.get_TrxName());
                    this.log.config("entra while general BP - BP_ID:" + bp.get_ID());
                    X_I_BPartnerXML ixml = new X_I_BPartnerXML(this.getCtx(), rs.getInt("I_BPartnerXML_ID"), this.get_TrxName());
                    CPreparedStatement pstmtEtiqueta = null;
                    ResultSet rsEtiqueta = null;
                    String sqlEtiqueta = "SELECT R_InterestArea_ID FROM r_contactinterest WHERE C_BPartner_ID =?";
                    pstmtEtiqueta = DB.prepareStatement(sqlEtiqueta, this.get_TrxName());
                    pstmtEtiqueta.setInt(1, bp.get_ID());
                    rsEtiqueta = pstmtEtiqueta.executeQuery();
                    int existeCampa\u00f1a = 0;
                    while (rsEtiqueta.next()) {
                        int ID_EtiquetaURL = rsEtiqueta.getInt("R_InterestArea_ID");
                        if (ID_EtiquetaURL > 0) {
                            this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
                        }
                        this.log.config("entra while InterestArea BP - BP_ID:" + bp.get_ID() + " InterestArea_ID:" + ID_EtiquetaURL);
                        String sqlvalueIABP = "SELECT VALUE FROM R_ContactInterest CI INNER JOIN R_InterestAreaValues AV ON (CI.R_InterestAreaValues_ID = AV.R_InterestAreaValues_ID)WHERE CI.C_BPartner_ID = " + bp.get_ID() + " AND CI.R_InterestArea_ID = " + ID_EtiquetaURL;
                        String valueIABP = DB.getSQLValueString(this.get_TrxName(), sqlvalueIABP, new Object[0]);
                        String sqlCadenasUrl = "SELECT iav.value, cc.C_Campaign_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) INNER JOIN R_InterestAreaValues iav ON(iav.R_InterestAreaValues_ID = ci.R_InterestAreaValues_ID)WHERE IsOnGoing = 'Y' AND iav.R_InterestArea_ID=?";
                        CPreparedStatement pstmtCadenas = null;
                        ResultSet rsCadenas = null;
                        pstmtCadenas = DB.prepareStatement(sqlCadenasUrl, this.get_TrxName());
                        pstmtCadenas.setInt(1, ID_EtiquetaURL);
                        rsCadenas = pstmtCadenas.executeQuery();
                        boolean asignado = false;
                        while (rsCadenas.next()) {
                            this.log.config("entra while campa\u00f1as");
                            String valueUrl = rsCadenas.getString("value");
                            this.log.config("valor valueIABP :" + valueIABP);
                            this.log.config("valor valueUrl :" + valueUrl);
                            if (valueIABP == null || valueUrl == null) continue;
                            this.log.config("Pregunta if (valueIABP.contains(valueUrl)):" + (valueIABP.contains(valueUrl) ? "true" : "false"));
                            if (!valueIABP.contains(valueUrl)) continue;
                            existeCampa\u00f1a = 1;
                            MCampaign cam = new MCampaign(this.getCtx(), rsCadenas.getInt("C_Campaign_ID"), this.get_TrxName());
                            if (!this.ArrayIDS_Campaign.contains(cam.get_ID())) {
                                this.ArrayIDS_Campaign.add(cam.get_ID());
                            }
                            int ID_Campaign = cam.get_ID();
                            String countBPStr = "SELECT COUNT(1) FROM C_CampaignFollow WHERE C_BPartner_ID = " + bp.get_ID() + " AND C_Campaign_ID = " + ID_Campaign;
                            int countBP = DB.getSQLValue(this.get_TrxName(), countBPStr);
                            this.log.config("countBP :" + countBP);
                            if (countBP > 0) {
                                ixml.set_CustomColumn("I_IsAsigned", true);
                                ixml.save();
                                continue;
                            }
                            X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                            cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                            cFollow.setC_Campaign_ID(cam.get_ID());
                            cFollow.setIsActive(true);
                            cFollow.setC_BPartner_ID(bp.get_ID());
                            cFollow.setStatus("NC");
                            cFollow.setFinalStatus("IN");
                            cFollow.save();
                            this.log.config("crea cFollow");
                            ixml.set_CustomColumn("I_IsAsigned", true);
                            ixml.save();
                            this.commitEx();
                            asignado = true;
                        }
                        DB.close(rsCadenas, pstmtCadenas);
                        rsCadenas = null;
                        pstmtCadenas = null;
                    }
                    DB.close(rsEtiqueta, pstmtEtiqueta);
                    rsEtiqueta = null;
                    pstmtEtiqueta = null;
                    this.log.config("existeCampa\u00f1a:" + existeCampa\u00f1a);
                    if (existeCampa\u00f1a >= 1) continue;
                    int ID_CampaignDefault = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Campaign_ID) FROM C_Campaign WHERE IsCampaignDefault='Y'");
                    this.log.config("ID_CampaignDefault:" + ID_CampaignDefault);
                    if (ID_CampaignDefault <= 0) continue;
                    MCampaign cam = new MCampaign(this.getCtx(), ID_CampaignDefault, this.get_TrxName());
                    int ID_Campaign = cam.get_ID();
                    String countBPStr = "SELECT COUNT(1) FROM C_CampaignFollow WHERE C_BPartner_ID = " + bp.get_ID() + " AND C_Campaign_ID = " + ID_Campaign;
                    int countBP = DB.getSQLValue(this.get_TrxName(), countBPStr);
                    this.log.config("countBP :" + countBP);
                    if (countBP > 0) {
                        ixml.set_CustomColumn("I_IsAsigned", true);
                        ixml.save();
                        continue;
                    }
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), 0, this.get_TrxName());
                    cFollow.setAD_Org_ID(cam.getAD_Org_ID());
                    cFollow.setC_Campaign_ID(cam.get_ID());
                    cFollow.setIsActive(true);
                    cFollow.setC_BPartner_ID(bp.get_ID());
                    cFollow.setStatus("NC");
                    cFollow.setFinalStatus("IN");
                    cFollow.save();
                    this.log.config("crea cFollow default");
                    ixml.set_CustomColumn("I_IsAsigned", true);
                    ixml.save();
                    String IDEBUserStr = "SELECT MAX(AD_User_ID) FROM AD_User WHERE IsDefaultEB = 'Y'";
                    int ID_EBUser = DB.getSQLValue(this.get_TrxName(), IDEBUserStr);
                    if (ID_EBUser <= 0) continue;
                    cFollow.setAD_User_ID(ID_EBUser);
                    cFollow.save();
                }
            }
            catch (SQLException e) {
                this.rollback();
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.commitEx();
        return true;
    }

    public Boolean asignUser() throws SQLException {
        this.log.config("arreglo: " + this.ArrayIDS_Campaign);
        if (this.ArrayIDS_Campaign.size() > 0) {
            int i = 0;
            while (i < this.ArrayIDS_Campaign.size()) {
                ++i;
            }
            X_C_Campaign cam = new X_C_Campaign(this.getCtx(), this.ArrayIDS_Campaign.get(i - 1), this.get_TrxName());
            String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
            ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
            ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
            CPreparedStatement pstmtEje = null;
            ResultSet rsEje = null;
            try {
                try {
                    pstmtEje = DB.prepareStatement(sqlEje.toString(), this.get_TrxName());
                    pstmtEje.setInt(1, cam.get_ID());
                    rsEje = pstmtEje.executeQuery();
                    while (rsEje.next()) {
                        ArrayIDUsuario.add(rsEje.getInt(1));
                        ArrayCantLeads.add(rsEje.getInt(2));
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sqlEje.toString());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsEje, pstmtEje);
                rsEje = null;
                pstmtEje = null;
                throw throwable;
            }
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
            int contador = 0;
            int InterestArea1_ID = 0;
            int InterestArea2_ID = 0;
            int InterestArea3_ID = 0;
            String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
            this.log.config("Etiqueta: " + this.ID_EtiquetaUrlGL);
            int ID_EtiquetaURL = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'UrlOrigen'");
            if (ID_EtiquetaURL > 0) {
                this.ID_EtiquetaUrlGL = ID_EtiquetaURL;
            }
            CPreparedStatement pstmtEt = null;
            pstmtEt = DB.prepareStatement(sqlEtiquetas, this.get_TrxName());
            pstmtEt.setInt(1, cam.get_ID());
            pstmtEt.setInt(2, this.ID_EtiquetaUrlGL);
            this.log.config("sqlEtiquetas: " + sqlEtiquetas);
            ResultSet rsEt = pstmtEt.executeQuery();
            while (rsEt.next()) {
                this.log.config("contador: " + contador);
                if (++contador == 1) {
                    InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                    this.log.config("interestarea1 : " + InterestArea1_ID);
                    continue;
                }
                if (contador == 2) {
                    InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                    this.log.config("interestarea2 : " + InterestArea2_ID);
                    continue;
                }
                if (contador != 3) continue;
                InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea3: " + InterestArea3_ID);
            }
            String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
            CPreparedStatement pstmtCLines = null;
            ResultSet rsCLines = null;
            this.log.config("sqlCLines: " + sqlCLines);
            try {
                try {
                    pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                    pstmtCLines.setInt(1, cam.get_ID());
                    rsCLines = pstmtCLines.executeQuery();
                    while (rsCLines.next()) {
                        int indexCant;
                        X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                        this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                        String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                        int contadorBP = 0;
                        int InterestAreaBP1_ID = 0;
                        int InterestAreaValueBP1_ID = 0;
                        int InterestAreaBP2_ID = 0;
                        int InterestAreaValueBP2_ID = 0;
                        int InterestAreaBP3_ID = 0;
                        int InterestAreaValueBP3_ID = 0;
                        CPreparedStatement pstmtEtBP = null;
                        pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                        pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                        ResultSet rsEtBP = pstmtEtBP.executeQuery();
                        this.log.config("sqlEtBP: " + sqlEtBP);
                        while (rsEtBP.next()) {
                            if (++contadorBP == 1) {
                                InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                                InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                                this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                                continue;
                            }
                            if (contadorBP == 2) {
                                InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                                InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                                this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                                continue;
                            }
                            if (contadorBP != 3) continue;
                            InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                        }
                        String id_IaBPsql = "0";
                        if (InterestAreaBP1_ID > 0) {
                            id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                        }
                        if (InterestAreaBP2_ID > 0) {
                            id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                        }
                        if (InterestAreaBP3_ID > 0) {
                            id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                        }
                        String id_IaVBPsql = "0";
                        this.log.config("id_IaBPsql: " + id_IaBPsql);
                        if (InterestAreaValueBP1_ID > 0) {
                            id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                        }
                        if (InterestAreaValueBP2_ID > 0) {
                            id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                        }
                        if (InterestAreaValueBP3_ID > 0) {
                            id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                        }
                        this.log.config("id_iavbpsql: " + id_IaVBPsql);
                        String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + "AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID) " + " WHERE ui.IsActive = 'Y'  AND adu.ActivePool = 'Y' AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                        sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                        sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                        sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                        this.log.config("sqlEtUser: " + sqlEtUser);
                        CPreparedStatement pstmtEtUser = null;
                        pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                        ResultSet rsEtUser = pstmtEtUser.executeQuery();
                        int minCantidad = 100000;
                        int CantLeadEje = 0;
                        int ID_EjecutivoM = 0;
                        while (rsEtUser.next()) {
                            if (ArrayIDUsuario != null) {
                                if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                    indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                    CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                                } else {
                                    CantLeadEje = 0;
                                }
                            }
                            if (CantLeadEje >= minCantidad) continue;
                            minCantidad = CantLeadEje;
                            ID_EjecutivoM = rsEtUser.getInt(1);
                        }
                        if (ID_EjecutivoM <= 0) continue;
                        cFollow.set_CustomColumn("Supervisor_ID", ID_EjecutivoM);
                        cFollow.setFinalStatus("AS");
                        cFollow.save();
                        if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                            indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                            int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                            ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                            continue;
                        }
                        ArrayIDUsuario.add(ID_EjecutivoM);
                        ArrayCantLeads.add(1);
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sqlCLines.toString());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsCLines, pstmtCLines);
                rsCLines = null;
                pstmtCLines = null;
                throw throwable;
            }
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
        }
        return true;
    }

    public Boolean SubAsignUser() throws SQLException {
        this.log.config("arreglo: " + this.ArrayIDS_Campaign);
        if (this.ArrayIDS_Campaign.size() > 0) {
            int i = 0;
            while (i < this.ArrayIDS_Campaign.size()) {
                ++i;
            }
            X_C_Campaign cam = new X_C_Campaign(this.getCtx(), this.ArrayIDS_Campaign.get(i - 1), this.get_TrxName());
            String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND Supervisor_ID > 0 AND (AD_User_ID = 0 OR AD_User_ID is null) Order By C_CampaignFollow_ID";
            CPreparedStatement pstmtCLines = null;
            ResultSet rsCLines = null;
            this.log.config("sqlCLines: " + sqlCLines);
            try {
                try {
                    pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                    pstmtCLines.setInt(1, cam.get_ID());
                    rsCLines = pstmtCLines.executeQuery();
                    while (rsCLines.next()) {
                        int cantIndUser2;
                        X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                        int cantIndUser1 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'");
                        if (cantIndUser1 < 1) {
                            DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'N' WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID"), this.get_TrxName());
                            this.commitEx();
                        }
                        if ((cantIndUser2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'")) < 1) {
                            DB.executeUpdate("UPDATE AD_User SET qtyLead = qtyLeadBase WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID"), this.get_TrxName());
                            this.commitEx();
                        }
                        String sqlPUser = "SELECT AD_User_ID FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtyLead > 0 AND IsActive = 'Y' ORDER BY qtyLead Desc";
                        CPreparedStatement pstmtSubUser = null;
                        ResultSet rsSubUser = null;
                        pstmtSubUser = DB.prepareStatement(sqlPUser, this.get_TrxName());
                        rsSubUser = pstmtSubUser.executeQuery();
                        rsSubUser.next();
                        if (rsSubUser.getInt("AD_User_ID") > 0) {
                            cFollow.set_CustomColumn("AD_User_ID", rsSubUser.getInt("AD_User_ID"));
                            cFollow.save();
                            DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsSubUser.getString("AD_User_ID"), this.get_TrxName());
                        }
                        this.commitEx();
                        rsSubUser.close();
                        pstmtSubUser.close();
                    }
                }
                catch (SQLException e) {
                    throw new DBException(e, sqlCLines.toString());
                }
            }
            catch (Throwable throwable) {
                DB.close(rsCLines, pstmtCLines);
                rsCLines = null;
                pstmtCLines = null;
                throw throwable;
            }
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
        }
        this.commitEx();
        return true;
    }
}

