/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Period_Resume;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ModelPeriod
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelPeriod.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Period", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MPeriod.Table_ID && po.is_ValueChanged("PeriodStatus") && po.get_ValueAsString("PeriodStatus").equals("C")) {
            MPeriod period = (MPeriod)po;
            String where = this.getPeriodsWhere(period);
            where = String.valueOf(where) + period.getC_Period_ID();
            String sql = "select AD_Org_ID,account_id,sum(amtacctdr) ,sum(amtacctcr) from fact_acct where c_period_id IN (" + where + ") and ad_client_id=?" + " group by AD_Org_ID,account_id";
            DB.executeUpdate("Delete from C_Period_Resume where C_Period_ID=" + period.getC_Period_ID(), po.get_TrxName());
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, po.get_TrxName());
                pstmt.setInt(1, period.getAD_Client_ID());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_C_Period_Resume rr = new X_C_Period_Resume(po.getCtx(), 0, po.get_TrxName());
                    rr.setC_Period_ID(period.getC_Period_ID());
                    rr.setAccount_ID(rs.getInt(2));
                    rr.setAD_Org_ID(rs.getInt(1));
                    rr.setAmtAcctCr(rs.getBigDecimal(4));
                    rr.setAmtAcctDr(rs.getBigDecimal(3));
                    rr.save();
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    private String getPeriodsWhere(MPeriod period) {
        String where = "0,";
        CPreparedStatement pstmt = null;
        String sql = "Select * from C_Period where C_Year_ID=? and PeriodNo<?";
        try {
            pstmt = DB.prepareStatement(sql, period.get_TrxName());
            pstmt.setInt(1, period.getC_Year_ID());
            pstmt.setInt(2, period.getPeriodNo());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                where = String.valueOf(where) + rs.getInt("C_Period_ID");
                where = String.valueOf(where) + ",";
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        return where;
    }
}

