/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MProductPricing;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_C_Invoice;
import org.compiere.model.X_C_InvoiceLine;
import org.compiere.model.X_C_OrderPaySchedule;
import org.compiere.model.X_EO_Agreement;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelPDVColegio
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelPDVColegio.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addModelChange("C_Order", this);
        engine.addModelChange("C_OrderLine", this);
        engine.addModelChange("C_Invoice", this);
        engine.addModelChange("C_InvoiceLine", this);
        engine.addModelChange("C_InvoicePaySchedule", this);
        engine.addDocValidate("C_Invoice", this);
        engine.addDocValidate("C_Payment", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoicePaySchedule is;
        PO inv;
        MOrder order;
        MOrder order2;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MOrder.Table_ID && po.is_ValueChanged("C_PaymentTerm_ID")) {
            order2 = (MOrder)po;
            DB.executeUpdate("delete from C_OrderPaySchedule where C_Order_ID=" + order2.getC_Order_ID(), po.get_TrxName());
        }
        if (type == 5 && po.get_Table_ID() == MOrder.Table_ID && po.is_ValueChanged("C_PaymentTerm2_ID")) {
            MPaymentTerm term = new MPaymentTerm(po.getCtx(), po.get_ValueAsInt("C_PaymentTerm2_ID"), po.get_TrxName());
            order = (MOrder)po;
            DB.executeUpdate("delete from C_OrderPaySchedule where C_Order_ID=" + order.getC_Order_ID(), po.get_TrxName());
            MOrderLine[] mOrderLineArray = order.getLines();
            int n = mOrderLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MOrderLine line = mOrderLineArray[n2];
                if (line.getM_Product_ID() > 0 && line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("COLEGIATURA") >= 0) {
                    line.setPrice(line.getPriceList().subtract(line.getPriceList().multiply(term.getDiscount().divide(Env.ONEHUNDRED, 4))));
                    line.setDiscount(term.getDiscount());
                    line.setLineNetAmt();
                    line.save();
                }
                ++n2;
            }
        }
        if ((type == 2 || type == 1) && po.get_Table_ID() == MOrderLine.Table_ID) {
            MOrderLine line = (MOrderLine)po;
            order = line.getParent();
            if (!order.isSOTrx()) {
                return null;
            }
            MPaymentTerm termco = new MPaymentTerm(po.getCtx(), order.get_ValueAsInt("C_PaymentTerm2_ID"), po.get_TrxName());
            MPaymentTerm termma = new MPaymentTerm(po.getCtx(), order.get_ValueAsInt("C_PaymentTerm_ID"), po.get_TrxName());
            if (line.getM_Product_ID() > 0) {
                if (line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("COLEGIATURA") >= 0) {
                    if (line.get_ValueAsInt("EO_Agreement_ID") > 0) {
                        X_EO_Agreement agree = new X_EO_Agreement(line.getCtx(), line.get_ValueAsInt("EO_Agreement_ID"), line.get_TrxName());
                        BigDecimal tmp = Env.ONEHUNDRED.subtract(Env.ONEHUNDRED.multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4)));
                        tmp = tmp.subtract(tmp.multiply(agree.getDiscount().divide(Env.ONEHUNDRED, 4)));
                        BigDecimal totalDiscount = Env.ONEHUNDRED.subtract(tmp);
                        line.setPrice(line.getPriceList().subtract(line.getPriceList().multiply(totalDiscount.divide(Env.ONEHUNDRED, 4))));
                        line.setDiscount(totalDiscount);
                        line.setLineNetAmt();
                    } else {
                        line.setPrice(line.getPriceList().subtract(line.getPriceList().multiply(termco.getDiscount().divide(Env.ONEHUNDRED, 4))));
                        line.setDiscount(termco.getDiscount());
                        line.setLineNetAmt();
                    }
                }
                if ((line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATR\u00cdCULA") >= 0 || line.getM_Product().getM_Product_Category().getName().toUpperCase().indexOf("MATRICULA") >= 0) && line.getPriceList().signum() == 0 && order.getM_PriceList().getC_Currency().getISO_Code().equals("CLP")) {
                    MProductPricing pp = new MProductPricing(line.getM_Product_ID(), order.getC_BPartner_ID(), line.getQtyEntered(), order.isSOTrx());
                    pp.setM_PriceList_ID(order.getM_PriceList_ID());
                    int M_PriceList_Version_ID = 0;
                    String sql = "SELECT plv.M_PriceList_Version_ID FROM M_PriceList_Version plv WHERE plv.M_PriceList_ID=?  AND plv.ValidFrom <= ? ORDER BY plv.ValidFrom DESC";
                    M_PriceList_Version_ID = DB.getSQLValueEx(null, sql, order.getM_PriceList_ID(), order.getDateOrdered());
                    pp.setM_PriceList_Version_ID(M_PriceList_Version_ID);
                    pp.setPriceDate(order.getDateOrdered());
                    BigDecimal amt = MConversionRate.convertBase(line.getCtx(), pp.getPriceLimit(), 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                    if (amt == null) {
                        return "No existe tasa de cambio para UF, no se puede completar la operacion";
                    }
                    line.setPriceList(amt);
                    line.setPrice(amt);
                    line.setLineNetAmt();
                }
            }
        }
        if (type == 1 && po.get_Table_ID() == MInvoice.Table_ID && ((X_C_Invoice)(inv = (MInvoice)po)).getC_Order_ID() > 0 && ((X_C_Invoice)inv).isSOTrx() && ((X_C_Invoice)inv).getC_DocTypeTarget().getDocBaseType().equals("ARI")) {
            order = new MOrder(po.getCtx(), ((X_C_Invoice)inv).getC_Order_ID(), po.get_TrxName());
            inv.set_CustomColumn("C_PaymentTerm2_ID", order.get_Value("C_PaymentTerm2_ID"));
            inv.set_CustomColumn("PaymentRule2", order.get_Value("PaymentRule2"));
        }
        if (type == 1 && po.get_Table_ID() == MInvoiceLine.Table_ID && ((X_C_InvoiceLine)(inv = (MInvoiceLine)po)).getC_OrderLine_ID() > 0) {
            MOrderLine ol = new MOrderLine(po.getCtx(), ((X_C_InvoiceLine)inv).getC_OrderLine_ID(), po.get_TrxName());
            inv.set_CustomColumn("AD_User_ID", ol.get_Value("AD_User_ID"));
            inv.set_CustomColumn("EO_Agreement_ID", ol.get_Value("EO_Agreement_ID"));
        }
        if (type == 2 && po.get_Table_ID() == MInvoicePaySchedule.Table_ID && (is = (MInvoicePaySchedule)po).get_Value("AllocatedAmt") != null && ((BigDecimal)is.get_Value("AllocatedAmt")).compareTo(is.getDueAmt()) >= 0) {
            is.set_CustomColumn("IsPaid", true);
        }
        if (type == 1 && po.get_Table_ID() == MInvoicePaySchedule.Table_ID) {
            MInvoice in;
            is = (MInvoicePaySchedule)po;
            is.set_CustomColumn("Name", String.valueOf(is.getDueDate().toString()) + "-" + is.getDueAmt());
            if (is.get_Value("ForeignPrice") == null && (in = MInvoice.get(is.getCtx(), is.getC_Invoice_ID())).get_Value("ForeignPrice") != null && ((BigDecimal)in.get_Value("ForeignPrice")).signum() > 0) {
                is.set_CustomColumn("ForeignPrice", ((BigDecimal)in.get_Value("ForeignPrice")).multiply(is.getC_PaySchedule().getPercentage().divide(Env.ONEHUNDRED, 4)));
            }
        }
        if ((type == 5 || type == 4) && po.get_Table_ID() == MOrder.Table_ID) {
            order2 = (MOrder)po;
            if (!order2.isSOTrx()) {
                return null;
            }
            if ((order2.getDocStatus().equalsIgnoreCase("DR") || order2.getDocStatus().equalsIgnoreCase("IP")) && order2.isSOTrx()) {
                if (order2.get_ValueAsString("PaymentRule2").equalsIgnoreCase("P")) {
                    this.agregaCargoPagare(order2);
                } else {
                    String sql3 = "SELECT max(C_Charge_ID) FROM C_Charge WHERE upper(TipoCargo)='TC13'  and isactive='Y' and AD_client_ID=" + order2.getAD_Client_ID();
                    int C_ChargeChange_ID = DB.getSQLValue("C_Charge", sql3);
                    if (C_ChargeChange_ID > 0) {
                        DB.executeUpdate("delete from C_OrderLine where C_Order_ID=" + order2.getC_Order_ID() + " and C_Charge_ID = " + C_ChargeChange_ID, po.get_TrxName());
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MPayment pay;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID) {
            MInvoicePaySchedule ip;
            X_C_OrderPaySchedule os;
            ResultSet rs;
            CPreparedStatement pstmt;
            MInvoice inv = (MInvoice)po;
            if (inv.getC_Order_ID() > 0 && inv.isSOTrx() && inv.getC_DocType().getDocBaseType().equals("ARI")) {
                DB.executeUpdate("Delete from C_InvoicePaySchedule where C_Invoice_ID=" + inv.getC_Invoice_ID(), po.get_TrxName());
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement("select C_OrderPaySchedule_ID from C_OrderPaySchedule where C_Order_ID=" + inv.getC_Order_ID(), po.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        os = new X_C_OrderPaySchedule(inv.getCtx(), rs.getInt("C_OrderPaySchedule_ID"), inv.get_TrxName());
                        ip = new MInvoicePaySchedule(inv.getCtx(), 0, inv.get_TrxName());
                        ip.setC_Invoice_ID(inv.getC_Invoice_ID());
                        ip.setC_PaySchedule_ID(os.get_ValueAsInt("C_PaySchedule_ID"));
                        ip.setDueAmt(os.getDueAmt());
                        ip.set_CustomColumn("ForeignPrice", os.get_Value("ForeignPrice"));
                        ip.setDiscountAmt(Env.ZERO);
                        ip.setDueDate(os.getDueDate());
                        ip.setDiscountDate(os.getDueDate());
                        ip.save();
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "getInvoicePaySchedule", e);
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    pstmt = null;
                }
                catch (Exception e) {
                    pstmt = null;
                }
            }
            if (inv.isSOTrx() && inv.getC_DocType().getDocBaseType().equals("CDC")) {
                DB.executeUpdate("Delete from C_InvoicePaySchedule where C_Invoice_ID=" + inv.getC_Invoice_ID(), po.get_TrxName());
                pstmt = null;
                try {
                    pstmt = DB.prepareStatement("select C_OrderPaySchedule_ID from C_OrderPaySchedule where C_Order_ID=" + inv.getC_Order_ID() + " and IsMatricula='N' ", po.get_TrxName());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        os = new X_C_OrderPaySchedule(inv.getCtx(), rs.getInt("C_OrderPaySchedule_ID"), inv.get_TrxName());
                        ip = new MInvoicePaySchedule(inv.getCtx(), 0, inv.get_TrxName());
                        ip.setC_Invoice_ID(inv.getC_Invoice_ID());
                        ip.setC_PaySchedule_ID(os.get_ValueAsInt("C_PaySchedule_ID"));
                        ip.set_CustomColumn("ForeignPrice", os.get_Value("ForeignPrice"));
                        ip.setDueAmt(os.getDueAmt());
                        ip.setDiscountAmt(Env.ZERO);
                        ip.setDueDate(os.getDueDate());
                        ip.setDiscountDate(os.getDueDate());
                        ip.save();
                    }
                    rs.close();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "getInvoicePaySchedule", e);
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    pstmt = null;
                }
                catch (Exception e) {
                    pstmt = null;
                }
            }
        }
        if (timing == 9 && po.get_Table_ID() == MPayment.Table_ID && (pay = (MPayment)po).get_ValueAsInt("C_InvoicePaySchedule_ID") > 0) {
            MInvoicePaySchedule is = new MInvoicePaySchedule(po.getCtx(), pay.get_ValueAsInt("C_InvoicePaySchedule_ID"), po.get_TrxName());
            is.set_CustomColumn("AllocatedAmt", pay.getPayAmt());
            is.save();
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }

    private void agregaCargoPagare(MOrder order) {
        String sql3 = "SELECT max(C_Charge_ID) FROM C_Charge WHERE upper(TipoCargo)='TC13'  and isactive='Y' and AD_client_ID=" + order.getAD_Client_ID();
        int C_ChargeChange_ID = DB.getSQLValue("C_Charge", sql3);
        if (C_ChargeChange_ID <= 0) {
            throw new AdempiereException("No existe Cargo para Pagares");
        }
        BigDecimal chargeAmt = MCharge.get(order.getCtx(), C_ChargeChange_ID).getChargeAmt();
        DB.executeUpdate("delete from C_OrderLine where C_Order_ID=" + order.getC_Order_ID() + " and C_Charge_ID = " + C_ChargeChange_ID, order.get_TrxName());
        int colegiaturas = 0;
        String sqlCant = "select count(distinct(C_OrderLine_ID)) FROM C_OrderLine col INNER JOIN M_Product mp on (col.M_Product_ID = mp.M_Product_ID) INNER JOIN M_Product_Category mpc on (mp.M_Product_Category_ID = mpc.M_Product_Category_ID) WHERE col.C_Order_ID = " + order.get_ID() + " AND upper(mpc.name) like '%COLEGIATURA%' ";
        colegiaturas = DB.getSQLValue(order.get_TrxName(), sqlCant);
        if (colegiaturas > 0) {
            chargeAmt = chargeAmt.multiply(new BigDecimal(colegiaturas));
            if (order.getC_Currency_ID() != 1000000) {
                BigDecimal chargeAmtCal = MConversionRate.convertBase(order.getCtx(), chargeAmt, 1000000, order.getDateOrdered(), 114, order.getAD_Client_ID(), order.getAD_Org_ID());
                if (chargeAmtCal == null) {
                    chargeAmtCal = MConversionRate.convert(order.getCtx(), chargeAmt, 1000000, order.getC_Currency_ID(), order.getAD_Client_ID(), order.getAD_Org_ID());
                }
                if (chargeAmtCal == null) {
                    throw new AdempiereException("No existe tasa de cambio al dia UF");
                }
                chargeAmt = chargeAmtCal;
            }
            MOrderLine line = new MOrderLine(order);
            line.setPriceActual(chargeAmt);
            line.setQty(Env.ONE);
            line.setQtyDelivered(Env.ZERO);
            line.setC_Charge_ID(C_ChargeChange_ID);
            line.setLineNetAmt();
            line.save();
        }
    }
}

