/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import org.compiere.model.MClient;
import org.compiere.model.MInvoice;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class ModelOFBBlumosCAP
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBBlumosCAP.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 5 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).isSOTrx()) {
            String sqlUT = "UPDATE C_InvoiceTax cit SET TaxAmt = COALESCE(round((round(TaxBaseAmt)* (select Rate From C_Tax ct  where ct.C_Tax_ID = cit.C_Tax_ID))/100),0) where C_Invoice_ID=? ";
            DB.executeUpdate(sqlUT, inv.get_ID(), po.get_TrxName());
            String sqlUpdateCab = "UPDATE C_Invoice ci SET GrandTotal = COALESCE(Totallines +  COALESCE((SELECT SUM(TaxAmt) FROM C_InvoiceTax cit WHERE cit.C_Invoice_ID=ci.C_Invoice_ID),0),0)  where C_Invoice_ID = ? ";
            DB.executeUpdate(sqlUpdateCab, inv.get_ID(), po.get_TrxName());
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

