/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import org.compiere.model.MAsset;
import org.compiere.model.MAssetChange;
import org.compiere.model.MClient;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_A_Asset_Use;
import org.compiere.util.CLogger;

public class ModDPPCreaRegistrosHistorial
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModDPPCreaRegistrosHistorial.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("A_Asset_Use", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (type == 4 && po.get_Table_ID() == X_A_Asset_Use.Table_ID) {
            X_A_Asset_Use AUse = (X_A_Asset_Use)po;
            MAsset asset = new MAsset(po.getCtx(), AUse.getA_Asset_ID());
            MAssetChange change = new MAssetChange(po.getCtx(), 0, po.get_TrxName());
            change.setA_Asset_ID(asset.get_ID());
            change.setChangeType("CUS");
            change.setTextDetails(MRefList.getListDescription(po.getCtx(), "A_Update_Type", "CUS"));
            change.setAD_User_ID(AUse.get_ValueAsInt("AD_User_ID"));
            change.save();
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

