/*
 * Decompiled with CFR 0.152.
 */
package org.ofb.model;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.X_RH_AdministrativeRequests;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutRHAdRequestsMINJU
extends CalloutEngine {
    public String EndDate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Timestamp dateStart = (Timestamp)mTab.getValue("datestartrequest");
        if (dateStart != null) {
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(dateStart);
            startCal.add(1, 2);
            dateStart.setTime(startCal.getTimeInMillis());
            if (dateStart != null) {
                mTab.setValue("dateendrequest", (Object)dateStart);
            }
        }
        return "";
    }

    public static Date calculateEndDate(Date startDate, int duration) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(5, 1);
            while (startCal.get(7) == 7 || startCal.get(7) == 1) {
                startCal.add(5, 1);
            }
            ++i;
        }
        return startCal.getTime();
    }

    public static Date calculateEndDateFeriados(Date startDate, int duration) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        int i = 1;
        while (i < duration) {
            startCal.add(5, 1);
            while (startCal.get(7) == 7 || startCal.get(7) == 1) {
                startCal.add(5, 1);
            }
            if (startCal.get(7) != 7 && startCal.get(7) != 1) {
                startCal.set(11, 0);
                startCal.set(12, 0);
                startCal.set(13, 0);
                Timestamp Hactual = new Timestamp(startCal.getTimeInMillis());
                String sqlDY = "select Coalesce((upper(substring(feriado from 1 for 1))),'N') from dateofyear where trunc(date2) = ?";
                String feriado = DB.getSQLValueString(null, sqlDY, Hactual);
                if (feriado != null && feriado.equals("Y")) {
                    --i;
                }
            }
            ++i;
        }
        return startCal.getTime();
    }

    public String EndTimeSHE(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        int IDAdmReq = (Integer)mTab.getValue("RH_AdministrativeRequests_ID");
        X_RH_AdministrativeRequests AdmRequest = new X_RH_AdministrativeRequests(Env.getCtx(), IDAdmReq, null);
        if (AdmRequest.getRequestType().equals("SHE") && mTab.getValue("StartTime") != null && mTab.getValue("EndTime") != null) {
            Timestamp startTime = (Timestamp)mTab.getValue("StartTime");
            Timestamp endTime = (Timestamp)mTab.getValue("EndTime");
            if (endTime.compareTo(startTime) < 1) {
                if (mField.getColumnName().equals("StartTime")) {
                    mTab.setValue("StartTime", null);
                } else if (mField.getColumnName().equals("EndTime")) {
                    mTab.setValue("EndTime", null);
                }
                return "Hora Fin no puede ser mayor o igual a Hora Inicio";
            }
        }
        return "";
    }

    public static int fechasDiferenciaEnDias(Date fechaInicial, Date fechaFinal) {
        DateFormat df = DateFormat.getDateInstance(2);
        String fechaInicioString = df.format(fechaInicial);
        try {
            fechaInicial = df.parse(fechaInicioString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        String fechaFinalString = df.format(fechaFinal);
        try {
            fechaFinal = df.parse(fechaFinalString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        long fechaInicialMs = fechaInicial.getTime();
        long fechaFinalMs = fechaFinal.getTime();
        long diferencia = fechaFinalMs - fechaInicialMs;
        double dias = Math.floor(diferencia / 86400000L);
        return (int)dias;
    }
}

