/*
 * Decompiled with CFR 0.152.
 */
package org.metlife.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MCampaign;
import org.compiere.model.X_C_Campaign;
import org.compiere.model.X_C_CampaignFollow;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class UpdateTimeLead
extends SvrProcess {
    private int p_C_Campaign = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Campaign_ID")) {
                    this.p_C_Campaign = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        MCampaign camp = new MCampaign(this.getCtx(), this.p_C_Campaign, this.get_TrxName());
        if (!this.updateExpiredLeadAgencia(camp.get_ID()) || !camp.getName().toUpperCase().contains("AGENCIA") || !this.asignUserAgencia(camp.get_ID()).booleanValue() || this.SubAsignUserAgencia(camp.get_ID()).booleanValue()) {
            // empty if block
        }
        return "OK";
    }

    public Boolean asignUserRVitalicias(int ID_Capaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Capaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement(sqlEje.toString(), this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close(rsEje, pstmtEje);
        rsEje = null;
        pstmtEje = null;
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement(sqlEtiquetas, this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
        }
        String sqlCLinesP1 = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow cf INNER JOIN R_ContactInterest ci ON (cf.C_Bpartner_ID = ci.C_Bpartner_ID) INNER JOIN R_InterestArea ia ON (ci.R_InterestArea_ID = ia.R_InterestArea_ID) INNER JOIN R_InterestAreaValues iav ON (ci.R_InterestAreaValues_ID = iav.R_InterestAreaValues_ID) WHERE C_Campaign_ID = ? AND (upper(ia.name) like 'REGION' OR upper(ia.name) like 'REGI\u00d3N') AND (upper(iav.value) like 'II %' OR (iav.value) like 'VII %' OR (iav.value) like 'VIII %') AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLinesP1 = null;
        ResultSet rsCLinesP1 = null;
        try {
            try {
                pstmtCLinesP1 = DB.prepareStatement(sqlCLinesP1, this.get_TrxName());
                pstmtCLinesP1.setInt(1, cam.get_ID());
                rsCLinesP1 = pstmtCLinesP1.executeQuery();
                while (rsCLinesP1.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLinesP1.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID) as AD_User_ID  FROM R_UserInterest ui  INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID)  WHERE ui.IsActive = 'Y' AND adu.UseAgencia = 'N' AND adu.qtyLead > 0 AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY adu.qtyLead desc";
                    int cantIndUser1 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE AD_User_ID IN (" + sqlEtUser + ")");
                    if (cantIndUser1 < 1) {
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'N' WHERE AD_User_ID IN (" + sqlEtUser + ")", this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE AD_User_ID IN (" + sqlEtUser + ")")) < 1) {
                        DB.executeUpdate("UPDATE AD_User SET qtyLead = qtyLeadBase WHERE AD_User_ID IN (" + sqlEtUser + ")", this.get_TrxName());
                        this.commitEx();
                    }
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    rsEtUser.next();
                    if (rsEtUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsEtUser.getInt("AD_User_ID"));
                        cFollow.save();
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsEtUser.getString("AD_User_ID"), this.get_TrxName());
                    }
                    this.commitEx();
                    rsEtUser.close();
                    pstmtEtUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLinesP1.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLinesP1, pstmtCLinesP1);
            rsCLinesP1 = null;
            pstmtCLinesP1 = null;
            throw throwable;
        }
        DB.close(rsCLinesP1, pstmtCLinesP1);
        rsCLinesP1 = null;
        pstmtCLinesP1 = null;
        String sqlCLinesP2 = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow cf INNER JOIN R_ContactInterest ci ON (cf.C_Bpartner_ID = ci.C_Bpartner_ID) INNER JOIN R_InterestArea ia ON (ci.R_InterestArea_ID = ia.R_InterestArea_ID) INNER JOIN R_InterestAreaValues iav ON (ci.R_InterestAreaValues_ID = iav.R_InterestAreaValues_ID) WHERE C_Campaign_ID = ? AND (upper(ia.name) like 'REGION' OR upper(ia.name) like 'REGI\u00d3N') AND NOT(upper(iav.value) like 'II %' OR (iav.value) like 'VII %' OR (iav.value) like 'VIII %') AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLinesP2 = null;
        ResultSet rsCLinesP2 = null;
        try {
            try {
                pstmtCLinesP2 = DB.prepareStatement(sqlCLinesP2, this.get_TrxName());
                pstmtCLinesP2.setInt(1, cam.get_ID());
                rsCLinesP2 = pstmtCLinesP2.executeQuery();
                while (rsCLinesP2.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLinesP2.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    InterestArea3_ID = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE UPPER(value) like 'COMUNA'");
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID) as AD_User_ID  FROM R_UserInterest ui  INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID)  WHERE ui.IsActive = 'Y' AND adu.UseAgencia = 'N' AND adu.qtyLead > 0 AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY adu.qtyLead desc";
                    int cantIndUser1 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE AD_User_ID IN (" + sqlEtUser + ")");
                    if (cantIndUser1 < 1) {
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'N' WHERE AD_User_ID IN (" + sqlEtUser + ")", this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE AD_User_ID IN (" + sqlEtUser + ")")) < 1) {
                        DB.executeUpdate("UPDATE AD_User SET qtyLead = qtyLeadBase WHERE AD_User_ID IN (" + sqlEtUser + ")", this.get_TrxName());
                        this.commitEx();
                    }
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    rsEtUser.next();
                    if (rsEtUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsEtUser.getInt("AD_User_ID"));
                        cFollow.save();
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsEtUser.getString("AD_User_ID"), this.get_TrxName());
                    }
                    this.commitEx();
                    rsEtUser.close();
                    pstmtEtUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLinesP1.toString());
            }
        }
        finally {
            DB.close(rsCLinesP1, pstmtCLinesP1);
            rsCLinesP1 = null;
            pstmtCLinesP1 = null;
        }
        return true;
    }

    public Boolean asignUserSColectivos(int ID_Campaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Campaign, this.get_TrxName());
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    String IDEBUserStr = "SELECT MAX(AD_User_ID) FROM AD_User WHERE IsDefaultSC = 'Y'";
                    int ID_EBUser = DB.getSQLValue(this.get_TrxName(), IDEBUserStr);
                    if (ID_EBUser <= 0) continue;
                    cFollow.setAD_User_ID(ID_EBUser);
                    cFollow.save();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close(rsCLines, pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean asignUserDMDTC(int ID_Campaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Campaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement(sqlEje.toString(), this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close(rsEje, pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? GROUP BY ci.R_InterestArea_ID ";
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement(sqlEtiquetas, this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int indexCant;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    this.log.config("id_iavbpsql: " + id_IaVBPsql);
                    int ID_IsRM = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(rci.R_InterestArea_ID) FROM R_ContactInterest rci INNER JOIN R_InterestAreaValues riaV ON (rci.R_InterestAreaValues_ID = riaV.R_InterestAreaValues_ID) WHERE rci.C_Bpartner_ID = " + cFollow.getC_BPartner_ID() + " AND riaV.ISVALUERM = 'Y' GROUP BY rci.R_InterestArea_ID ");
                    this.log.config("ID_IsRM: " + ID_IsRM);
                    if (ID_IsRM <= 0) {
                        id_IaBPsql = "0";
                        id_IaVBPsql = "0";
                        int ID_EtiquetaFiltro = DB.getSQLValue(this.get_TrxName(), "SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y'");
                        if (ID_EtiquetaFiltro > 0) {
                            id_IaBPsql = String.valueOf(id_IaBPsql) + "," + ID_EtiquetaFiltro;
                            int ID_ValEF = DB.getSQLValue(this.get_TrxName(), "SELECT R_InterestAreaValues_ID FROM R_ContactInterest  WHERE C_Bpartner_ID = " + cFollow.getC_BPartner_ID() + " AND R_InterestArea_ID IN (" + ID_EtiquetaFiltro + ")");
                            if (ID_ValEF > 0) {
                                id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + ID_ValEF;
                            }
                        }
                        InterestAreaBP2_ID = 0;
                        InterestAreaBP3_ID = 0;
                    }
                    String sqlEtUser = "SELECT DISTINCT(AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + "AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " WHERE IsActive = 'Y' AND R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.setAD_User_ID(ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                        continue;
                    }
                    ArrayIDUsuario.add(ID_EjecutivoM);
                    ArrayCantLeads.add(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close(rsCLines, pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean asignUserAgencia(int ID_Campaign) throws SQLException {
        int ID_EtiquetaUrlGL = 0;
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Campaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement(sqlEje.toString(), this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close(rsEje, pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        int ID_EtiquetaURL = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'Lead Web'");
        if (ID_EtiquetaURL > 0) {
            ID_EtiquetaUrlGL = ID_EtiquetaURL;
        }
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement(sqlEtiquetas, this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        pstmtEt.setInt(2, ID_EtiquetaUrlGL);
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int indexCant;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    this.log.config("id_iavbpsql: " + id_IaVBPsql);
                    String sqlEtUser = "SELECT DISTINCT(ui.AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + "AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " INNER JOIN AD_User adu ON (ui.AD_User_ID = adu.AD_User_ID) " + " WHERE ui.IsActive = 'Y'  AND adu.ActivePool = 'Y' AND ui.R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR ui.R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND ui.R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.set_CustomColumn("Supervisor_ID", ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                        continue;
                    }
                    ArrayIDUsuario.add(ID_EjecutivoM);
                    ArrayCantLeads.add(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close(rsCLines, pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public Boolean SubAsignUserAgencia(int ID_Campaign) throws SQLException {
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Campaign, this.get_TrxName());
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND Supervisor_ID > 0 AND (AD_User_ID = 0 OR AD_User_ID is null) Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int cantIndUser2;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    int cantIndUser1 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'");
                    if (cantIndUser1 < 1) {
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'N' WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID"), this.get_TrxName());
                        this.commitEx();
                    }
                    if ((cantIndUser2 = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(1) FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtylead > 0 AND IsActive = 'Y'")) < 1) {
                        DB.executeUpdate("UPDATE AD_User SET qtyLead = qtyLeadBase WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID"), this.get_TrxName());
                        this.commitEx();
                    }
                    String sqlPUser = "SELECT AD_User_ID FROM AD_User WHERE Supervisor_ID = " + cFollow.get_ValueAsInt("Supervisor_ID") + "AND UseAgencia = 'N' AND qtyLead > 0 AND IsActive = 'Y' ORDER BY qtyLead Desc";
                    CPreparedStatement pstmtSubUser = null;
                    ResultSet rsSubUser = null;
                    pstmtSubUser = DB.prepareStatement(sqlPUser, this.get_TrxName());
                    rsSubUser = pstmtSubUser.executeQuery();
                    rsSubUser.next();
                    if (rsSubUser.getInt("AD_User_ID") > 0) {
                        cFollow.set_CustomColumn("AD_User_ID", rsSubUser.getInt("AD_User_ID"));
                        cFollow.save();
                        DB.executeUpdate("UPDATE AD_User SET UseAgencia = 'Y', qtyLead = qtyLead-1 WHERE AD_User_ID = " + rsSubUser.getString("AD_User_ID"), this.get_TrxName());
                    }
                    this.commitEx();
                    rsSubUser.close();
                    pstmtSubUser.close();
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close(rsCLines, pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        this.commitEx();
        return true;
    }

    public Boolean asignUserCConsumo(int ID_Campaign) throws SQLException {
        int ID_EtiquetaUrlGL = 0;
        X_C_Campaign cam = new X_C_Campaign(this.getCtx(), ID_Campaign, this.get_TrxName());
        String sqlEje = "SELECT DISTINCT (cf.AD_User_ID), COALESCE((SELECT COUNT(1) FROM C_CampaignFollow  WHERE C_Campaign_ID = cf.C_Campaign_ID AND AD_User_ID = cf.AD_User_ID),0) as count FROM C_CampaignFollow cf WHERE cf.C_Campaign_ID = ? AND cf.AD_User_ID IS NOT NULL AND FinalStatus = 'AS'";
        ArrayList<Integer> ArrayIDUsuario = new ArrayList<Integer>();
        ArrayList<Integer> ArrayCantLeads = new ArrayList<Integer>();
        CPreparedStatement pstmtEje = null;
        ResultSet rsEje = null;
        try {
            try {
                pstmtEje = DB.prepareStatement(sqlEje.toString(), this.get_TrxName());
                pstmtEje.setInt(1, cam.get_ID());
                rsEje = pstmtEje.executeQuery();
                while (rsEje.next()) {
                    ArrayIDUsuario.add(rsEje.getInt(1));
                    ArrayCantLeads.add(rsEje.getInt(2));
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlEje.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsEje, pstmtEje);
            rsEje = null;
            pstmtEje = null;
            throw throwable;
        }
        DB.close(rsEje, pstmtEje);
        rsEje = null;
        pstmtEje = null;
        this.log.config("arrayidusuario: " + ArrayIDUsuario + " SQLEJE: " + sqlEje);
        int contador = 0;
        int InterestArea1_ID = 0;
        int InterestArea2_ID = 0;
        int InterestArea3_ID = 0;
        String sqlEtiquetas = "SELECT ci.R_InterestArea_ID, COALESCE(MAX(ci.R_InterestAreaValues_ID),0) as R_InterestAreaValues_ID FROM C_Campaign cc INNER JOIN R_CampaignInterest ci ON (cc.C_Campaign_ID = ci.C_Campaign_ID) WHERE cc.C_Campaign_ID=? AND ci.R_InterestArea_ID <> ? GROUP BY ci.R_InterestArea_ID UNION SELECT R_InterestArea_ID, 0 FROM R_InterestArea WHERE IsFilter = 'Y' ";
        this.log.config("Etiqueta: " + ID_EtiquetaUrlGL);
        int ID_EtiquetaURL = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(R_InterestArea_ID) FROM R_InterestArea WHERE value like 'Lead Sitio Privado'");
        if (ID_EtiquetaURL > 0) {
            ID_EtiquetaUrlGL = ID_EtiquetaURL;
        }
        CPreparedStatement pstmtEt = null;
        pstmtEt = DB.prepareStatement(sqlEtiquetas, this.get_TrxName());
        pstmtEt.setInt(1, cam.get_ID());
        pstmtEt.setInt(2, ID_EtiquetaUrlGL);
        this.log.config("sqlEtiquetas: " + sqlEtiquetas);
        ResultSet rsEt = pstmtEt.executeQuery();
        while (rsEt.next()) {
            this.log.config("contador: " + contador);
            if (++contador == 1) {
                InterestArea1_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea1 : " + InterestArea1_ID);
                continue;
            }
            if (contador == 2) {
                InterestArea2_ID = rsEt.getInt("R_InterestArea_ID");
                this.log.config("interestarea2 : " + InterestArea2_ID);
                continue;
            }
            if (contador != 3) continue;
            InterestArea3_ID = rsEt.getInt("R_InterestArea_ID");
            this.log.config("interestarea3: " + InterestArea3_ID);
        }
        String sqlCLines = "SELECT C_CampaignFollow_ID FROM C_CampaignFollow WHERE C_Campaign_ID = ?  AND FinalStatus IN ('IN') Order By C_CampaignFollow_ID";
        CPreparedStatement pstmtCLines = null;
        ResultSet rsCLines = null;
        this.log.config("sqlCLines: " + sqlCLines);
        try {
            try {
                pstmtCLines = DB.prepareStatement(sqlCLines, this.get_TrxName());
                pstmtCLines.setInt(1, cam.get_ID());
                rsCLines = pstmtCLines.executeQuery();
                while (rsCLines.next()) {
                    int indexCant;
                    X_C_CampaignFollow cFollow = new X_C_CampaignFollow(this.getCtx(), rsCLines.getInt("C_CampaignFollow_ID"), this.get_TrxName());
                    this.log.config("INT1: " + InterestArea1_ID + "  INT2: " + InterestArea2_ID + "   INT3: " + InterestArea3_ID);
                    String sqlEtBP = "SELECT R_InterestArea_ID, MAX(R_InterestAreaValues_ID) as R_InterestAreaValues_ID FROM R_ContactInterest WHERE C_Bpartner_ID = ? AND R_InterestArea_ID IN (" + InterestArea1_ID + "," + InterestArea2_ID + "," + InterestArea3_ID + ")" + " GROUP BY R_InterestArea_ID ";
                    int contadorBP = 0;
                    int InterestAreaBP1_ID = 0;
                    int InterestAreaValueBP1_ID = 0;
                    int InterestAreaBP2_ID = 0;
                    int InterestAreaValueBP2_ID = 0;
                    int InterestAreaBP3_ID = 0;
                    int InterestAreaValueBP3_ID = 0;
                    CPreparedStatement pstmtEtBP = null;
                    pstmtEtBP = DB.prepareStatement(sqlEtBP, this.get_TrxName());
                    pstmtEtBP.setInt(1, cFollow.getC_BPartner_ID());
                    ResultSet rsEtBP = pstmtEtBP.executeQuery();
                    this.log.config("sqlEtBP: " + sqlEtBP);
                    while (rsEtBP.next()) {
                        if (++contadorBP == 1) {
                            InterestAreaBP1_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP1_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP1_ID: " + InterestAreaBP1_ID + "  InterestAreaValueBP1_ID: " + InterestAreaValueBP1_ID);
                            continue;
                        }
                        if (contadorBP == 2) {
                            InterestAreaBP2_ID = rsEtBP.getInt("R_InterestArea_ID");
                            InterestAreaValueBP2_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                            this.log.config("InterestAreaBP2_ID: " + InterestAreaBP2_ID + "  InterestAreaValueBP2_ID: " + InterestAreaValueBP2_ID);
                            continue;
                        }
                        if (contadorBP != 3) continue;
                        InterestAreaBP3_ID = rsEtBP.getInt("R_InterestArea_ID");
                        InterestAreaValueBP3_ID = rsEtBP.getInt("R_InterestAreaValues_ID");
                        this.log.config("InterestAreaBP3_ID: " + InterestAreaBP3_ID + "  InterestAreaValueBP3_ID: " + InterestAreaValueBP3_ID);
                    }
                    String id_IaBPsql = "0";
                    if (InterestAreaBP1_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP1_ID;
                    }
                    if (InterestAreaBP2_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP2_ID;
                    }
                    if (InterestAreaBP3_ID > 0) {
                        id_IaBPsql = String.valueOf(id_IaBPsql) + "," + InterestAreaBP3_ID;
                    }
                    String id_IaVBPsql = "0";
                    this.log.config("id_IaBPsql: " + id_IaBPsql);
                    if (InterestAreaValueBP1_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP1_ID;
                    }
                    if (InterestAreaValueBP2_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP2_ID;
                    }
                    if (InterestAreaValueBP3_ID > 0) {
                        id_IaVBPsql = String.valueOf(id_IaVBPsql) + "," + InterestAreaValueBP3_ID;
                    }
                    String sqlEtUser = "SELECT DISTINCT(AD_User_ID),  COALESCE((SELECT COUNT(1) FROM C_CampaignFollow WHERE C_Campaign_ID = " + cFollow.getC_Campaign_ID() + "AND AD_User_ID = ui.AD_User_ID),0) as cant " + " FROM R_UserInterest ui " + " WHERE IsActive = 'Y' AND R_InterestArea_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues_ID IS NULL) ";
                    sqlEtUser = InterestAreaBP2_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues2_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues2_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef2_ID IS NULL";
                    sqlEtUser = InterestAreaBP3_ID > 0 ? String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IN (" + id_IaBPsql + ") AND (R_InterestAreaValues3_ID IN (" + id_IaVBPsql + ") OR R_InterestAreaValues3_ID IS NULL)" : String.valueOf(sqlEtUser) + " AND R_InterestAreaRef3_ID IS NULL";
                    sqlEtUser = String.valueOf(sqlEtUser) + " ORDER BY cant desc";
                    this.log.config("sqlEtUser: " + sqlEtUser);
                    CPreparedStatement pstmtEtUser = null;
                    pstmtEtUser = DB.prepareStatement(sqlEtUser, this.get_TrxName());
                    ResultSet rsEtUser = pstmtEtUser.executeQuery();
                    int minCantidad = 100000;
                    int CantLeadEje = 0;
                    int ID_EjecutivoM = 0;
                    while (rsEtUser.next()) {
                        if (ArrayIDUsuario != null) {
                            if (ArrayIDUsuario.contains(rsEtUser.getInt(1))) {
                                indexCant = ArrayIDUsuario.indexOf(rsEtUser.getInt(1));
                                CantLeadEje = (Integer)ArrayCantLeads.get(indexCant);
                            } else {
                                CantLeadEje = 0;
                            }
                        }
                        if (CantLeadEje >= minCantidad) continue;
                        minCantidad = CantLeadEje;
                        ID_EjecutivoM = rsEtUser.getInt(1);
                    }
                    if (ID_EjecutivoM <= 0) continue;
                    cFollow.setAD_User_ID(ID_EjecutivoM);
                    cFollow.setFinalStatus("AS");
                    cFollow.save();
                    if (ArrayIDUsuario.contains(ID_EjecutivoM)) {
                        indexCant = ArrayIDUsuario.indexOf(ID_EjecutivoM);
                        int CantLeadEjeN = (Integer)ArrayCantLeads.get(indexCant);
                        ArrayCantLeads.set(indexCant, ++CantLeadEjeN);
                        continue;
                    }
                    ArrayIDUsuario.add(ID_EjecutivoM);
                    ArrayCantLeads.add(1);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sqlCLines.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rsCLines, pstmtCLines);
            rsCLines = null;
            pstmtCLines = null;
            throw throwable;
        }
        DB.close(rsCLines, pstmtCLines);
        rsCLines = null;
        pstmtCLines = null;
        return true;
    }

    public boolean updateExpiredLead(int ID_Campaign) throws SQLException {
        String sqlUpdate = "UPDATE C_CampaignFollow SET finalstatus = 'IN'  WHERE C_CampaignFollow_ID IN ( SELECT ccf.C_campaignFollow_ID FROM C_CampaignFollow ccf INNER JOIN C_Campaign cc ON (ccf.C_Campaign_ID = cc.C_Campaign_ID) WHERE ccf.AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND " + " cc.c_campaign_id = " + ID_Campaign + " AND TRUNC((sysdate - ccf.updated),0) > COALESCE(cc.timeLimit,365) " + " AND ccf.finalstatus NOT IN ('CCV','CSV'))";
        DB.executeUpdate(sqlUpdate, this.get_TrxName());
        return true;
    }

    public boolean updateExpiredLeadAgencia(int ID_Campaign) throws SQLException {
        String sqlUpdate = "UPDATE C_CampaignFollow SET finalstatus = 'IN', AD_User_ID = null, Supervisor_ID = null WHERE C_CampaignFollow_ID IN ( SELECT ccf.C_campaignFollow_ID FROM C_CampaignFollow ccf INNER JOIN C_Campaign cc ON (ccf.C_Campaign_ID = cc.C_Campaign_ID) WHERE ccf.AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND " + " cc.c_campaign_id = " + ID_Campaign + " AND TRUNC((sysdate - ccf.updated),0) > COALESCE(cc.timeLimit,365) " + " AND ccf.finalstatus NOT IN ('CCV','CSV'))";
        DB.executeUpdate(sqlUpdate, this.get_TrxName());
        return true;
    }
}

