/*
 * Decompiled with CFR 0.152.
 */
package org.geminis.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.I_GL_Journal;
import org.compiere.model.MAsset;
import org.compiere.model.MAssetAcct;
import org.compiere.model.MDepreciationWorkfile;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalBatch;
import org.compiere.model.X_A_Asset_Dep;
import org.compiere.model.X_A_Asset_Forecast;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class VoidAssetProcess
extends SvrProcess {
    private int p_Year_ID = 0;
    private int p_Period_ID = 0;
    private int p_AssetGroup_ID = 0;
    private String p_DepType = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("C_Year_ID")) {
                    this.p_Year_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_Period_ID")) {
                    this.p_Period_ID = para[i].getParameterAsInt();
                } else if (name.equals("A_Asset_Group_ID")) {
                    this.p_AssetGroup_ID = para[i].getParameterAsInt();
                } else if (name.equals("DepType")) {
                    this.p_DepType = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws AdempiereSystemError {
        int contador = 0;
        String sqlC = "SELECT ad.A_Asset_Dep_ID FROM A_Asset_Dep ad WHERE ad.DepType = '" + this.p_DepType + "'";
        if (this.p_Period_ID > 0) {
            sqlC = String.valueOf(sqlC) + " AND ad.C_Period_ID = " + this.p_Period_ID;
        } else if (this.p_Year_ID > 0) {
            sqlC = String.valueOf(sqlC) + " AND ad.C_Period_ID IN (SELECT C_Period_ID FROM C_Period WHERE C_Year_ID = " + this.p_Year_ID + ")";
        }
        if (this.p_AssetGroup_ID > 0) {
            sqlC = String.valueOf(sqlC) + " AND ad.A_Asset_Group_ID = " + this.p_AssetGroup_ID;
        }
        sqlC = String.valueOf(sqlC) + " AND DocStatus = 'CO' ORDER BY ad.C_Period_ID DESC ";
        try {
            CPreparedStatement pstmt = null;
            pstmt = DB.prepareStatement(sqlC, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_A_Asset_Dep DepDoc = new X_A_Asset_Dep(this.getCtx(), rs.getInt("A_Asset_Dep_ID"), this.get_TrxName());
                MJournalBatch batch = null;
                batch = new MJournalBatch(this.getCtx(), DepDoc.getGL_JournalBatch_ID(), this.get_TrxName());
                if (!DepDoc.getDocStatus().equals("CO")) continue;
                MJournal[] journals = batch.getJournals(true);
                int i = 0;
                while (i < journals.length) {
                    MDepreciationWorkfile workfile;
                    MJournal jour = journals[i];
                    if (DepDoc.getDepType().equalsIgnoreCase("DEP")) {
                        workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                        workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(jour.getTotalCr()));
                        workfile.setA_Period_Posted(workfile.getA_Period_Posted() - 1);
                        workfile.setAssetDepreciationDate(DepDoc.getDateDoc());
                        workfile.save();
                        X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), this.get_TrxName());
                        fore.setProcessed(false);
                        fore.setGL_Journal_ID(0);
                        fore.save();
                    } else if (DepDoc.getDepType().equalsIgnoreCase("COR")) {
                        workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                        MAssetAcct group = new MAssetAcct(this.getCtx(), MAssetAcct.getAssetAcct_ID(jour.get_ValueAsInt("A_Asset_ID")), this.get_TrxName());
                        int flag = 0;
                        try {
                            flag = group.get_ValueAsInt("a_assetcomplement_acct");
                        }
                        catch (Exception e) {
                            flag = 0;
                            this.log.log(Level.SEVERE, e.getMessage(), e);
                        }
                        if (flag > 0) {
                            X_A_Asset_Forecast fore;
                            BigDecimal neto;
                            BigDecimal acum;
                            BigDecimal flag2 = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.get_ValueAsInt("a_assetcomplement_acct"), new Object[0]);
                            BigDecimal flag3 = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.get_ValueAsInt("a_assetcomplement_acct"), new Object[0]);
                            if (flag2 != null || flag3 != null) {
                                if (flag2 == null) {
                                    flag2 = Env.ZERO;
                                }
                                if (flag3 == null) {
                                    flag3 = Env.ZERO;
                                }
                                if (flag2.compareTo(Env.ZERO) >= 0 || flag3.compareTo(Env.ZERO) >= 0) {
                                    acum = flag2;
                                    acum = acum.subtract(flag3);
                                    neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                                    if (workfile != null && workfile.get_ID() > 0) {
                                        workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                                        workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                                        workfile.save();
                                    }
                                    if (jour.get_ValueAsInt("A_Asset_Forecast_ID") > 0) {
                                        fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                                        fore.setCorrected(false);
                                        fore.save();
                                    }
                                } else {
                                    acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]);
                                    neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                                    if (acum == null) {
                                        acum = Env.ZERO;
                                    }
                                    if (neto == null) {
                                        neto = Env.ZERO;
                                    }
                                    if (workfile != null && workfile.get_ID() > 0) {
                                        workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                                        workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                                        workfile.save();
                                    }
                                    if (jour.get_ValueAsInt("A_Asset_Forecast_ID") > 0) {
                                        fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                                        fore.setCorrected(false);
                                        fore.save();
                                    }
                                }
                            } else {
                                acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]);
                                neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                                if (acum == null) {
                                    acum = Env.ZERO;
                                }
                                if (neto == null) {
                                    neto = Env.ZERO;
                                }
                                if (workfile != null && workfile.get_ID() > 0) {
                                    workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                                    workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                                    workfile.save();
                                }
                                if (jour.get_ValueAsInt("A_Asset_Forecast_ID") > 0) {
                                    fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                                    fore.setCorrected(false);
                                    fore.save();
                                }
                            }
                        } else {
                            BigDecimal acum = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctDr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Depreciation_Acct(), new Object[0]);
                            BigDecimal neto = DB.getSQLValueBD(this.get_TrxName(), "select sum(AmtAcctCr) from gl_journalline where gl_journal_id=" + jour.getGL_Journal_ID() + " and C_ValidCombination_ID=" + group.getA_Accumdepreciation_Acct(), new Object[0]);
                            if (acum == null) {
                                acum = Env.ZERO;
                            }
                            if (neto == null) {
                                neto = Env.ZERO;
                            }
                            if (workfile != null && workfile.get_ID() > 0) {
                                workfile.setA_Accumulated_Depr(workfile.getA_Accumulated_Depr().subtract(acum));
                                workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(neto));
                                workfile.save();
                            }
                            if (jour.get_ValueAsInt("A_Asset_Forecast_ID") > 0) {
                                X_A_Asset_Forecast fore = new X_A_Asset_Forecast(Env.getCtx(), jour.get_ValueAsInt("A_Asset_Forecast_ID"), null);
                                fore.setCorrected(false);
                                fore.save();
                            }
                        }
                    } else if (DepDoc.getDepType().equalsIgnoreCase("REV")) {
                        workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                        workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().subtract(jour.getTotalCr()));
                        workfile.save();
                    } else if (DepDoc.getDepType().equalsIgnoreCase("DET")) {
                        workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                        workfile.setA_Asset_Cost(workfile.getA_Asset_Cost().add(jour.getTotalCr()));
                        workfile.save();
                    } else if (DepDoc.getDepType().equalsIgnoreCase("SAL")) {
                        workfile = MAsset.getWorkFile(jour.get_ValueAsInt("A_Asset_ID"));
                        workfile.setA_Accumulated_Depr(workfile.getA_Calc_Accumulated_Depr());
                        workfile.save();
                        DB.executeUpdate("Update A_Asset_Forecast set processed='N', corrected='N' where gl_journal_id is null and A_Asset_ID=" + jour.get_ValueAsInt("A_Asset_ID"), this.get_TrxName());
                    }
                    ++i;
                }
                MJournal[] mJournalArray = journals;
                int n = journals.length;
                int n2 = 0;
                while (n2 < n) {
                    MJournal j = mJournalArray[n2];
                    DB.executeUpdate("delete from fact_acct where record_id=" + j.getGL_Journal_ID() + " and ad_table_id=" + I_GL_Journal.Table_ID, this.get_TrxName());
                    DB.executeUpdate("delete from gl_journalline where gl_journal_id=" + j.getGL_Journal_ID(), this.get_TrxName());
                    ++n2;
                }
                DB.executeUpdate("delete from gl_journal where gl_journalbatch_id=" + batch.getGL_JournalBatch_ID(), this.get_TrxName());
                DepDoc.setDocStatus("VO");
                DepDoc.setProcessed(true);
                DepDoc.save();
                ++contador;
                this.commit();
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), e);
        }
        return "Se han anulado " + contador + " procesos de activo";
    }
}

