/*
 * Decompiled with CFR 0.152.
 */
package org.geminis.model;

import org.compiere.model.MCash;
import org.compiere.model.MClient;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBGeminis
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBGeminis.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Payment", this);
        engine.addDocValidate("C_Cash", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        String sql;
        int cant;
        MPayment pay;
        boolean override;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if (!(type != 1 && type != 2 || po.get_Table_ID() != 335 || (override = (pay = (MPayment)po).get_ValueAsBoolean("Override")) || (cant = DB.getSQLValue(null, sql = "SELECT COUNT(*) FROM C_Payment cp WHERE cp.C_BPartner_ID = ? AND (SELECT COUNT(*) FROM C_AllocationLine cal WHERE cal.C_Payment_ID = cp.C_Payment_ID) < 1 AND cp.C_Payment_ID <> ? AND cp.PayAmt = ? AND cp.IsReceipt = ? AND cp.DocStatus NOT IN ('VO')", pay.getC_BPartner_ID(), pay.get_ID(), pay.getPayAmt(), pay.get_ValueAsBoolean("IsReceipt"))) <= 0)) {
            return "Existe un pago sin asignaciones para el mismo socio de negocio con el mismo monto";
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 10 && po.get_Table_ID() == MCash.Table_ID) {
            MCash cash = (MCash)po;
            cash.setBeginningBalance(Env.ZERO);
            cash.setEndingBalance(Env.ZERO);
            cash.saveEx(po.get_TrxName());
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }
}

