/*
 * Decompiled with CFR 0.152.
 */
package org.geminis.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CalloutGeminisOC
extends CalloutEngine {
    public String BudgetReview(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Boolean op = (Boolean)value;
        if (op.booleanValue()) {
            int C_Order_ID = Integer.parseInt(mTab.getValue("C_Order_ID").toString());
            this.log.info("C_Order_ID=" + C_Order_ID);
            if (C_Order_ID == 0) {
                throw new IllegalArgumentException("Target C_Order_ID == 0");
            }
            MOrder order = new MOrder(ctx, C_Order_ID, null);
            int cantIB = 0;
            String helpInfo = "";
            Timestamp dateOrder = order.getDateOrdered();
            Calendar datePO = Calendar.getInstance();
            datePO.setTime(dateOrder);
            int ahno = datePO.get(1);
            int mes = datePO.get(2);
            ++mes;
            MOrderLine[] lines = order.getLines(false, null);
            int i = 0;
            while (i < lines.length) {
                int tipoCuenta;
                MOrderLine line = new MOrderLine(ctx, lines[i].getC_OrderLine_ID(), null);
                int CCosto = line.get_ValueAsInt("C_ProjectOFB_ID");
                BigDecimal qpresupuesto = new BigDecimal("0.0");
                BigDecimal qpresupuestoPM = new BigDecimal("0.0");
                BigDecimal qpresupuestoA = new BigDecimal("0.0");
                BigDecimal qpresupuestoPMA = new BigDecimal("0.0");
                if (line.getM_Product_ID() > 0) {
                    MProduct prod = new MProduct(ctx, line.getM_Product_ID(), null);
                    MProductCategory catProd = new MProductCategory(ctx, prod.getM_Product_Category_ID(), null);
                    tipoCuenta = catProd.get_ValueAsInt("erpg_tipo_cuenta");
                } else if (line.getC_Charge_ID() > 0) {
                    MCharge charge = new MCharge(ctx, line.getC_Charge_ID(), null);
                    tipoCuenta = charge.get_ValueAsInt("erpg_tipo_cuenta");
                } else {
                    tipoCuenta = 0;
                }
                CPreparedStatement pstmt = null;
                String mysql = "select abs(qpresupuesto) as qpresupuesto, abs(qpresupuesto_prog_manual) qpresupuesto_prog_manual from erpg_programa_flujo_anual where erpg_tipo_cuenta = ? and c_projectofb_id = ? and extract(year from fmes_anio) = ? and extract(month from fmes_anio) = ? and isactive like 'Y'";
                try {
                    pstmt = DB.prepareStatement(mysql, null);
                    pstmt.setInt(1, tipoCuenta);
                    pstmt.setInt(2, CCosto);
                    pstmt.setString(3, Integer.toString(ahno));
                    pstmt.setInt(4, mes);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        qpresupuesto = rs.getBigDecimal(1) == null ? new BigDecimal("0.0") : rs.getBigDecimal(1);
                        qpresupuestoPM = rs.getBigDecimal(2) == null ? new BigDecimal("0.0") : rs.getBigDecimal(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                BigDecimal saldoMes = qpresupuestoPM.subtract(qpresupuesto);
                CPreparedStatement pstmtA = null;
                String mysqlA = "select abs(sum(qpresupuesto)) as qpresupuesto, abs(sum(qpresupuesto_prog_manual)) as qpresupuesto_prog_manual from erpg_programa_flujo_anual where erpg_tipo_cuenta =  ? and c_projectofb_id = ? and extract(year from fmes_anio) = ? and isactive like 'Y' ";
                try {
                    pstmtA = DB.prepareStatement(mysqlA, null);
                    pstmtA.setInt(1, tipoCuenta);
                    pstmtA.setInt(2, CCosto);
                    pstmtA.setString(3, Integer.toString(ahno));
                    ResultSet rsA = pstmtA.executeQuery();
                    if (rsA.next()) {
                        qpresupuestoA = rsA.getBigDecimal(1) == null ? new BigDecimal("0.0") : rsA.getBigDecimal(1);
                        qpresupuestoPMA = rsA.getBigDecimal(2) == null ? new BigDecimal("0.0") : rsA.getBigDecimal(2);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, e.getMessage(), e);
                }
                BigDecimal saldoAnual = qpresupuestoPMA.subtract(qpresupuestoA);
                if (line.getLineNetAmt().compareTo(saldoMes) <= 0) {
                    cantIB += 0;
                    helpInfo = "Presupuesto Correcto - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt();
                    line.set_CustomColumn("BudgetInfo", 1);
                } else if (line.getLineNetAmt().compareTo(saldoAnual) <= 0) {
                    cantIB += 0;
                    helpInfo = "Presupuesto mensual sobrepasado. Uso presupuesto anual - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt() + " Saldo anual:" + saldoAnual;
                    line.set_CustomColumn("BudgetInfo", 2);
                } else {
                    ++cantIB;
                    helpInfo = "Presupuesto mensual y anual sobrepasado - Presupuesto mes:" + qpresupuestoPM + " Disponible mes:" + saldoMes + " a Consumir:" + line.getLineNetAmt() + " Saldo anual:" + saldoAnual;
                    line.set_CustomColumn("BudgetInfo", 3);
                }
                line.set_CustomColumn("HelpBudget", helpInfo);
                line.save();
                ++i;
            }
            if (cantIB > 0) {
                mTab.setValue("BudgetStatus", (Object)false);
                mTab.setValue("IsSelected", (Object)false);
            } else {
                mTab.setValue("BudgetStatus", (Object)true);
                mTab.setValue("IsSelected", (Object)true);
            }
            order.save();
        }
        return "";
    }
}

