/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.tools.swing;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.ItemSelectable;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class SwingTool {
    public static synchronized void setCursorsFromChild(Component child, boolean waiting) {
        Component com = child;
        while (com.getParent() != null) {
            com = com.getParent();
        }
        SwingTool.setCursorsFromParent((Container)com, waiting);
    }

    protected static boolean isIgnoredComponent(Component c) {
        boolean retVal = true;
        if (c instanceof ItemSelectable && c.isEnabled()) {
            retVal = false;
        } else if (c instanceof JTextComponent && c.isEnabled()) {
            retVal = false;
        } else if (c instanceof JFrame && c.isEnabled()) {
            retVal = false;
        } else if (c instanceof JPanel && c.isEnabled()) {
            retVal = false;
        } else if (c instanceof JLabel && c.isEnabled()) {
            retVal = false;
        } else if (c instanceof Adjustable && c.isEnabled()) {
            retVal = false;
        }
        return retVal;
    }

    public static void setCursor(Component c, boolean waiting) {
        if (SwingTool.isIgnoredComponent(c)) {
            return;
        }
        Cursor cursor_wait = new Cursor(3);
        Cursor cursor_def = SwingTool.getPredefinedCursor(c);
        Component com = c;
        if (waiting) {
            com.setCursor(cursor_wait);
        } else {
            com.setCursor(cursor_def);
        }
    }

    public static Cursor getPredefinedCursor(Component c) {
        Cursor cursor = Cursor.getDefaultCursor();
        if (c instanceof JTextComponent) {
            cursor = Cursor.getPredefinedCursor(2);
        } else if (c instanceof ItemSelectable || c instanceof Adjustable) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        return cursor;
    }

    public static void setCursors(Component[] components, boolean waiting) {
        int i = 0;
        while (i < components.length) {
            SwingTool.setCursor(components[i], waiting);
            ++i;
        }
    }

    public static synchronized void setCursorsFromParent(Container parent, boolean waiting) {
        Container con = parent;
        int i = 0;
        while (i < con.getComponentCount()) {
            SwingTool.setCursor(con.getComponent(i), waiting);
            if (con.getComponent(i) instanceof Container) {
                SwingTool.setCursorsFromParent((Container)con.getComponent(i), waiting);
            }
            ++i;
        }
    }

    public static Component searchComponent(Container parent, Class clazz, boolean remove) {
        Container con = parent;
        Component retVal = null;
        Component c = null;
        int i = 0;
        while (i < con.getComponentCount()) {
            c = con.getComponent(i);
            if (clazz.isInstance(c)) {
                if (remove) {
                    con.remove(c);
                }
                return c;
            }
            if (c instanceof Container && clazz.isInstance(c = SwingTool.searchComponent((Container)c, clazz, remove))) {
                if (remove) {
                    con.remove(retVal);
                }
                return c;
            }
            ++i;
        }
        return null;
    }

    public static void addOpaque(JComponent c, final boolean opaque) {
        ContainerAdapter ca = new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                this.setOpaque(e.getChild());
            }

            private void setOpaque(Component c) {
                if (c instanceof ItemSelectable) {
                    return;
                }
                if (c instanceof JComponent) {
                    ((JComponent)c).setOpaque(opaque);
                } else if (c instanceof Container) {
                    int i = 0;
                    while (i > ((Container)c).getComponentCount()) {
                        this.setOpaque(((Container)c).getComponent(i));
                        ++i;
                    }
                }
            }
        };
        c.addContainerListener(ca);
    }

    public static KeyStroke getKeyStrokeFor(String name, List usedStrokes) {
        return name == null ? null : SwingTool.getKeyStrokeFor(name.charAt(0), usedStrokes);
    }

    public static KeyStroke getKeyStrokeFor(char c, List usedStrokes) {
        int m = 2;
        KeyStroke o2 = null;
        for (KeyStroke o2 : usedStrokes) {
            if (c != o2.getKeyChar() || c != o2.getKeyChar()) continue;
            m = o2.getModifiers() != 3 ? 3 : (o2.getModifiers() != 9 ? 9 : -1);
        }
        KeyStroke s = null;
        if (m != -1) {
            s = KeyStroke.getKeyStroke((int)c, m);
            usedStrokes.add(s);
        }
        return s;
    }
}

