/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.tools.swing;

import java.math.BigDecimal;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eevolution.tools.swing.CharDefinition;

public abstract class AbstractLimiterPlainDocument
extends PlainDocument {
    protected int charCount;
    protected BigDecimal maxNumber;
    protected BigDecimal minNumber;
    protected CharDefinition charDefinition;

    public abstract void action(String var1);

    public AbstractLimiterPlainDocument(CharDefinition def) {
        this.charDefinition = def;
        this.charCount = -1;
    }

    public int getCharCount() {
        return this.charCount;
    }

    public void setCharCount(int charCount) {
        this.charCount = charCount;
    }

    public BigDecimal getMaxNumber() {
        return this.maxNumber;
    }

    public BigDecimal getMinNumber() {
        return this.minNumber;
    }

    public void setMaxNumber(BigDecimal number) {
        this.maxNumber = number;
    }

    public void setMinNumber(BigDecimal number) {
        this.minNumber = number;
    }

    public CharDefinition getCharDefinition() {
        return this.charDefinition;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null || !this.charDefinition.contains(str.charAt(0))) {
            return;
        }
        if (this.getCharCount() > 0 && this.getLength() + str.length() > this.charCount) {
            return;
        }
        String value = String.valueOf(this.getText(0, offset)) + str;
        if (!this.isValidNumber(value)) {
            return;
        }
        this.action(value);
        super.insertString(offset, str, attr);
    }

    protected boolean isValidNumber(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        boolean valid = true;
        if (this.maxNumber != null) {
            BigDecimal actual = new BigDecimal(str);
            boolean bl = valid = this.maxNumber.compareTo(actual) >= 0;
            if (valid && this.minNumber != null) {
                valid = this.minNumber.compareTo(actual) < 0;
            }
        }
        return valid;
    }
}

