/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.Env;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class CopyFromBOM
extends SvrProcess {
    private int p_Record_ID = 0;
    private int p_PP_Product_BOM_ID = 0;
    private int no = 0;
    private Properties ctx = Env.getCtx();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("PP_Product_BOM_ID")) {
                    this.p_PP_Product_BOM_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        MPPProductBOMLine[] frombomlines;
        this.log.info("From PP_Product_BOM_ID=" + this.p_PP_Product_BOM_ID + " to " + this.p_Record_ID);
        if (this.p_Record_ID == 0) {
            throw new IllegalArgumentException("Target PP_Product_BOM_ID == 0");
        }
        if (this.p_PP_Product_BOM_ID == 0) {
            throw new IllegalArgumentException("Source PP_Product_BOM_ID == 0");
        }
        if (this.p_Record_ID == this.p_PP_Product_BOM_ID) {
            return "";
        }
        MPPProductBOM fromBom = new MPPProductBOM(this.ctx, this.p_PP_Product_BOM_ID, this.get_TrxName());
        MPPProductBOM toBOM = new MPPProductBOM(this.ctx, this.p_Record_ID, this.get_TrxName());
        if (toBOM.getLines().length > 0) {
            throw new AdempiereSystemError("@Error@ Existing BOM Line(s)");
        }
        MPPProductBOMLine[] mPPProductBOMLineArray = frombomlines = fromBom.getLines();
        int n = frombomlines.length;
        int n2 = 0;
        while (n2 < n) {
            MPPProductBOMLine frombomline = mPPProductBOMLineArray[n2];
            MPPProductBOMLine tobomline = new MPPProductBOMLine(this.ctx, 0, this.get_TrxName());
            MPPProductBOMLine.copyValues(frombomline, tobomline);
            tobomline.setPP_Product_BOM_ID(toBOM.getPP_Product_BOM_ID());
            tobomline.save();
            ++this.no;
            ++n2;
        }
        return "OK";
    }

    @Override
    protected void postProcess(boolean success) {
        this.addLog("@Copied@=" + this.no);
    }
}

