/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MRule;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.Scriptlet;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.I_PP_Cost_Collector;
import org.eevolution.model.MHRAttribute;
import org.eevolution.model.MHRConcept;
import org.eevolution.model.MHRConceptCategory;
import org.eevolution.model.MHREmployee;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRPayroll;
import org.eevolution.model.MHRPayrollConcept;
import org.eevolution.model.MHRPeriod;
import org.eevolution.model.MPPCostCollector;
import org.eevolution.model.X_HR_Process;

public class MHRProcess
extends X_HR_Process
implements DocAction {
    private static final long serialVersionUID = 570699817555475782L;
    public int m_C_BPartner_ID = 0;
    public int m_AD_User_ID = 0;
    public int m_HR_Concept_ID = 0;
    public String m_columnType = "";
    public Timestamp m_dateFrom;
    public Timestamp m_dateTo;
    public Hashtable<Integer, MHRMovement> m_movement = new Hashtable();
    public MHRPayrollConcept[] linesConcept;
    private static CLogger s_log = CLogger.getCLogger(MHREmployee.class);
    public static final String CONCEPT_PP_COST_COLLECTOR_LABOR = "PP_COST_COLLECTOR_LABOR";
    private static StringBuffer s_scriptImport = new StringBuffer(" import org.eevolution.model.*; import org.compiere.util.DB; import java.math.*; import java.sql.*;");
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static void addScriptImportPackage(String packageName) {
        s_scriptImport.append(" import ").append(packageName).append(";");
    }

    public MHRProcess(Properties ctx, int HR_Process_ID, String trxName) {
        super(ctx, HR_Process_ID, trxName);
        if (HR_Process_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("PR");
            this.setC_DocType_ID(0);
            this.set_ValueNoCheck("DocumentNo", null);
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setHR_Department_ID(0);
            this.setC_BPartner_ID(0);
        }
    }

    public MHRProcess(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public final void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        String sql = "UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?";
        DB.executeUpdateEx("UPDATE HR_Process SET Processed=? WHERE HR_Process_ID=?", new Object[]{processed, this.get_ID()}, this.get_TrxName());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Client_ID() == 0) {
            throw new AdempiereException("@AD_Client_ID@ = 0");
        }
        if (this.getAD_Org_ID() == 0) {
            int context_AD_Org_ID = this.getAD_Org_ID();
            if (context_AD_Org_ID == 0) {
                throw new AdempiereException("@AD_Org_ID@ = *");
            }
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info("prepareIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MHRPeriod period = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        MPeriod.testPeriodOpen(this.getCtx(), this.getHR_Period_ID() > 0 ? period.getDateAcct() : this.getDateAcct(), this.getC_DocTypeTarget_ID(), this.getAD_Org_ID());
        if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        try {
            this.createMovements();
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean approveIt() {
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    public boolean postIt() {
        this.log.info("postIt - " + this.toString());
        return false;
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        if (this.isProcessed()) {
            this.log.info(this.toString());
            this.setProcessed(true);
            this.setDocAction("--");
            return true;
        }
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return this.voidIt();
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if ("WI".equals(DocSubTypeSO) || "WP".equals(DocSubTypeSO) || "WR".equals(DocSubTypeSO)) {
            return false;
        }
        this.log.fine("reActivateIt - Existing documents not modified - SubType=" + DocSubTypeSO);
        String sql = "DELETE FROM HR_Movement WHERE HR_Process_ID =" + this.getHR_Process_ID() + " AND IsRegistered = 'N'";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine("HR_Process deleted #" + no);
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return BigDecimal.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        return "";
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 0, 0);
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return String.valueOf(dt.getName()) + " " + this.getDocumentNo();
    }

    public MHRMovement[] getLines(boolean requery) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("HR_Process_ID=?");
        params.add(this.getHR_Process_ID());
        whereClause.append("AND (Qty <> 0 OR Amount <> 0)");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Movement.HR_Concept_ID AND c.IsActive=? AND c.AccountSign<>?)");
        params.add(true);
        params.add("N");
        whereClause.append(" AND EXISTS(SELECT 1 FROM HR_Concept_Acct ca WHERE ca.HR_Concept_ID=HR_Movement.HR_Concept_ID AND ca.IsActive=? AND ca.IsBalancing<>?)");
        params.add(true);
        params.add(true);
        whereClause.append(" AND C_BPartner_ID IS NOT NULL");
        StringBuffer orderByClause = new StringBuffer();
        orderByClause.append("(SELECT bp.C_BP_Group_ID FROM C_BPartner bp WHERE bp.C_BPartner_ID=HR_Movement.C_BPartner_ID)");
        List<MHRMovement> list = new Query(this.getCtx(), "HR_Movement", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy(orderByClause.toString()).list();
        return list.toArray(new MHRMovement[list.size()]);
    }

    private void loadMovements(Hashtable<Integer, MHRMovement> movements, int C_PBartner_ID) {
        String whereClause = "HR_Process_ID=? AND C_BPartner_ID=?";
        List list = new Query(this.getCtx(), "HR_Movement", "HR_Process_ID=? AND C_BPartner_ID=?", this.get_TrxName()).setParameters(this.getHR_Process_ID(), C_PBartner_ID).list();
        for (MHRMovement mvm : list) {
            if (movements.containsKey(mvm.getHR_Concept_ID())) {
                MHRMovement lastM = movements.get(mvm.getHR_Concept_ID());
                String columntype = lastM.getColumnType();
                if (columntype.equals("A")) {
                    mvm.addAmount(lastM.getAmount());
                } else if (columntype.equals("Q")) {
                    mvm.addQty(lastM.getQty());
                }
            }
            movements.put(mvm.getHR_Concept_ID(), mvm);
        }
    }

    private Object executeScript(HashMap<String, Object> scriptCtx, int AD_Rule_ID) {
        MRule rulee = MRule.get(this.getCtx(), AD_Rule_ID);
        Object result = null;
        try {
            String script2;
            Scriptlet engine;
            Exception ex;
            String text = "";
            if (rulee.getScript() != null) {
                text = rulee.getScript().trim().replaceAll("\\bget", "process.get").replace(".process.get", ".get");
            }
            if ((ex = (engine = new Scriptlet("result", script2 = String.valueOf(s_scriptImport.toString()) + " double result = 0;" + text, scriptCtx)).execute()) != null) {
                throw ex;
            }
            result = engine.getResult(false);
        }
        catch (Exception e) {
            throw new AdempiereException("Execution error - @AD_Rule_ID@=" + rulee.getValue());
        }
        return result;
    }

    private void createCostCollectorMovements(int C_BPartner_ID, MHRPeriod period, HashMap<String, Object> scriptCtx) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("EXISTS (SELECT 1 FROM AD_User u WHERE u.AD_User_ID=PP_Cost_Collector.AD_User_ID AND u.C_BPartner_ID=?)");
        params.add(C_BPartner_ID);
        whereClause.append(" AND MovementDate>=?");
        params.add(period.getStartDate());
        whereClause.append(" AND MovementDate<=?");
        params.add(period.getEndDate());
        whereClause.append(" AND DocStatus IN (?,?)");
        params.add("CO");
        params.add("CL");
        List listColector = new Query(this.getCtx(), "PP_Cost_Collector", whereClause.toString(), this.get_TrxName()).setOnlyActiveRecords(true).setParameters(params).setOrderBy("PP_Cost_Collector_ID DESC").list();
        for (MPPCostCollector cc : listColector) {
            this.createMovementForCC(C_BPartner_ID, cc, scriptCtx);
        }
    }

    private MHRMovement createMovementForCC(int C_BPartner_ID, I_PP_Cost_Collector cc, HashMap<String, Object> scriptCtx) {
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), CONCEPT_PP_COST_COLLECTOR_LABOR);
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
        params.add(this.m_dateFrom);
        params.add(this.m_dateTo);
        whereClause.append(" AND HR_Concept_ID = ? ");
        params.add(concept.get_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
        MHRAttribute att = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first();
        if (att == null) {
            throw new AdempiereException();
        }
        if ("E".equals(concept.getType())) {
            Object result = null;
            scriptCtx.put("_CostCollector", cc);
            try {
                result = this.executeScript(scriptCtx, att.getAD_Rule_ID());
            }
            finally {
                scriptCtx.remove("_CostCollector");
            }
            if (result == null) {
                this.log.warning("Variable (result) is null");
            }
            MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), C_BPartner_ID, this.get_TrxName());
            MHRMovement mv = new MHRMovement(this, concept);
            mv.setC_BPartner_ID(C_BPartner_ID);
            mv.setAD_Rule_ID(att.getAD_Rule_ID());
            mv.setHR_Job_ID(employee.getHR_Job_ID());
            mv.setHR_Department_ID(employee.getHR_Department_ID());
            mv.setC_Activity_ID(employee.getC_Activity_ID());
            mv.setValidFrom(this.m_dateFrom);
            mv.setValidTo(this.m_dateTo);
            mv.setPP_Cost_Collector_ID(cc.getPP_Cost_Collector_ID());
            mv.setIsRegistered(true);
            mv.setColumnValue(result);
            mv.setProcessed(true);
            mv.saveEx();
            return mv;
        }
        throw new AdempiereException();
    }

    private void createMovements() throws Exception {
        HashMap<String, Object> scriptCtx = new HashMap<String, Object>();
        scriptCtx.put("process", this);
        scriptCtx.put("_Process", this.getHR_Process_ID());
        scriptCtx.put("_Period", this.getHR_Period_ID());
        scriptCtx.put("_Payroll", this.getHR_Payroll_ID());
        scriptCtx.put("_Department", this.getHR_Department_ID());
        this.log.info("info data -  Process: " + this.getHR_Process_ID() + ", Period: " + this.getHR_Period_ID() + ", Payroll: " + this.getHR_Payroll_ID() + ", Department: " + this.getHR_Department_ID());
        MHRPeriod period = new MHRPeriod(this.getCtx(), this.getHR_Period_ID(), this.get_TrxName());
        if (period != null) {
            this.m_dateFrom = period.getStartDate();
            this.m_dateTo = period.getEndDate();
            scriptCtx.put("_From", period.getStartDate());
            scriptCtx.put("_To", period.getEndDate());
        }
        int no = DB.executeUpdateEx("DELETE FROM HR_Movement m WHERE HR_Process_ID=? AND IsRegistered<>?", new Object[]{this.getHR_Process_ID(), true}, this.get_TrxName());
        this.log.info("HR_Movement deleted #" + no);
        this.linesConcept = MHRPayrollConcept.getPayrollConcepts(this);
        MBPartner[] linesEmployee = MHREmployee.getEmployees(this);
        int count = 1;
        MBPartner[] mBPartnerArray = linesEmployee;
        int n = linesEmployee.length;
        int n2 = 0;
        while (n2 < n) {
            MHRPayrollConcept pc;
            MBPartner bp = mBPartnerArray[n2];
            this.log.info("Employee " + count + "  ---------------------- " + bp.getName());
            ++count;
            this.m_C_BPartner_ID = bp.get_ID();
            MHREmployee employee = MHREmployee.getActiveEmployee(this.getCtx(), this.m_C_BPartner_ID, this.get_TrxName());
            scriptCtx.put("_DateStart", employee.getStartDate());
            scriptCtx.put("_DateEnd", employee.getEndDate() == null ? TimeUtil.getDay(2999, 12, 31) : employee.getEndDate());
            scriptCtx.put("_Days", TimeUtil.getDaysBetween(period.getStartDate(), period.getEndDate()) + 1);
            scriptCtx.put("_C_BPartner_ID", bp.getC_BPartner_ID());
            this.createCostCollectorMovements(bp.get_ID(), period, scriptCtx);
            this.m_movement.clear();
            this.loadMovements(this.m_movement, this.m_C_BPartner_ID);
            MHRPayrollConcept[] mHRPayrollConceptArray = this.linesConcept;
            int n3 = this.linesConcept.length;
            int n4 = 0;
            while (n4 < n3) {
                block9: {
                    MHRMovement movement;
                    block12: {
                        MHRAttribute att;
                        block10: {
                            Object result;
                            block11: {
                                MHRConcept concept;
                                block8: {
                                    pc = mHRPayrollConceptArray[n4];
                                    this.m_HR_Concept_ID = pc.getHR_Concept_ID();
                                    concept = MHRConcept.get(this.getCtx(), this.m_HR_Concept_ID);
                                    this.m_columnType = concept.getColumnType();
                                    ArrayList<Object> params = new ArrayList<Object>();
                                    StringBuffer whereClause = new StringBuffer();
                                    whereClause.append("? >= ValidFrom AND ( ? <= ValidTo OR ValidTo IS NULL)");
                                    params.add(this.m_dateFrom);
                                    params.add(this.m_dateTo);
                                    whereClause.append(" AND HR_Concept_ID = ? ");
                                    params.add(this.m_HR_Concept_ID);
                                    whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept conc WHERE conc.HR_Concept_ID = HR_Attribute.HR_Concept_ID )");
                                    if (concept.isEmployee()) {
                                        whereClause.append(" AND C_BPartner_ID = ? AND (HR_Employee_ID = ? OR HR_Employee_ID IS NULL)");
                                        params.add(employee.getC_BPartner_ID());
                                        params.add(employee.get_ID());
                                    }
                                    if ((att = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOnlyActiveRecords(true).setOrderBy("ValidFrom DESC").first()) != null && !concept.isRegistered()) break block8;
                                    this.log.info("Skip concept " + concept + " - attribute not found");
                                    break block9;
                                }
                                this.log.info("Concept - " + concept.getName());
                                movement = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
                                movement.setC_BPartner_ID(this.m_C_BPartner_ID);
                                movement.setHR_Concept_ID(this.m_HR_Concept_ID);
                                movement.setHR_Concept_Category_ID(concept.getHR_Concept_Category_ID());
                                movement.setHR_Process_ID(this.getHR_Process_ID());
                                movement.setHR_Department_ID(employee.getHR_Department_ID());
                                movement.setHR_Job_ID(employee.getHR_Job_ID());
                                movement.setColumnType(this.m_columnType);
                                movement.setAD_Rule_ID(att.getAD_Rule_ID());
                                movement.setValidFrom(this.m_dateFrom);
                                movement.setValidTo(this.m_dateTo);
                                movement.setIsPrinted(att.isPrinted());
                                movement.setIsRegistered(concept.isRegistered());
                                movement.setC_Activity_ID(employee.getC_Activity_ID());
                                if (!"E".equals(concept.getType())) break block10;
                                result = this.executeScript(scriptCtx, att.getAD_Rule_ID());
                                if (result != null) break block11;
                                this.log.warning("Variable (result) is null");
                                break block9;
                            }
                            movement.setColumnValue(result);
                            break block12;
                        }
                        movement.setQty(att.getQty());
                        movement.setAmount(att.getAmount());
                        movement.setTextMsg(att.getTextMsg());
                        movement.setServiceDate(att.getServiceDate());
                    }
                    movement.setProcessed(true);
                    this.m_movement.put(this.m_HR_Concept_ID, movement);
                }
                ++n4;
            }
            mHRPayrollConceptArray = this.linesConcept;
            n3 = this.linesConcept.length;
            n4 = 0;
            while (n4 < n3) {
                pc = mHRPayrollConceptArray[n4];
                MHRMovement m = this.m_movement.get(pc.getHR_Concept_ID());
                if (m != null) {
                    MHRConcept c = MHRConcept.get(this.getCtx(), pc.getHR_Concept_ID());
                    if (c.isRegistered() || m.isEmpty()) {
                        this.log.fine("Skip saving " + m);
                    } else {
                        m.saveEx();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        period.setProcessed(true);
        period.saveEx();
    }

    public double getConcept(String pconcept) {
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pconcept.trim());
        if (concept == null) {
            return 0.0;
        }
        MHRMovement m = this.m_movement.get(concept.get_ID());
        if (m == null) {
            return 0.0;
        }
        String type = m.getColumnType();
        if ("A".equals(type)) {
            return m.getAmount().doubleValue();
        }
        if ("Q".equals(type)) {
            return m.getQty().doubleValue();
        }
        return 0.0;
    }

    public void setConcept(String conceptValue, double value) {
        try {
            MHRConcept c = MHRConcept.forValue(this.getCtx(), conceptValue);
            if (c == null) {
                return;
            }
            MHRMovement m = new MHRMovement(this.getCtx(), 0, this.get_TrxName());
            m.setColumnType(c.getColumnType());
            m.setColumnValue(BigDecimal.valueOf(value));
            m.setHR_Process_ID(this.getHR_Process_ID());
            m.setHR_Concept_ID(this.m_HR_Concept_ID);
            m.setC_BPartner_ID(this.m_C_BPartner_ID);
            m.setDescription("Added From Rule");
            m.setValidFrom(this.m_dateTo);
            m.setValidTo(this.m_dateTo);
            m.saveEx();
        }
        catch (Exception e) {
            s_log.warning(e.getMessage());
        }
    }

    public void setConcept(String conceptValue, double value, boolean isRegistered) {
        try {
            MHRConcept c = MHRConcept.forValue(this.getCtx(), conceptValue);
            if (c == null) {
                return;
            }
            MHRMovement m = new MHRMovement(Env.getCtx(), 0, this.get_TrxName());
            m.setColumnType(c.getColumnType());
            if (c.getColumnType().equals("A")) {
                m.setAmount(BigDecimal.valueOf(value));
            } else if (c.getColumnType().equals("Q")) {
                m.setQty(BigDecimal.valueOf(value));
            } else {
                return;
            }
            m.setHR_Process_ID(this.getHR_Process_ID());
            m.setHR_Concept_ID(c.getHR_Concept_ID());
            m.setC_BPartner_ID(this.m_C_BPartner_ID);
            m.setDescription("Added From Rule");
            m.setValidFrom(this.m_dateTo);
            m.setValidTo(this.m_dateTo);
            m.setIsRegistered(isRegistered);
            m.saveEx();
        }
        catch (Exception e) {
            s_log.warning(e.getMessage());
        }
    }

    public double getConceptGroup(String pconcept) {
        MHRConceptCategory category = MHRConceptCategory.forValue(this.getCtx(), pconcept);
        if (category == null) {
            return 0.0;
        }
        double value = 0.0;
        MHRPayrollConcept[] mHRPayrollConceptArray = this.linesConcept;
        int n = this.linesConcept.length;
        int n2 = 0;
        while (n2 < n) {
            MHRMovement movement;
            MHRPayrollConcept pc = mHRPayrollConceptArray[n2];
            MHRConcept con = MHRConcept.get(this.getCtx(), pc.getHR_Concept_ID());
            if (con.getHR_Concept_Category_ID() == category.get_ID() && (movement = this.m_movement.get(pc.getHR_Concept_ID())) != null) {
                String columnType = movement.getColumnType();
                if ("A".equals(columnType)) {
                    value += movement.getAmount().doubleValue();
                } else if ("Q".equals(columnType)) {
                    value += movement.getQty().doubleValue();
                }
            }
            ++n2;
        }
        return value;
    }

    public double getList(String pList, double amount, String columnParam) {
        BigDecimal value = Env.ZERO;
        String column = columnParam;
        if (this.m_columnType.equals("A")) {
            column = column.toString().length() == 1 ? "Col_" + column : "Amount" + column;
            ArrayList<Object> params = new ArrayList<Object>();
            String sqlList = "SELECT " + column + " FROM HR_List l " + "INNER JOIN HR_ListVersion lv ON (lv.HR_List_ID=l.HR_List_ID) " + "INNER JOIN HR_ListLine ll ON (ll.HR_ListVersion_ID=lv.HR_ListVersion_ID) " + "WHERE l.IsActive='Y' AND lv.IsActive='Y' AND ll.IsActive='Y' AND l.Value = ? AND " + "l.AD_Client_ID = ? AND " + "(? BETWEEN lv.ValidFrom AND lv.ValidTo ) AND " + "(? BETWEEN ll.MinValue AND\tll.MaxValue)";
            params.add(pList);
            params.add(this.getAD_Client_ID());
            params.add(this.m_dateFrom);
            params.add(BigDecimal.valueOf(amount));
            value = DB.getSQLValueBDEx(this.get_TrxName(), sqlList, params);
        }
        if (value == null) {
            throw new IllegalStateException("getList Out of Range");
        }
        return value.doubleValue();
    }

    public double getAttribute(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0.0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) == null) {
            return 0.0;
        }
        if (concept.getColumnType().equals("Q")) {
            return attribute.getQty().doubleValue();
        }
        if (concept.getColumnType().equals("A")) {
            return attribute.getAmount().doubleValue();
        }
        return 0.0;
    }

    public Timestamp getAttributeDate(String conceptValue) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return null;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(conceptValue);
        if (!concept.getType().equals("I")) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) == null) {
            return null;
        }
        return attribute.getServiceDate();
    }

    public int getDays(Timestamp date1, Timestamp date2) {
        return TimeUtil.getDaysBetween(date1, date2) + 1;
    }

    public int getDays(String date1, String date2) {
        Timestamp dat1 = Timestamp.valueOf(date1);
        Timestamp dat2 = Timestamp.valueOf(date2);
        return this.getDays(dat1, dat2);
    }

    public int getMonths(Timestamp startParam, Timestamp endParam) {
        boolean negative = false;
        Timestamp end = endParam;
        Timestamp start = startParam;
        if (end.before(start)) {
            negative = true;
            Timestamp temp = start;
            start = end;
            end = temp;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(start);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.setTime(end);
        calEnd.set(11, 0);
        calEnd.set(12, 0);
        calEnd.set(13, 0);
        calEnd.set(14, 0);
        if (cal.get(1) == calEnd.get(1)) {
            if (negative) {
                return (calEnd.get(2) - cal.get(2)) * -1;
            }
            return calEnd.get(2) - cal.get(2);
        }
        int counter = 0;
        while (calEnd.after(cal)) {
            cal.add(2, 1);
            ++counter;
        }
        if (negative) {
            return counter * -1;
        }
        return counter;
    }

    public double getConcept(String conceptValue, int periodFrom, int periodTo) {
        return this.getConcept(conceptValue, null, periodFrom, periodTo);
    }

    public double getConcept(String conceptValue, String payrollValue, int periodFrom, int periodTo) {
        String fieldName;
        int payroll_id = payrollValue == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), payrollValue).get_ID();
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return 0.0;
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        MHRPeriod p2 = MHRPeriod.get(this.getCtx(), this.getHR_Period_ID());
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(this.m_C_BPartner_ID);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        params.add(payroll_id);
        if (periodFrom < 0) {
            whereClause.append(" AND pr.PeriodNo >= ?");
            params.add(p2.getPeriodNo() + periodFrom);
        }
        if (periodTo > 0) {
            whereClause.append(" AND pr.PeriodNo <= ?");
            params.add(p2.getPeriodNo() + periodTo);
        }
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx(this.get_TrxName(), sql.toString(), params);
        return value.doubleValue();
    }

    public double getConcept(String conceptValue, String payrollValue, Timestamp from, Timestamp to) {
        String fieldName;
        int payroll_id = payrollValue == null ? this.getHR_Payroll_ID() : MHRPayroll.forValue(this.getCtx(), payrollValue).get_ID();
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), conceptValue);
        if (concept == null) {
            return 0.0;
        }
        if ("Q".equals(concept.getColumnType())) {
            fieldName = "Qty";
        } else if ("A".equals(concept.getColumnType())) {
            fieldName = "Amount";
        } else {
            return 0.0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND HR_Concept_ID=?");
        params.add(concept.get_ID());
        whereClause.append(" AND C_BPartner_ID=?");
        params.add(this.m_C_BPartner_ID);
        whereClause.append(" AND validTo BETWEEN ? AND ?");
        params.add(from);
        params.add(to);
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Process p INNER JOIN HR_Period pr ON (pr.HR_Period_id=p.HR_Period_ID) WHERE HR_Movement.HR_Process_ID = p.HR_Process_ID AND p.HR_Payroll_ID=?");
        params.add(payroll_id);
        whereClause.append(")");
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(").append(fieldName).append("),0) FROM ").append("HR_Movement").append(" WHERE ").append(whereClause);
        BigDecimal value = DB.getSQLValueBDEx(this.get_TrxName(), sql.toString(), params);
        return value.doubleValue();
    }

    public double getAttribute(Properties ctx, String vAttribute, Timestamp dateFrom, Timestamp dateTo) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, Timestamp, Timestamp)");
        return 0.0;
    }

    public double getAttribute(Properties ctx, String vAttribute, int periodFrom, int periodTo, String pFrom, String pTo) {
        this.log.warning("not implemented yet -> getAttribute (Properties, String, int, int)");
        return 0.0;
    }

    public int getAttributeInvoice(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!"I".equals(concept.getType())) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)attribute.get_Value("C_Invoice_ID");
        }
        return 0;
    }

    public int getAttributeDocType(String pConcept) {
        MHRAttribute attribute;
        MHRConcept concept = MHRConcept.forValue(this.getCtx(), pConcept);
        if (concept == null) {
            return 0;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("ValidFrom<=?");
        params.add(this.m_dateFrom);
        whereClause.append(" AND AD_Client_ID = ?");
        params.add(this.getAD_Client_ID());
        whereClause.append(" AND EXISTS (SELECT 1 FROM HR_Concept c WHERE c.HR_Concept_ID=HR_Attribute.HR_Concept_ID AND c.Value = ?)");
        params.add(pConcept);
        if (!"I".equals(concept.getType())) {
            whereClause.append(" AND C_BPartner_ID = ?");
            params.add(this.m_C_BPartner_ID);
        }
        if ((attribute = (MHRAttribute)new Query(this.getCtx(), "HR_Attribute", whereClause.toString(), this.get_TrxName()).setParameters(params).setOrderBy("ValidFrom DESC").first()) != null) {
            return (Integer)attribute.get_Value("C_DocType_ID");
        }
        return 0;
    }

    public double getDays(int period) {
        return Env.getContextAsInt(this.getCtx(), "_DaysPeriod") + 1;
    }
}

