/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom;

import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTree;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.CheckboxTreeCellRenderer;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingEvent;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingListener;
import it.cnr.imaa.essi.lablib.gui.checkboxtree.TreeCheckingModel;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.form.bom.nodeUserObject;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class RadioButtonTreeCellRenderer
implements CheckboxTreeCellRenderer {
    JRadioButton button = new JRadioButton();
    JCheckBox checkBox = new JCheckBox();
    JPanel panel = new JPanel();
    JLabel label = new JLabel();
    boolean toggle = false;
    private Vector<Vector<Comparable<?>>> dataBOM = new Vector();
    public DefaultMutableTreeNode root = null;
    public HashSet<TreePath> checkedPathsSet = new HashSet();
    public HashSet<TreePath> greyedPathsSet = new HashSet();
    public HashSet<TreePath> disabledPathsSet = new HashSet();
    public HashSet<TreePath> checkBoxPathsSet = new HashSet();
    private static CLogger log = CLogger.getCLogger(RadioButtonTreeCellRenderer.class);

    public DefaultMutableTreeNode getTreeNodeForNodeUserObject(nodeUserObject m_nodeUserObject) {
        log.fine("In getTreeNodeForNodeUserObject");
        DefaultMutableTreeNode foundChild = null;
        Enumeration<TreeNode> children = this.root.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                if (m_nodeUserObject != (nodeUserObject)child.getUserObject()) continue;
                log.fine("nodeUserObjectFound");
                foundChild = child;
            }
        }
        return foundChild;
    }

    public static void printDescendents(TreeNode root) {
        log.fine(root.toString());
        Enumeration<? extends TreeNode> children = root.children();
        if (children != null) {
            while (children.hasMoreElements()) {
                RadioButtonTreeCellRenderer.printDescendents(children.nextElement());
            }
        }
    }

    public DefaultMutableTreeNode action_loadBOM(MProduct Product, boolean setRoot) {
        int M_Product_ID = Product.get_ID();
        MProduct M_Product = MProduct.get(Env.getCtx(), M_Product_ID);
        MUOM UOM = new MUOM(Env.getCtx(), M_Product.getC_UOM_ID(), null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new nodeUserObject(String.valueOf(Msg.translate(Env.getCtx(), "M_Product_ID")) + Msg.translate(Env.getCtx(), "Value") + ": " + M_Product.getValue() + " " + Msg.translate(Env.getCtx(), "Name") + ": " + M_Product.getName() + " " + Msg.translate(Env.getCtx(), "C_UOM_ID") + ": " + UOM.getName(), M_Product, null, null));
        if (setRoot) {
            this.root = root;
        }
        this.dataBOM.clear();
        String whereClause = "M_Product_ID=?";
        List boms = new Query(Env.getCtx(), "PP_Product_BOM", whereClause, null).setParameters(M_Product_ID).setOnlyActiveRecords(true).list();
        for (MPPProductBOM bom : boms) {
            DefaultMutableTreeNode child = this.parent(bom);
            root.add(child);
        }
        log.fine("root.getChildCount: " + root.getChildCount());
        if (root.getChildCount() > 0) {
            root = (DefaultMutableTreeNode)root.getFirstChild();
        }
        if (setRoot) {
            this.root = root;
        }
        return root;
    }

    public DefaultMutableTreeNode parent(MPPProductBOMLine bomline) {
        log.fine("In parent with X_PP_Product_BOMLine");
        MProduct M_Product = MProduct.get(Env.getCtx(), bomline.getM_Product_ID());
        MUOM UOM = new MUOM(Env.getCtx(), M_Product.getC_UOM_ID(), null);
        MPPProductBOM bomproduct = new MPPProductBOM(Env.getCtx(), bomline.getPP_Product_BOM_ID(), null);
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new nodeUserObject(String.valueOf(Msg.translate(Env.getCtx(), "M_Product_ID")) + Msg.translate(Env.getCtx(), "key") + ": " + M_Product.getValue() + " " + Msg.translate(Env.getCtx(), "Name") + ": " + M_Product.getName() + " " + Msg.translate(Env.getCtx(), "C_UOM_ID") + ": " + UOM.getName(), M_Product, bomproduct, bomline));
        Vector<Object> line = new Vector<Object>(17);
        line.add(new Boolean(false));
        line.add(new Boolean(true));
        line.add(new Integer(bomline.getLine()));
        line.add(bomline.getValidFrom());
        line.add(bomline.getValidTo());
        KeyNamePair pp = new KeyNamePair(M_Product.getM_Product_ID(), M_Product.getName());
        line.add(pp);
        KeyNamePair uom = new KeyNamePair(bomline.getC_UOM_ID(), "");
        line.add(uom);
        line.add(new Boolean(bomline.isQtyPercentage()));
        line.add(bomline.getQtyBatch());
        line.add(bomline.getQtyBOM() != null ? bomline.getQtyBOM() : new BigDecimal(0));
        line.add(new Boolean(bomline.isCritical()));
        line.add(bomline.getLeadTimeOffset());
        line.add(bomline.getAssay());
        line.add(bomline.getScrap());
        line.add(bomline.getIssueMethod());
        line.add(bomline.getBackflushGroup());
        line.add(bomline.getForecast());
        this.dataBOM.add(line);
        String whereClause = "M_Product_ID=?";
        List boms = new Query(Env.getCtx(), "PP_Product_BOM", whereClause, null).setParameters(bomproduct.getM_Product_ID()).setOnlyActiveRecords(true).list();
        Iterator iterator = boms.iterator();
        if (iterator.hasNext()) {
            MPPProductBOM bom = (MPPProductBOM)iterator.next();
            MProduct component = MProduct.get(Env.getCtx(), bom.getM_Product_ID());
            return this.component(component, bom, bomline);
        }
        return parent;
    }

    public DefaultMutableTreeNode parent(MPPProductBOM bom) {
        log.fine("Parent:" + bom.getName());
        MProduct product = MProduct.get(Env.getCtx(), bom.getM_Product_ID());
        String data = String.valueOf(Msg.translate(Env.getCtx(), "PP_Product_BOM_ID")) + " " + Msg.translate(Env.getCtx(), "Value") + ":" + bom.getValue() + " " + Msg.translate(Env.getCtx(), "Name") + ": " + bom.getName();
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new nodeUserObject(data, product, bom, null));
        String whereClause = "PP_Product_BOM_ID=?";
        List bomlines = new Query(Env.getCtx(), "PP_Product_BOMLine", whereClause, null).setParameters(bom.getPP_Product_BOM_ID()).list();
        for (MPPProductBOMLine bomline : bomlines) {
            MProduct component = MProduct.get(Env.getCtx(), bomline.getM_Product_ID());
            Vector<Object> line = new Vector<Object>(17);
            line.add(new Boolean(false));
            line.add(new Boolean(true));
            line.add(new Integer(bomline.getLine()));
            line.add(bomline.getValidFrom());
            line.add(bomline.getValidTo());
            KeyNamePair pp = new KeyNamePair(component.getM_Product_ID(), component.getName());
            line.add(pp);
            KeyNamePair uom = new KeyNamePair(bomline.getC_UOM_ID(), "");
            line.add(uom);
            line.add(new Boolean(bomline.isQtyPercentage()));
            line.add(bomline.getQtyBatch());
            line.add(bomline.getQtyBOM());
            line.add(new Boolean(bomline.isCritical()));
            line.add(bomline.getLeadTimeOffset());
            line.add(bomline.getAssay());
            line.add(bomline.getScrap());
            line.add(bomline.getIssueMethod());
            line.add(bomline.getBackflushGroup());
            line.add(bomline.getForecast());
            this.dataBOM.add(line);
            parent.add(this.component(component, bom, bomline));
        }
        return parent;
    }

    public DefaultMutableTreeNode component(MProduct M_Product, MPPProductBOM bomPassed, MPPProductBOMLine bomlinePassed) {
        MUOM UOM = new MUOM(Env.getCtx(), M_Product.getC_UOM_ID(), null);
        String whereClause = "Value=?";
        List boms = new Query(Env.getCtx(), "PP_Product_BOM", whereClause, null).setParameters(M_Product.getValue()).setOnlyActiveRecords(true).list();
        Iterator iterator = boms.iterator();
        if (iterator.hasNext()) {
            MPPProductBOM bom = (MPPProductBOM)iterator.next();
            return this.parent(bom);
        }
        return new DefaultMutableTreeNode(new nodeUserObject(String.valueOf(Msg.translate(Env.getCtx(), "Value")) + ": " + M_Product.getValue() + " " + Msg.translate(Env.getCtx(), "Name") + ": " + M_Product.getName() + " " + Msg.translate(Env.getCtx(), "C_UOM_ID") + ": " + UOM.getName(), M_Product, bomPassed, bomlinePassed));
    }

    @Override
    public boolean isOnHotspot(int x, int y) {
        return this.button.getBounds().contains(x, y);
    }

    protected TreePath[] getChildrenPath(TreePath path, TreeModel model) {
        Object node = path.getLastPathComponent();
        int childrenNumber = model.getChildCount(node);
        TreePath[] childrenPath = new TreePath[childrenNumber];
        int childIndex = 0;
        while (childIndex < childrenNumber) {
            childrenPath[childIndex] = path.pathByAddingChild(model.getChild(node, childIndex));
            ++childIndex;
        }
        return childrenPath;
    }

    public TreePath getPath(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        while (node != null) {
            list.add(node);
            node = node.getParent();
        }
        Collections.reverse(list);
        return new TreePath(list.toArray());
    }

    public void printTree(TreePath path, TreeModel model, TreeCheckingModel checkingModel) {
        log.fine("In printTree");
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        log.fine("Node: " + node);
        log.fine("isPathCheckbox: " + checkingModel.isPathCheckBox(this.getPath(node)));
        TreePath[] treePathArray = this.getChildrenPath(path, model);
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath childPath = treePathArray[n2];
            this.printTree(childPath, model, checkingModel);
            ++n2;
        }
    }

    public String getComponentTypeUsingBOMParent(int bom_id, int m_product_id) {
        String retVal = "";
        String sql = "select componenttype from pp_product_bomline where pp_product_bom_id = ? and m_product_id = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, 1003, 1007, "test");
            pstmt.setInt(1, bom_id);
            pstmt.setInt(2, m_product_id);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                retVal = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.fine("Execption; sql = " + sql + "; e.getMessage() = " + e.getMessage());
        }
        return retVal;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        log.fine("row: " + row);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        log.fine("treeNode.getLevel: " + treeNode.getLevel());
        nodeUserObject m_nodeUserObject = (nodeUserObject)treeNode.getUserObject();
        log.fine("m_nodeUserObject.toString: " + m_nodeUserObject.toString());
        log.fine("m_nodeUserObject.M_Product.getName: " + m_nodeUserObject.M_Product.getName());
        log.fine("value.toString: " + value.toString());
        this.label.setText(value.toString());
        TreeCheckingModel checkingModel = ((CheckboxTree)tree).getCheckingModel();
        TreePath path = tree.getPathForRow(row);
        boolean enabled = checkingModel.isPathEnabled(path);
        boolean checked = checkingModel.isPathChecked(path);
        checked = checkingModel.isPathChecked(path);
        this.button.setEnabled(true);
        this.button.setSelected(checked);
        m_nodeUserObject.isChosen = checked;
        log.fine("m_nodeUserObject.isChosen" + m_nodeUserObject.isChosen);
        if (m_nodeUserObject.isCheckbox || treeNode.isRoot()) {
            this.panel.add(this.checkBox);
            this.panel.remove(this.button);
            log.fine("checked: " + checked);
            log.fine("enabled: " + enabled);
            this.checkBox.setEnabled(enabled);
            this.checkBox.setSelected(checked);
            if (treeNode.isRoot()) {
                this.checkBox.setSelected(true);
                this.checkBox.setEnabled(false);
                m_nodeUserObject.isMandatory = true;
            }
            if (m_nodeUserObject.isMandatory) {
                this.checkBox.setSelected(true);
                this.checkBox.setEnabled(false);
            }
        } else {
            this.panel.remove(this.checkBox);
            this.panel.add(this.button);
        }
        this.panel.add(this.label);
        m_nodeUserObject.isChosen = checked;
        log.fine("m_nodeUserObject.isChosen: " + m_nodeUserObject.isChosen);
        if (m_nodeUserObject.bom != null) {
            log.fine("m_nodeUserObject.bom not null");
            log.fine("m_nodeUserObject.bom product_id: " + m_nodeUserObject.bom.getM_Product_ID());
            if (m_nodeUserObject.bomLine == null) {
                log.fine("m_nodeUserObject.bomLine is null");
                DefaultMutableTreeNode m_treeNode = this.getTreeNodeForNodeUserObject(m_nodeUserObject);
                if (!m_treeNode.isRoot()) {
                    DefaultMutableTreeNode m_treeNodeParent = (DefaultMutableTreeNode)m_treeNode.getParent();
                    if (m_treeNodeParent.isRoot()) {
                        m_nodeUserObject.isMandatory = true;
                    }
                    nodeUserObject m_nodeUserObjectParent = (nodeUserObject)m_treeNodeParent.getUserObject();
                    if (m_nodeUserObjectParent.bom != null) {
                        log.fine("m_nodeUserObjectParent.bom is not null");
                        log.fine("m_nodeUserObjectParent.bom.pp_product_bom_id: " + m_nodeUserObjectParent.bom.get_ID());
                        log.fine("m_nodeUserObject.M_Product.get_ID: " + m_nodeUserObject.M_Product.get_ID());
                        if (this.getComponentTypeUsingBOMParent(m_nodeUserObjectParent.bom.get_ID(), m_nodeUserObject.M_Product.get_ID()).equals("VA") || this.getComponentTypeUsingBOMParent(m_nodeUserObjectParent.bom.get_ID(), m_nodeUserObject.M_Product.get_ID()).equals("CO")) {
                            log.fine("Type is checkbox");
                            if (!m_nodeUserObject.isCheckbox) {
                                m_nodeUserObject.isCheckbox = true;
                                this.panel.remove(this.label);
                                this.panel.add(this.checkBox);
                                this.panel.add(this.label);
                                this.panel.remove(this.button);
                                if (!m_nodeUserObject.isChosen) {
                                    this.checkBox.setSelected(false);
                                    m_nodeUserObject.isChosen = false;
                                } else {
                                    this.checkBox.setSelected(true);
                                    m_nodeUserObject.isMandatory = true;
                                    m_nodeUserObject.isChosen = true;
                                }
                            }
                        }
                    } else {
                        log.fine("Type is checkbox");
                        if (!m_nodeUserObject.isCheckbox) {
                            this.panel.remove(this.label);
                            this.panel.add(this.checkBox);
                            this.panel.add(this.label);
                            this.panel.remove(this.button);
                        }
                    }
                }
            } else {
                log.fine("m_nodeUserObject.bomLine is not null");
                log.fine("m_nodeUserObject.M_Product.get_ID: " + m_nodeUserObject.M_Product.get_ID());
                log.fine("m_nodeUserObject.bomLine.getM_Product_ID: " + m_nodeUserObject.bomLine.getM_Product_ID());
                log.fine("m_nodeUserObject.isCheckbox: " + m_nodeUserObject.isCheckbox);
            }
        }
        this.panel.setBackground(Color.white);
        log.fine("m_nodeUserObject.isChosen: " + m_nodeUserObject.isChosen);
        return this.panel;
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        DefaultMutableTreeNode one = new DefaultMutableTreeNode("one");
        DefaultMutableTreeNode two = new DefaultMutableTreeNode("two");
        DefaultMutableTreeNode three = new DefaultMutableTreeNode("three");
        root.add(one);
        root.add(two);
        root.add(three);
        RadioButtonTreeCellRenderer m_RadioButtonTreeCellRenderer = new RadioButtonTreeCellRenderer();
        CheckboxTree tree = new CheckboxTree(m_RadioButtonTreeCellRenderer.action_loadBOM(null, false));
        tree.getCheckingModel().setCheckingMode(TreeCheckingModel.CheckingMode.SIMPLE);
        tree.getCheckingModel().clearChecking();
        tree.setCellRenderer(m_RadioButtonTreeCellRenderer);
        tree.addTreeCheckingListener(new TreeCheckingListener(){

            @Override
            public void valueChanged(TreeCheckingEvent e) {
                log.fine("Checked paths changed: user clicked on " + e.getLeadingPath().getLastPathComponent());
            }
        });
        JFrame frame = new JFrame("RadioButton tree");
        frame.add(tree);
        tree.expandAll();
        frame.pack();
        frame.setVisible(true);
    }
}

