/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.form.bom;

import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.compiere.model.MProduct;
import org.compiere.model.MResource;
import org.compiere.model.PO;
import org.compiere.util.Env;
import org.eevolution.form.bom.BOMMessenger;
import org.eevolution.form.bom.BOMTreeCellRenderer;
import org.eevolution.form.bom.BOMTreeModel;
import org.eevolution.model.MPPOrder;
import org.eevolution.model.reasoner.StorageReasoner;
import org.eevolution.model.wrapper.BOMLineWrapper;
import org.eevolution.model.wrapper.BOMWrapper;

public abstract class BOMTreeFactory
implements BOMTreeModel {
    protected JTree tree;
    protected HashMap mapping;
    protected BOMMessenger msg;
    private StorageReasoner reasoner;

    protected abstract String type();

    public static BOMTreeModel get(String bomType, PO po, StorageReasoner reasoner) {
        StorageReasoner r = reasoner;
        final String type = bomType;
        BOMTreeFactory factory = new BOMTreeFactory(){

            @Override
            protected String type() {
                return type;
            }
        };
        factory.buildTree(po, reasoner);
        return factory;
    }

    private StorageReasoner getStorageReasoner() {
        return this.reasoner;
    }

    protected void buildTree(PO po, StorageReasoner reasoner) {
        this.reasoner = reasoner;
        this.tree = new JTree(this.buildStructure(po, reasoner)){

            @Override
            public String getToolTipText(MouseEvent event) {
                return BOMTreeFactory.this.msg.getToolTipText(event);
            }
        };
        this.tree.setCellRenderer(new BOMTreeCellRenderer(this.getNodeMapping()));
        this.msg = new BOMMessenger(this.tree);
    }

    protected DefaultMutableTreeNode buildStructure(PO po, StorageReasoner reasoner) {
        this.mapping = new HashMap();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(po);
        this.mapping.put(root, this.getTreeNodeRepresentation(root));
        BOMWrapper bom = null;
        String restriction = null;
        if (po instanceof MProduct) {
            restriction = "M_Product_ID";
        } else if (po instanceof MPPOrder) {
            restriction = "PP_Order_ID";
        }
        int[] ids = reasoner.getPOIDs(BOMWrapper.tableName(this.type()), "IsActive = 'Y' AND " + restriction + " = " + po.get_ID(), null);
        int i = 0;
        while (i < ids.length) {
            bom = new BOMWrapper(Env.getCtx(), ids[i], null, this.type());
            root.add(this.getNode(bom, null, this.mapping));
            ++i;
        }
        return root;
    }

    protected DefaultMutableTreeNode getNode(BOMWrapper bom, BigDecimal qty, HashMap map) {
        MProduct product = new MProduct(Env.getCtx(), bom.getM_Product_ID(), "M_Product");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode(bom);
        map.put(parent, this.getTreeNodeRepresentation(parent));
        DefaultMutableTreeNode node = null;
        DefaultMutableTreeNode leaf = null;
        int[] ids = this.getStorageReasoner().getPOIDs(BOMLineWrapper.tableName(this.type()), String.valueOf(BOMWrapper.idColumn(this.type())) + " = " + bom.getID(), null);
        BOMLineWrapper bomline = null;
        MProduct p2 = null;
        int i = 0;
        while (i < ids.length) {
            bomline = new BOMLineWrapper(Env.getCtx(), ids[i], null, this.type());
            bomline.setQtyBOM(qty != null ? qty.multiply(bomline.getQtyBOM()) : bomline.getQtyBOM());
            p2 = new MProduct(Env.getCtx(), bomline.getM_Product_ID(), null);
            node = this.addLeafs(p2, qty, map);
            leaf = new DefaultMutableTreeNode(bomline);
            map.put(leaf, this.getTreeNodeRepresentation(leaf));
            parent.add(node == null ? leaf : node);
            ++i;
        }
        return parent;
    }

    protected DefaultMutableTreeNode addLeafs(MProduct M_Product, BigDecimal qty, HashMap map) {
        int[] ids = this.getStorageReasoner().getPOIDs(BOMWrapper.tableName(this.type()), "Value = '" + M_Product.getValue() + "'", null);
        BOMWrapper bom = null;
        int i = 0;
        if (i < ids.length) {
            bom = new BOMWrapper(Env.getCtx(), ids[i], null, this.type());
            return this.getNode(bom, qty, map);
        }
        return null;
    }

    protected String getTreeNodeRepresentation(DefaultMutableTreeNode node) {
        String name = null;
        if (node.getUserObject() instanceof MProduct) {
            MProduct p2 = (MProduct)node.getUserObject();
            name = String.valueOf(p2.getName()) + " (" + p2.getValue() + ")";
        }
        if (node.getUserObject() instanceof MPPOrder) {
            MPPOrder o = (MPPOrder)node.getUserObject();
            MResource r = MResource.get(Env.getCtx(), o.getS_Resource_ID());
            name = String.valueOf(o.getDocumentNo()) + " (" + r.getName() + ")";
        } else if (node.getUserObject() instanceof BOMWrapper) {
            BOMWrapper pb = (BOMWrapper)node.getUserObject();
            MProduct p3 = new MProduct(Env.getCtx(), pb.getM_Product_ID(), null);
            name = pb.getName();
        } else if (node.getUserObject() instanceof BOMLineWrapper) {
            BOMLineWrapper mpbl = (BOMLineWrapper)node.getUserObject();
            MProduct p4 = new MProduct(Env.getCtx(), mpbl.getM_Product_ID(), null);
            name = p4.getName();
        }
        return name;
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public HashMap getNodeMapping() {
        return this.mapping;
    }

    @Override
    public BOMMessenger getBOMMessenger() {
        return this.msg;
    }
}

