/*
 * Decompiled with CFR 0.152.
 */
package org.dpp.model;

import java.math.BigDecimal;
import org.compiere.model.MAsset;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelDPP
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelDPP.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing Model Price Validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        MOrder order;
        MInvoice inv;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MInvoice.Table_ID && (inv = (MInvoice)po).getC_Order_ID() > 0 && !inv.isSOTrx() && (order = new MOrder(inv.getCtx(), inv.getC_Order_ID(), inv.get_TrxName())).getC_DocType_ID() == 1000057) {
            MInvoiceLine[] lines = inv.getLines(false);
            int i = 0;
            while (i < lines.length) {
                MInvoiceLine line = lines[i];
                if (line.getA_Asset_ID() > 0) {
                    MAsset asset;
                    block9: {
                        asset = new MAsset(inv.getCtx(), line.getA_Asset_ID(), inv.get_TrxName());
                        int id_utm = DB.getSQLValue(po.get_TrxName(), "SELECT MAX(C_Currency_ID) FROM C_Currency WHERE Description like 'UTM' ");
                        BigDecimal amt3UTMclp = Env.ZERO;
                        BigDecimal totalAmtLineCLP = line.getLineTotalAmt();
                        if (id_utm > 0) {
                            amt3UTMclp = MConversionRate.convert(po.getCtx(), new BigDecimal("3.0"), id_utm, inv.getC_Currency_ID(), inv.getDateAcct(), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                            if (inv.getC_Currency_ID() != 228) {
                                totalAmtLineCLP = MConversionRate.convert(po.getCtx(), line.getLineTotalAmt(), inv.getC_Currency_ID(), 228, inv.getDateAcct(), 0, inv.getAD_Client_ID(), inv.getAD_Org_ID());
                            }
                            try {
                                if (totalAmtLineCLP.compareTo(amt3UTMclp) >= 0) {
                                    asset.setIsInPosession(true);
                                    break block9;
                                }
                                asset.setIsInPosession(false);
                            }
                            catch (Exception e) {
                                log.config("No se pudo hacer comparaci\u00f3n con moneda UTM" + e.toString());
                                asset.setIsInPosession(true);
                            }
                        } else {
                            asset.setIsInPosession(true);
                        }
                    }
                    asset.save();
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModelPrice");
        return sb.toString();
    }
}

