/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.db.AdempiereDatabase;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

public class TableCreateColumns
extends SvrProcess {
    private String p_EntityType = "C";
    private int p_AD_Table_ID = 0;
    private boolean p_AllTables = false;
    private int m_count = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("EntityType")) {
                this.p_EntityType = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("AllTables")) {
                this.p_AllTables = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.p_AD_Table_ID = this.getRecord_ID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        if (this.p_AD_Table_ID == 0) {
            throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_AD_Table_ID);
        }
        this.log.info("EntityType=" + this.p_EntityType + ", AllTables=" + this.p_AllTables + ", AD_Table_ID=" + this.p_AD_Table_ID);
        Connection conn = null;
        try {
            conn = DB.getConnectionRO();
            AdempiereDatabase db = DB.getDatabase();
            DatabaseMetaData md = conn.getMetaData();
            String catalog = db.getCatalog();
            String schema = db.getSchema();
            if (this.p_AllTables) {
                this.addTable(md, catalog, schema);
            } else {
                MTable table2 = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
                if (table2 == null || table2.get_ID() == 0) {
                    throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_AD_Table_ID);
                }
                this.log.info(table2.getTableName() + ", EntityType=" + this.p_EntityType);
                String tableName = table2.getTableName();
                if (DB.isOracle()) {
                    tableName = tableName.toUpperCase();
                }
                if (DB.isPostgreSQL()) {
                    tableName = tableName.toLowerCase();
                }
                ResultSet rs = md.getColumns(catalog, schema, tableName, null);
                this.addTableColumn(rs, table2);
            }
            String string = "#" + this.m_count;
            return string;
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private void addTable(DatabaseMetaData md, String catalog, String schema) throws Exception {
        ResultSet rs = DB.isPostgreSQL() ? md.getTables(catalog, schema, null, new String[]{"TABLE", "VIEW"}) : md.getTables(catalog, schema, null, null);
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            MTable table2 = MTable.get(this.getCtx(), tableName);
            if (table2 == null) {
                String tn = tableName.toUpperCase();
                if (tn.startsWith("T_SELECTION") || tn.endsWith("_VT") || tn.endsWith("_V") || tn.endsWith("_V1") || tn.startsWith("A_A") || tn.startsWith("A_D") || tn.indexOf(36) != -1 || tn.indexOf("EXPLAIN") != -1) {
                    this.log.fine("Ignored: " + tableName + " - " + tableType);
                    continue;
                }
                this.log.info(tableName + " - " + tableType);
                table2 = new MTable(this.getCtx(), 0, this.get_TrxName());
                table2.setEntityType(this.p_EntityType);
                table2.setName(tableName);
                table2.setTableName(tableName);
                table2.setIsView("VIEW".equals(tableType));
                if (!table2.save()) continue;
            }
            if (DB.isOracle()) {
                tableName = tableName.toUpperCase();
            }
            if (DB.isPostgreSQL()) {
                tableName = tableName.toLowerCase();
            }
            ResultSet rsC = md.getColumns(catalog, schema, tableName, null);
            this.addTableColumn(rsC, table2);
        }
    }

    private void addTableColumn(ResultSet rs, MTable table2) throws Exception {
        String tableName = table2.getTableName();
        if (DB.isOracle()) {
            tableName = tableName.toUpperCase();
        }
        if (DB.isPostgreSQL()) {
            tableName = tableName.toLowerCase();
        }
        while (rs.next()) {
            String columnName;
            MColumn column;
            String tn = rs.getString("TABLE_NAME");
            if (!tableName.equalsIgnoreCase(tn) || (column = table2.getColumn(columnName = rs.getString("COLUMN_NAME"))) != null) continue;
            int dataType = rs.getInt("DATA_TYPE");
            String typeName = rs.getString("TYPE_NAME");
            String nullable = rs.getString("IS_NULLABLE");
            int size = rs.getInt("COLUMN_SIZE");
            int digits = rs.getInt("DECIMAL_DIGITS");
            this.log.config(columnName + " - DataType=" + dataType + " " + typeName + ", Nullable=" + nullable + ", Size=" + size + ", Digits=" + digits);
            column = new MColumn(table2);
            column.set_TrxName(this.get_TrxName());
            column.setEntityType(this.p_EntityType);
            M_Element element = M_Element.get(this.getCtx(), columnName);
            if (element == null) {
                element = new M_Element(this.getCtx(), columnName, this.p_EntityType, this.get_TrxName());
                if (columnName.equalsIgnoreCase(table2.getTableName() + "_ID")) {
                    element.setColumnName(table2.getTableName() + "_ID");
                    element.setName(table2.getName());
                    element.setPrintName(table2.getName());
                }
                element.save();
            }
            column.setColumnName(element.getColumnName());
            column.setName(element.getName());
            column.setDescription(element.getDescription());
            column.setHelp(element.getHelp());
            column.setAD_Element_ID(element.getAD_Element_ID());
            column.setIsMandatory("NO".equals(nullable));
            if (columnName.equalsIgnoreCase(tableName + "_ID")) {
                column.setIsKey(true);
                column.setAD_Reference_ID(13);
                column.setIsUpdateable(false);
            } else if (columnName.toUpperCase().endsWith("_ACCT") && size == 10) {
                column.setAD_Reference_ID(25);
            } else if (columnName.equalsIgnoreCase("C_Location_ID")) {
                column.setAD_Reference_ID(21);
            } else if (columnName.equalsIgnoreCase("M_AttributeSetInstance_ID")) {
                column.setAD_Reference_ID(35);
            } else if (columnName.equalsIgnoreCase("SalesRep_ID")) {
                column.setAD_Reference_ID(18);
                column.setAD_Reference_Value_ID(190);
            } else if (columnName.toUpperCase().endsWith("_ID")) {
                column.setAD_Reference_ID(19);
            } else if (dataType == 91 || dataType == 92 || dataType == 93 || columnName.equalsIgnoreCase("Created") || columnName.equalsIgnoreCase("Updated")) {
                column.setAD_Reference_ID(16);
            } else if (columnName.equalsIgnoreCase("CreatedBy") || columnName.equalsIgnoreCase("UpdatedBy")) {
                column.setAD_Reference_ID(18);
                column.setAD_Reference_Value_ID(110);
                column.setIsUpdateable(false);
            } else if (columnName.equalsIgnoreCase("EntityType")) {
                column.setAD_Reference_ID(18);
                column.setAD_Reference_Value_ID(389);
            } else if (dataType == 2005) {
                column.setAD_Reference_ID(36);
            } else if (dataType == 2004) {
                column.setAD_Reference_ID(23);
            } else if (columnName.toUpperCase().indexOf("AMT") != -1) {
                column.setAD_Reference_ID(12);
            } else if (columnName.toUpperCase().indexOf("QTY") != -1) {
                column.setAD_Reference_ID(29);
            } else if (size == 1 && (columnName.toUpperCase().startsWith("IS") || dataType == 1)) {
                column.setAD_Reference_ID(20);
            } else if (size < 4 && dataType == 1) {
                column.setAD_Reference_ID(17);
            } else if (columnName.equalsIgnoreCase("Name") || columnName.equals("DocumentNo")) {
                column.setAD_Reference_ID(10);
                column.setIsIdentifier(true);
                column.setSeqNo(1);
            } else if (dataType == 1 || dataType == 12 || typeName.startsWith("NVAR") || typeName.startsWith("NCHAR")) {
                if (typeName.startsWith("N")) {
                    size /= 2;
                }
                if (size > 255) {
                    column.setAD_Reference_ID(14);
                } else {
                    column.setAD_Reference_ID(10);
                }
            } else if (dataType == 4 || dataType == 5 || dataType == 3 || dataType == 2) {
                if (size == 10) {
                    column.setAD_Reference_ID(11);
                } else {
                    column.setAD_Reference_ID(22);
                }
            } else {
                column.setAD_Reference_ID(10);
            }
            column.setFieldLength(size);
            if (column.isUpdateable() && (table2.isView() || columnName.equalsIgnoreCase("AD_Client_ID") || columnName.equalsIgnoreCase("AD_Org_ID") || columnName.toUpperCase().startsWith("CREATED") || columnName.toUpperCase().equals("UPDATED"))) {
                column.setIsUpdateable(false);
            }
            if (!column.save()) continue;
            this.addLog(0, null, null, table2.getTableName() + "." + column.getColumnName());
            ++this.m_count;
        }
    }
}

