/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_PaymentMassive;
import org.compiere.model.X_C_PaymentMassiveLine;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;

public class ProcessPaymentMassive
extends SvrProcess {
    private Properties m_ctx;
    private int p_PaymentMassive_ID = 0;

    @Override
    protected void prepare() {
        this.p_PaymentMassive_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    @Override
    protected String doIt() throws Exception {
        X_C_PaymentMassive massive = new X_C_PaymentMassive(this.m_ctx, this.p_PaymentMassive_ID, this.get_TrxName());
        MPayment payment = new MPayment(this.m_ctx, 0, this.get_TrxName());
        if (massive.getDocStatus().equals("CO") || massive.getDocStatus().equals("VO")) {
            return "";
        }
        payment.setAD_Org_ID(massive.getAD_Org_ID());
        payment.setC_BankAccount_ID(massive.getC_BankAccount_ID());
        payment.setC_BPartner_ID(massive.getC_BPartner_ID());
        payment.setPayAmt(massive.getPayAmt());
        payment.setCheckNo(massive.getCheckNo());
        payment.setTenderType(massive.getTenderType());
        payment.setC_Currency_ID(massive.getC_Currency_ID());
        payment.setDateTrx(massive.getDateTrx());
        payment.setC_DocType_ID(massive.getC_DocType_ID());
        if (!payment.save()) {
            return "No se puede Completar - crear el Pago";
        }
        payment.processIt("CO");
        payment.save();
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, massive.getDateTrx(), massive.getC_Currency_ID(), "Payment Massive", this.get_TrxName());
        alloc.setAD_Org_ID(massive.getAD_Org_ID());
        if (!alloc.save()) {
            this.log.log(Level.SEVERE, "Allocation not created");
            return "Allocation not created";
        }
        X_C_PaymentMassiveLine[] lines = massive.getLines();
        if (lines.length == 0) {
            this.log.log(Level.SEVERE, "no Lines");
            return "No Lines";
        }
        int i = 0;
        while (i < lines.length) {
            MAllocationLine aLine = new MAllocationLine(alloc, lines[i].getPayAmt().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Invoice_ID(lines[i].getC_Invoice_ID());
            aLine.setC_Payment_ID(payment.getC_Payment_ID());
            if (!aLine.save()) {
                this.log.log(Level.SEVERE, "Allocation Line not written ");
            }
            ++i;
        }
        alloc.processIt("CO");
        alloc.save();
        massive.setC_Payment_ID(payment.getC_Payment_ID());
        massive.setDocStatus("CO");
        massive.setProcessed(true);
        massive.save();
        this.commitEx();
        return "Pago Creado:" + payment.getDocumentNo();
    }
}

